/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rap.demo.controls.CheckboxEditingSupport;
import org.eclipse.rap.demo.controls.CheckboxTableViewerColumn;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class TableViewerTab
extends ExampleTab {
    private static final int ADD_ITEMS = 100;
    private static final int COL_FIRST_NAME = 0;
    private static final int COL_LAST_NAME = 1;
    private static final int COL_AGE = 2;
    private static final int COL_MARRIED = 3;
    private final PersonFilter viewerFilter;
    private final List<Person> persons = new ArrayList<Person>();
    private Image uncheckedImage;
    private Image checkedImage;
    private TableViewer viewer;
    private TableViewerColumn firstNameColumn;
    private TableViewerColumn lastNameColumn;
    private TableViewerColumn ageColumn;
    private CheckboxTableViewerColumn marriedColumn;
    private Label lblSelection;
    private Button btnCreateCellEditor;

    public TableViewerTab() {
        super("TableViewer");
        this.viewerFilter = new PersonFilter();
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("MULTI", 2);
        this.createStyleButton("VIRTUAL", 0x10000000);
        this.createAddItemsButton();
        this.createSelectYoungestPersonButton();
        this.createRemoveButton();
        this.createCellEditorButton();
        this.lblSelection = new Label(this.styleComp, 64);
    }

    private void initializeImages() {
        if (this.uncheckedImage == null || this.checkedImage == null) {
            this.uncheckedImage = this.loadImage("resources/unchecked.png");
            this.checkedImage = this.loadImage("resources/checked.png");
        }
    }

    @Override
    protected void createExampleControls(Composite parent) {
        this.initializeImages();
        if (this.btnCreateCellEditor != null && !this.btnCreateCellEditor.isDisposed()) {
            this.btnCreateCellEditor.setEnabled(true);
        }
        parent.setLayout((Layout)new GridLayout(2, false));
        Label lblFilter = new Label(parent, 0);
        lblFilter.setText("Filter");
        lblFilter.setEnabled((this.getStyle() & 0x10000000) == 0);
        Text txtFilter = new Text(parent, 2048);
        txtFilter.setEnabled((this.getStyle() & 0x10000000) == 0);
        txtFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.widget;
                TableViewerTab.this.viewerFilter.setText(text.getText());
                TableViewerTab.this.viewer.refresh();
            }
        });
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().dispose();
        }
        this.initPersons();
        this.createViewer(parent);
        this.registerControl(this.viewer.getControl());
    }

    private void initPersons() {
        this.persons.clear();
        this.persons.add(new Person("Ada", "Lovelace", 1815, true));
        this.persons.add(new Person("John", "von Neumann", 1903, true));
        this.persons.add(new Person("Kurt", "G\u00f6del", 1906, true));
        this.persons.add(new Person("Grace Murray", "Hopper", 1906, true));
        this.persons.add(new Person("Alan", "Turing", 1912, false));
        this.persons.add(new Person("Claude", "Shannon", 1916, true));
        this.persons.add(new Person("John", "Backus", 1924, true));
        this.persons.add(new Person("Alan", "Kay", 1940, true));
        this.persons.add(new Person("Dennis", "Ritchie", 1941, true));
        this.persons.add(new Person("David", "Parnas", 1941, true));
        this.persons.add(new Person("Larry", "Wall", 1954, true));
        this.persons.add(new Person("Linus", "Torvalds", 1969, true));
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, this.getStyle());
        this.viewer.setContentProvider(this.createContentProvider());
        this.firstNameColumn = this.createFirstNameColumn();
        this.lastNameColumn = this.createLastNameColumn();
        this.ageColumn = this.createAgeColumn();
        this.marriedColumn = this.createMarriedColumn();
        this.viewer.setInput(this.persons);
        this.viewer.setItemCount(this.persons.size());
        this.viewer.addFilter((ViewerFilter)this.viewerFilter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableViewerTab.this.lblSelection.setText("Selection: " + event.getSelection());
                TableViewerTab.this.lblSelection.getParent().layout(new Control[]{TableViewerTab.this.lblSelection});
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setData("org.eclipse.rap.rwt.tooltipMarkupEnabled", (Object)Boolean.TRUE);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.horizontalSpan = 2;
        table.setLayoutData((Object)tableData);
    }

    private IContentProvider createContentProvider() {
        Object result = (this.getStyle() & 0x10000000) == 0 ? new PersonContentProvider() : new LazyPersonContentProvider();
        return result;
    }

    private TableViewerColumn createFirstNameColumn() {
        TableViewerColumn result = new TableViewerColumn(this.viewer, 0);
        result.setLabelProvider((CellLabelProvider)new PersonLabelProvider(0));
        TableColumn column = result.getColumn();
        column.setText("First Name");
        column.setWidth(170);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sortDirection = TableViewerTab.updateSortDirection((TableColumn)event.widget);
                TableViewerTab.sort(TableViewerTab.this.viewer, 0, sortDirection == 1024);
            }
        });
        return result;
    }

    private TableViewerColumn createLastNameColumn() {
        TableViewerColumn result = new TableViewerColumn(this.viewer, 0);
        result.setLabelProvider((CellLabelProvider)new PersonLabelProvider(1));
        TableColumn column = result.getColumn();
        column.setText("Last Name");
        column.setWidth(120);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sortDirection = TableViewerTab.updateSortDirection((TableColumn)event.widget);
                TableViewerTab.sort(TableViewerTab.this.viewer, 1, sortDirection == 1024);
            }
        });
        return result;
    }

    private TableViewerColumn createAgeColumn() {
        TableViewerColumn result = new TableViewerColumn(this.viewer, 0);
        result.setLabelProvider((CellLabelProvider)new PersonLabelProvider(2));
        TableColumn column = result.getColumn();
        column.setText("Born");
        column.setWidth(80);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sortDirection = TableViewerTab.updateSortDirection((TableColumn)event.widget);
                TableViewerTab.sort(TableViewerTab.this.viewer, 2, sortDirection == 1024);
            }
        });
        return result;
    }

    private CheckboxTableViewerColumn createMarriedColumn() {
        CheckboxTableViewerColumn result = new CheckboxTableViewerColumn(this.viewer, 0);
        result.setLabelProvider((ILabelProvider)new PersonLabelProvider(3));
        TableColumn column = result.getColumn();
        column.setText("Married");
        column.setWidth(60);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sortDirection = TableViewerTab.updateSortDirection((TableColumn)event.widget);
                TableViewerTab.sort(TableViewerTab.this.viewer, 3, sortDirection == 1024);
            }
        });
        return result;
    }

    private void createAddItemsButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Add 100 Items");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = 0;
                while (i < 100) {
                    int counter = 11 + i;
                    TableViewerTab.this.persons.add(new Person("new " + counter, "person " + counter, counter, false));
                    ++i;
                }
                TableViewerTab.this.getViewer().setInput((Object)TableViewerTab.this.persons);
                if ((TableViewerTab.this.getStyle() & 0x10000000) != 0) {
                    TableViewerTab.this.getViewer().setItemCount(TableViewerTab.this.persons.size());
                }
            }
        });
    }

    private void createSelectYoungestPersonButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Select youngest Person");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Person youngestPerson = null;
                int minAge = Integer.MAX_VALUE;
                int i = 0;
                while (i < TableViewerTab.this.persons.size()) {
                    Person person = (Person)TableViewerTab.this.persons.get(i);
                    if (person.age < minAge) {
                        minAge = person.age;
                        youngestPerson = person;
                    }
                    ++i;
                }
                TableViewerTab.this.getViewer().setSelection((ISelection)new StructuredSelection(youngestPerson));
                TableViewerTab.this.getViewer().reveal(youngestPerson);
            }
        });
    }

    private void createRemoveButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Remove selected rows");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TableViewerTab.this.getViewer().getSelection();
                for (Person person : selection) {
                    TableViewerTab.this.persons.remove(person);
                }
                TableViewerTab.this.getViewer().getTable().setTopIndex(0);
                if ((TableViewerTab.this.getViewer().getTable().getStyle() & 0x10000000) != 0) {
                    TableViewerTab.this.getViewer().setItemCount(TableViewerTab.this.persons.size());
                }
                TableViewerTab.this.getViewer().setInput((Object)TableViewerTab.this.persons);
            }
        });
    }

    private void createCellEditorButton() {
        this.btnCreateCellEditor = new Button(this.styleComp, 8);
        this.btnCreateCellEditor.setText("Create Cell Editor");
        this.btnCreateCellEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableViewerTab.this.createCellEditor();
                TableViewerTab.this.btnCreateCellEditor.setEnabled(false);
            }
        });
    }

    private void createCellEditor() {
        EditingSupport editingSupport = new FirstNameEditingSupport(this.viewer);
        this.firstNameColumn.setEditingSupport(editingSupport);
        editingSupport = new LastNameEditingSupport(this.viewer, this.getLastNames());
        this.lastNameColumn.setEditingSupport(editingSupport);
        editingSupport = new AgeEditingSupport(this.viewer);
        this.ageColumn.setEditingSupport(editingSupport);
        this.marriedColumn.setEditingSupport(new MarriedEditingSupport());
        EditorActivationStrategy activationStrategy = new EditorActivationStrategy((ColumnViewer)this.viewer);
        FocusCellOwnerDrawHighlighter highlighter = new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer);
        TableViewerFocusCellManager focusManager = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)highlighter);
        int feature = 18;
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)focusManager, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)feature);
        this.marriedColumn.attachToEditor();
    }

    private static int updateSortDirection(TableColumn column) {
        Table table = column.getParent();
        if (column == table.getSortColumn()) {
            if (table.getSortDirection() == 128) {
                table.setSortDirection(1024);
            } else {
                table.setSortDirection(128);
            }
        } else {
            table.setSortColumn(column);
            table.setSortDirection(1024);
        }
        return table.getSortDirection();
    }

    private static void sort(TableViewer viewer, int property, boolean ascending) {
        if ((viewer.getControl().getStyle() & 0x10000000) != 0) {
            List input = (List)viewer.getInput();
            Collections.sort(input, new PersonComparator(property, ascending));
            viewer.refresh();
        } else {
            viewer.setComparator((ViewerComparator)new PersonComparator(property, ascending));
        }
    }

    private TableViewer getViewer() {
        return this.viewer;
    }

    private String[] getLastNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Person person : this.persons) {
            if (person.lastName.length() <= 0) continue;
            list.add(person.lastName);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    private static final class AgeEditingSupport
    extends EditingSupport {
        private final CellEditor editor;

        public AgeEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.editor = new TextCellEditor((Composite)viewer.getTable());
            this.editor.setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    String result = null;
                    try {
                        Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String text = "''{0}'' is not a valid age.";
                        result = MessageFormat.format(text, value);
                    }
                    return result;
                }
            });
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            Person person = (Person)element;
            return String.valueOf(person.age);
        }

        protected void setValue(Object element, Object value) {
            if (value != null) {
                Person person = (Person)element;
                person.age = Integer.parseInt((String)value);
                this.getViewer().update(element, null);
            }
        }
    }

    private static final class EditorActivationStrategy
    extends ColumnViewerEditorActivationStrategy {
        private EditorActivationStrategy(ColumnViewer viewer) {
            super(viewer);
            this.setEnableEditorActivationWithKeyboard(true);
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            boolean result = event.character == '\r' ? true : super.isEditorActivationEvent(event);
            return result;
        }
    }

    private static final class FirstNameEditingSupport
    extends EditingSupport {
        private final CellEditor editor;

        public FirstNameEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.editor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            Person person = (Person)element;
            String result = person.firstName;
            return result;
        }

        protected void setValue(Object element, Object value) {
            Person person = (Person)element;
            person.firstName = (String)value;
            this.getViewer().update(element, null);
        }
    }

    private static final class LastNameEditingSupport
    extends EditingSupport {
        private final CellEditor editor;

        public LastNameEditingSupport(TableViewer viewer, String[] suggestions) {
            super((ColumnViewer)viewer);
            this.editor = new ComboBoxCellEditor((Composite)viewer.getTable(), suggestions, 0);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            Person person = (Person)element;
            CCombo ccombo = (CCombo)this.editor.getControl();
            ccombo.setText(person.lastName);
            return new Integer(-2);
        }

        protected void setValue(Object element, Object value) {
            Person person = (Person)element;
            CCombo ccombo = (CCombo)this.editor.getControl();
            person.lastName = ccombo.getText();
            this.getViewer().update(element, null);
        }
    }

    private static final class LazyPersonContentProvider
    implements ILazyContentProvider {
        private TableViewer tableViewer;
        private List<?> elements;

        private LazyPersonContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.tableViewer = (TableViewer)viewer;
            this.elements = (List)newInput;
        }

        public void updateElement(int index) {
            this.tableViewer.replace(this.elements.get(index), index);
        }

        public void dispose() {
        }
    }

    private static class MarriedEditingSupport
    extends CheckboxEditingSupport {
        private MarriedEditingSupport() {
        }

        @Override
        public boolean canEdit(Object element) {
            return true;
        }

        @Override
        public Boolean getValue(Object element) {
            Person person = (Person)element;
            return person.married;
        }

        @Override
        public void setValue(Object element, Boolean value) {
            Person person = (Person)element;
            person.married = value;
        }
    }

    private static final class Person {
        String firstName;
        String lastName;
        int age;
        boolean married;

        public Person(String firstName, String lastName, int age, boolean married) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
            this.married = married;
        }

        public String toString() {
            return String.valueOf(this.firstName) + " " + this.lastName + " " + this.age + " " + this.married;
        }
    }

    private static final class PersonComparator
    extends ViewerComparator
    implements Comparator<Person> {
        private final boolean ascending;
        private final int property;

        public PersonComparator(int property, boolean ascending) {
            this.property = property;
            this.ascending = ascending;
        }

        public int compare(Viewer viewer, Object object1, Object object2) {
            return this.compare((Person)object1, (Person)object2);
        }

        public boolean isSorterProperty(Object elem, String property) {
            return true;
        }

        @Override
        public int compare(Person person1, Person person2) {
            int result = 0;
            if (this.property == 0) {
                result = person1.firstName.compareTo(person2.firstName);
            } else if (this.property == 1) {
                result = person1.lastName.compareTo(person2.lastName);
            } else if (this.property == 2) {
                result = person1.age - person2.age;
            } else if (this.property == 3) {
                if (person1.married && !person2.married) {
                    result = -1;
                } else if (!person1.married && person2.married) {
                    result = 1;
                }
            }
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }
    }

    private static final class PersonContentProvider
    implements IStructuredContentProvider {
        Object[] elements;

        private PersonContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                this.elements = new Object[0];
            } else {
                List personList = (List)newInput;
                this.elements = personList.toArray();
            }
        }

        public void dispose() {
        }
    }

    private static final class PersonFilter
    extends ViewerFilter {
        private String text;

        private PersonFilter() {
        }

        public void setText(String string) {
            this.text = string;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = true;
            Person person = (Person)element;
            if (this.text != null && this.text.length() > 0) {
                String personText = person.toString().toLowerCase();
                result = personText.indexOf(this.text.toLowerCase()) != -1;
            }
            return result;
        }

        public boolean isFilterProperty(Object element, String prop) {
            return true;
        }
    }

    private class PersonLabelProvider
    extends ColumnLabelProvider {
        private final int columnIndex;
        private final Color nameBackground;

        public PersonLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
            this.nameBackground = new Color((Device)Display.getCurrent(), 248, 248, 248);
        }

        public String getText(Object element) {
            Person person = (Person)element;
            String result = person.toString();
            switch (this.columnIndex) {
                case 0: {
                    result = person.firstName;
                    break;
                }
                case 1: {
                    result = person.lastName;
                    break;
                }
                case 2: {
                    result = String.valueOf(person.age);
                    break;
                }
                case 3: {
                    result = person.married ? "yes" : "no";
                }
            }
            return result;
        }

        public Image getImage(Object element) {
            Image result = null;
            if (this.columnIndex == 3) {
                Person person = (Person)element;
                result = person.married ? TableViewerTab.this.checkedImage : TableViewerTab.this.uncheckedImage;
            }
            return result;
        }

        public Color getBackground(Object element) {
            Color result = null;
            switch (this.columnIndex) {
                case 0: 
                case 1: {
                    result = this.nameBackground;
                }
            }
            return result;
        }

        public String getToolTipText(Object element) {
            Person person = (Person)element;
            String text = null;
            switch (this.columnIndex) {
                case 0: {
                    text = "<i>" + person.firstName + "</i>";
                    break;
                }
                case 1: {
                    text = person.lastName;
                    break;
                }
                case 2: {
                    text = String.valueOf(person.age);
                    break;
                }
                case 3: {
                    text = person.married ? "yes" : "no";
                }
            }
            return text;
        }
    }
}

