/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseId;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;

public class ProcessActionRunner {
    private static final String ATTR_RUNNABLE_LIST = ProcessActionRunner.class.getName();

    public static void add(Runnable runnable) {
        PhaseId phaseId = CurrentPhase.get();
        if (PhaseId.PREPARE_UI_ROOT.equals(phaseId) || PhaseId.PROCESS_ACTION.equals(phaseId)) {
            runnable.run();
        } else {
            ServiceStore serviceStore = ContextProvider.getServiceStore();
            ArrayList<Runnable> list = (ArrayList<Runnable>)serviceStore.getAttribute(ATTR_RUNNABLE_LIST);
            if (list == null) {
                list = new ArrayList<Runnable>();
                serviceStore.setAttribute(ATTR_RUNNABLE_LIST, list);
            }
            if (!list.contains(runnable)) {
                list.add(runnable);
            }
        }
    }

    public static boolean executeNext() {
        boolean result = false;
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        List list = (List)serviceStore.getAttribute(ATTR_RUNNABLE_LIST);
        if (list != null && list.size() > 0) {
            Runnable runnable = (Runnable)list.remove(0);
            runnable.run();
            result = true;
        }
        return result;
    }

    public static void execute() {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        List list = (List)serviceStore.getAttribute(ATTR_RUNNABLE_LIST);
        if (list != null) {
            Runnable[] runables = list.toArray(new Runnable[list.size()]);
            int i = 0;
            while (i < runables.length) {
                runables[i].run();
                ++i;
            }
        }
    }
}

