/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.IColumnAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    private static final int SORT_INDICATOR_WIDTH = 10;
    private static final int MARGIN_IMAGE = 3;
    private Tree parent;
    private final IColumnAdapter columnAdapter;
    private int width;
    private String toolTipText;
    private boolean resizable;
    private boolean moveable;
    private int sort;
    int itemImageCount;
    private boolean packed;

    public TreeColumn(Tree parent, int style) {
        this(parent, style, TreeColumn.checkNull((Tree)parent).columnHolder.size());
    }

    public TreeColumn(Tree parent, int style, int index) {
        super(parent, TreeColumn.checkStyle(style));
        if (index < 0 || index > parent.columnHolder.size()) {
            this.error(6);
        }
        this.parent = parent;
        this.sort = 0;
        this.resizable = true;
        this.columnAdapter = new ColumnAdapter();
        parent.createColumn(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(10, typedListener);
        this.addListener(11, typedListener);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(10, listener);
        this.removeListener(11, listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    static int checkStyle(int style) {
        return TreeColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            this.dispose(true);
        }
    }

    void dispose(boolean notifyParent) {
        super.dispose();
        this.parent = null;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth() {
        int result = 0;
        Font font = this.parent.getHeaderFont();
        if (this.text.length() > 0) {
            result = this.text.indexOf(10) != -1 ? TextSizeUtil.textExtent((Font)font, (String)this.text, (int)0).x : TextSizeUtil.stringExtent((Font)font, (String)this.text).x;
        }
        if (this.image != null) {
            result += this.image.getBounds().width;
            if (this.text.length() > 0) {
                result += 3;
            }
        }
        if (this.sort != 0) {
            result += 10;
            if (this.text.length() > 0 || this.image != null) {
                result += 3;
            }
        }
        BoxDimensions headerPadding = this.parent.getThemeAdapter().getHeaderPadding(this.parent);
        return result + headerPadding.left + headerPadding.right + 1;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    public void pack() {
        this.checkWidget();
        int newWidth = this.getPreferredWidth();
        int contentWidth = this.parent.getMaxContentWidth(this);
        newWidth = Math.max(newWidth, contentWidth);
        if (newWidth < 12) {
            newWidth = 12;
        }
        this.setWidth(newWidth);
        this.packed = true;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int newAlignment = TreeColumn.checkBits(alignment, 16384, 0x1000000, 131072, 0, 0, 0);
        if ((this.style & newAlignment) != 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= newAlignment;
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
    }

    public void setResizable(boolean value) {
        this.checkWidget();
        this.resizable = value;
    }

    void setSortDirection(int value) {
        if (value != this.sort) {
            this.sort = value;
        }
    }

    @Override
    public void setText(String value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        if (!value.equals(this.text)) {
            super.setText(value);
            this.parent.layoutCache.invalidateHeaderHeight();
        }
    }

    public void setToolTipText(String toolTipText) {
        this.checkWidget();
        if (toolTipText != null && MarkupUtil.isToolTipMarkupEnabledFor(this) && !MarkupValidator.isValidationDisabledFor(this)) {
            MarkupValidator.getInstance().validate(toolTipText);
        }
        this.toolTipText = toolTipText;
    }

    public void setWidth(int value) {
        this.checkWidget();
        if (value >= 0 && this.width != value) {
            this.width = value;
            this.parent.updateScrollBars();
            this.notifyListeners(11, new Event());
            this.processNextColumnsMoveEvent();
            this.packed = false;
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        IColumnAdapter result = null;
        result = adapter == IColumnAdapter.class ? this.columnAdapter : super.getAdapter(adapter);
        return (T)result;
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        this.parent.layoutCache.invalidateHeaderHeight();
    }

    @Override
    public void setData(String key, Object value) {
        if ("org.eclipse.rap.rwt.customVariant".equals(key)) {
            this.parent.layoutCache.invalidateAll();
        }
        if (!"org.eclipse.rap.rwt.tooltipMarkupEnabled".equals(key) || !MarkupUtil.isToolTipMarkupEnabledFor(this)) {
            super.setData(key, value);
        }
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        this.parent.destroyColumn(this);
    }

    private void processNextColumnsMoveEvent() {
        int[] columnsOrder = this.parent.getColumnOrder();
        boolean found = false;
        int i = 0;
        while (i < columnsOrder.length) {
            TreeColumn column = this.parent.getColumn(columnsOrder[i]);
            if (column == this) {
                found = true;
            } else if (found) {
                column.notifyListeners(10, new Event());
            }
            ++i;
        }
    }

    final int getLeft() {
        int result = 0;
        TreeColumn[] columns = this.parent.getColumns();
        int[] columnOrder = this.parent.getColumnOrder();
        int orderedIndex = -1;
        int i = 0;
        while (orderedIndex == -1 && i < columnOrder.length) {
            if (columnOrder[i] == this.parent.indexOf(this)) {
                orderedIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < orderedIndex) {
            result += columns[columnOrder[i]].getWidth();
            ++i;
        }
        return result;
    }

    private final class ColumnAdapter
    implements IColumnAdapter,
    SerializableCompatibility {
        private ColumnAdapter() {
        }

        @Override
        public boolean isPacked() {
            return TreeColumn.this.packed;
        }
    }
}

