/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemLCA;
import org.eclipse.swt.widgets.AcceleratorBinding;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    private final Menu parent;
    private Menu menu;
    private DisposeListener menuDisposeListener;
    private boolean selection;
    private int userId;
    private AcceleratorBinding acceleratorBinding;
    private String toolTipText;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.getAdapter(IItemHolderAdapter.class).add(this);
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.getAdapter(IItemHolderAdapter.class).insert(this, index);
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (this.menu != menu) {
            if ((this.style & 0x40) == 0) {
                SWT.error(27);
            }
            if (menu != null) {
                if (menu.isDisposed()) {
                    SWT.error(5);
                }
                if ((menu.getStyle() & 4) == 0) {
                    SWT.error(21);
                }
                if (menu.getParent() != this.getParent().getParent()) {
                    SWT.error(32);
                }
            }
            this.removeMenuDisposeListener();
            if (this.menu != null) {
                this.menu.cascade = null;
            }
            this.menu = menu;
            if (menu != null) {
                menu.cascade = this;
            }
            this.addMenuDisposeListener();
        }
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public void setID(int id) {
        this.checkWidget();
        if (id < 0) {
            this.error(5);
        }
        this.userId = id;
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            super.setImage(image);
        }
    }

    public void setToolTipText(String toolTipText) {
        this.checkWidget();
        if (toolTipText != null && MarkupUtil.isToolTipMarkupEnabledFor(this) && !MarkupValidator.isValidationDisabledFor(this)) {
            MarkupValidator.getInstance().validate(toolTipText);
        }
        this.toolTipText = toolTipText;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        if (accelerator != 0) {
            if (this.acceleratorBinding == null) {
                this.acceleratorBinding = new AcceleratorBinding(this);
            }
            this.acceleratorBinding.setAccelerator(accelerator);
        } else if (this.acceleratorBinding != null) {
            this.acceleratorBinding.release();
            this.acceleratorBinding = null;
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.acceleratorBinding != null ? this.acceleratorBinding.getAccelerator() : 0;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.removeState(8);
        if (!enabled) {
            this.addState(8);
        }
    }

    public boolean getEnabled() {
        this.checkWidget();
        return !this.hasState(8);
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setSelection(boolean selection) {
        this.checkWidget();
        if ((this.style & 0x30) != 0) {
            this.selection = selection;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(28, listener);
    }

    public void addArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(30, typedListener);
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        this.removeListener(30, listener);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == WidgetLCA.class) {
            return (T)MenuItemLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.acceleratorBinding != null) {
            this.acceleratorBinding.release();
            this.acceleratorBinding = null;
        }
    }

    @Override
    final void releaseChildren() {
        if (this.menu != null) {
            this.removeMenuDisposeListener();
            this.menu.dispose();
            this.menu = null;
        }
    }

    @Override
    final void releaseParent() {
        super.releaseParent();
        this.parent.getAdapter(IItemHolderAdapter.class).remove(this);
    }

    @Override
    String getNameText() {
        String result = (this.style & 2) != 0 ? "|" : super.getNameText();
        return result;
    }

    private void addMenuDisposeListener() {
        if (this.menu != null) {
            if (this.menuDisposeListener == null) {
                this.menuDisposeListener = new DisposeListener(){

                    @Override
                    public void widgetDisposed(DisposeEvent event) {
                        MenuItem.this.menu = null;
                    }
                };
            }
            this.menu.addDisposeListener(this.menuDisposeListener);
        }
    }

    private void removeMenuDisposeListener() {
        if (this.menu != null) {
            this.menu.removeDisposeListener(this.menuDisposeListener);
        }
    }

    void handleAcceleratorActivation() {
        if ((this.style & 0x20) != 0) {
            this.selection = !this.selection;
        } else if ((this.style & 0x10) != 0) {
            this.deselectOtherRadios();
            this.selection = true;
        }
        this.notifyListeners(13, new Event());
    }

    private void deselectOtherRadios() {
        MenuItem[] menuItemArray = this.parent.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item != this && (item.getStyle() & 0x10) != 0 && item.getSelection()) {
                item.setSelection(false);
                item.notifyListeners(13, new Event());
            }
            ++n2;
        }
    }

    private static int checkStyle(int style) {
        return MenuItem.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.menu != null) {
            this.menu.reskin(flags);
        }
        super.reskinChildren(flags);
    }
}

