/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;

class ModuleResolutionReport
implements ResolutionReport {
    private final Map<Resource, List<ResolutionReport.Entry>> entries;
    private final ResolutionException resolutionException;
    private final Map<Resource, List<Wire>> resolutionResult;

    ModuleResolutionReport(Map<Resource, List<Wire>> resolutionResult, Map<Resource, List<ResolutionReport.Entry>> entries, ResolutionException cause) {
        this.entries = entries == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<Resource, List<ResolutionReport.Entry>>(entries));
        this.resolutionResult = resolutionResult == null ? Collections.emptyMap() : Collections.unmodifiableMap(resolutionResult);
        this.resolutionException = cause;
    }

    @Override
    public Map<Resource, List<ResolutionReport.Entry>> getEntries() {
        return this.entries;
    }

    @Override
    public ResolutionException getResolutionException() {
        return this.resolutionException;
    }

    Map<Resource, List<Wire>> getResolutionResult() {
        return this.resolutionResult;
    }

    private static String getResolutionReport0(String prepend, ModuleRevision revision, Map<Resource, List<ResolutionReport.Entry>> reportEntries, Set<BundleRevision> visited) {
        if (prepend == null) {
            prepend = "";
        }
        if (visited == null) {
            visited = new HashSet<BundleRevision>();
        }
        if (visited.contains(revision)) {
            return "";
        }
        visited.add(revision);
        StringBuilder result = new StringBuilder();
        String id = revision.getRevisions().getModule().getId().toString();
        result.append(prepend).append(revision.getSymbolicName()).append(" [").append(id).append("]").append('\n');
        List<ResolutionReport.Entry> revisionEntries = reportEntries.get(revision);
        if (revisionEntries == null) {
            result.append(prepend).append("  ").append(Msg.ModuleResolutionReport_NoReport);
        } else {
            for (ResolutionReport.Entry entry : revisionEntries) {
                ModuleResolutionReport.printResolutionEntry(result, String.valueOf(prepend) + "  ", entry, reportEntries, visited);
            }
        }
        return result.toString();
    }

    private static void printResolutionEntry(StringBuilder result, String prepend, ResolutionReport.Entry entry, Map<Resource, List<ResolutionReport.Entry>> reportEntries, Set<BundleRevision> visited) {
        switch (entry.getType()) {
            case MISSING_CAPABILITY: {
                result.append(prepend).append(Msg.ModuleResolutionReport_UnresolvedReq).append(ModuleContainer.toString((Requirement)entry.getData())).append('\n');
                break;
            }
            case SINGLETON_SELECTION: {
                result.append(prepend).append(Msg.ModuleResolutionReport_AnotherSingleton).append(entry.getData()).append('\n');
                break;
            }
            case UNRESOLVED_PROVIDER: {
                Map unresolvedProviders = (Map)entry.getData();
                for (Map.Entry unresolvedRequirement : unresolvedProviders.entrySet()) {
                    Set unresolvedCapabilities = (Set)unresolvedRequirement.getValue();
                    if (unresolvedCapabilities.isEmpty()) continue;
                    Capability unresolvedCapability = (Capability)unresolvedCapabilities.iterator().next();
                    if (((Requirement)unresolvedRequirement.getKey()).getResource().equals(unresolvedCapability.getResource())) continue;
                    result.append(prepend).append(Msg.ModuleResolutionReport_UnresolvedReq).append(ModuleContainer.toString((Requirement)unresolvedRequirement.getKey())).append('\n');
                    result.append(prepend).append("  -> ").append(ModuleContainer.toString(unresolvedCapability)).append('\n');
                    result.append(ModuleResolutionReport.getResolutionReport0(String.valueOf(prepend) + "     ", (ModuleRevision)unresolvedCapability.getResource(), reportEntries, visited));
                }
                break;
            }
            case FILTERED_BY_RESOLVER_HOOK: {
                result.append(Msg.ModuleResolutionReport_FilteredByHook).append('\n');
                break;
            }
            case USES_CONSTRAINT_VIOLATION: {
                result.append(prepend).append(Msg.ModuleResolutionReport_UsesConstraintError).append('\n');
                result.append("  ").append(entry.getData());
                break;
            }
            default: {
                result.append(Msg.ModuleResolutionReport_Unknown).append("type=").append((Object)entry.getType()).append(" data=").append(entry.getData()).append('\n');
            }
        }
    }

    @Override
    public String getResolutionReportMessage(Resource resource) {
        return ModuleResolutionReport.getResolutionReport0(null, (ModuleRevision)resource, this.getEntries(), null);
    }

    static class Builder {
        private final Map<Resource, List<ResolutionReport.Entry>> resourceToEntries = new HashMap<Resource, List<ResolutionReport.Entry>>();

        Builder() {
        }

        public void addEntry(Resource resource, ResolutionReport.Entry.Type type, Object data) {
            List<ResolutionReport.Entry> entries = this.resourceToEntries.get(resource);
            if (entries == null) {
                entries = new ArrayList<ResolutionReport.Entry>();
                this.resourceToEntries.put(resource, entries);
            }
            entries.add(new EntryImpl(type, data));
        }

        public ModuleResolutionReport build(Map<Resource, List<Wire>> resolutionResult, ResolutionException cause) {
            return new ModuleResolutionReport(resolutionResult, this.resourceToEntries, cause);
        }
    }

    static class EntryImpl
    implements ResolutionReport.Entry {
        private final Object data;
        private final ResolutionReport.Entry.Type type;

        EntryImpl(ResolutionReport.Entry.Type type, Object data) {
            this.type = type;
            this.data = data;
        }

        @Override
        public Object getData() {
            return this.data;
        }

        @Override
        public ResolutionReport.Entry.Type getType() {
            return this.type;
        }
    }
}

