/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MarkupExample
implements IExamplePage {
    private static final ClassLoader CLASSLOADER = MarkupExample.class.getClassLoader();
    private static final String[][] CARS_DATA = new String[][]{{"Nissan GT-R 3.8 Premium Edition", "2009", "42 000<br/>EUR", "Public Sale"}, {"Audi R8 5.2 Gt Quattro", "2011", "300 000<br/>EUR", "Cars Shop Ltd"}, {"Ferrari 599 GTB Fiorano F1 2dr", "2010", "169 000<br/>EUR", "Automob GmbH"}, {"Ford Focus ZETEC AUTO", "2002", "189 000<br/>EUR", "Motcomp Ltd"}, {"Austin 1300 1300", "1972", "145 000<br/>EUR", "Cars Shop Ltd"}, {"Mini Cooper 1.6", "2008", "95 000<br/>EUR", "Public Sale"}, {"Aston Martin V8 (420)", "2011", "101 000<br/>EUR", "Automob GmbH"}, {"Nissan GT-R 3.8 Premium Edition", "2009", "42 000<br/>EUR", "Public Sale"}, {"Audi R8 5.2 Gt Quattro", "2011", "300 000<br/>EUR", "Cars Shop Ltd"}, {"Ferrari 599 GTB Fiorano F1 2dr", "2010", "169 000<br/>EUR", "Automob GmbH"}, {"Ford Focus ZETEC AUTO", "2002", "189 000<br/>EUR", "Motcomp Ltd"}, {"Austin 1300 1300", "1972", "145 000<br/>EUR", "Cars Shop Ltd"}, {"Mini Cooper 1.6", "2008", "95 000<br/>EUR", "Public Sale"}, {"Aston Martin V8 (420)", "2011", "101 000<br/>EUR", "Automob GmbH"}, {"Nissan GT-R 3.8 Premium Edition", "2009", "42 000<br/>EUR", "Public Sale"}, {"Audi R8 5.2 Gt Quattro", "2011", "300 000<br/>EUR", "Cars Shop Ltd"}, {"Ferrari 599 GTB Fiorano F1 2dr", "2010", "169 000<br/>EUR", "Automob GmbH"}, {"Ford Focus ZETEC AUTO", "2002", "189 000<br/>EUR", "Motcomp Ltd"}, {"Austin 1300 1300", "1972", "145 000<br/>EUR", "Cars Shop Ltd"}, {"Mini Cooper 1.6", "2008", "95 000<br/>EUR", "Public Sale"}, {"Aston Martin V8 (420)", "2011", "101 000<br/>EUR", "Automob GmbH"}, {"Nissan GT-R 3.8 Premium Edition", "2009", "42 000<br/>EUR", "Public Sale"}, {"Audi R8 5.2 Gt Quattro", "2011", "300 000<br/>EUR", "Cars Shop Ltd"}, {"Ferrari 599 GTB Fiorano F1 2dr", "2010", "169 000<br/>EUR", "Automob GmbH"}, {"Ford Focus ZETEC AUTO", "2002", "189 000<br/>EUR", "Motcomp Ltd"}, {"Austin 1300 1300", "1972", "145 000<br/>EUR", "Cars Shop Ltd"}, {"Mini Cooper 1.6", "2008", "95 000<br/>EUR", "Public Sale"}, {"Aston Martin V8 (420)", "2011", "101 000<br/>EUR", "Automob GmbH"}};
    private String carImageLocation;
    private String fuelImageLocation;
    private String gearImageLocation;

    public void createControl(Composite parent) {
        this.registerImages();
        parent.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)true, (boolean)true, (boolean)true));
        parent.setLayoutData((Object)ExampleUtil.createFillData());
        this.createTable(parent);
    }

    private void registerImages() {
        try {
            this.fuelImageLocation = MarkupExample.registerImage("resources/fuel.png");
            this.gearImageLocation = MarkupExample.registerImage("resources/gear.png");
            this.carImageLocation = MarkupExample.registerImage("resources/car.png");
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to register images", exception);
        }
    }

    private void createTable(Composite comp) {
        Table table = new Table(comp, 67584);
        table.setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        table.setData("org.eclipse.rap.rwt.customItemHeight", (Object)80);
        GridData tableLayoutData = ExampleUtil.createFillData();
        tableLayoutData.verticalIndent = 10;
        tableLayoutData.heightHint = 500;
        table.setLayoutData((Object)tableLayoutData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        MarkupExample.createColumn(table, "Brand/Model", 410, 16384);
        MarkupExample.createColumn(table, "Year", 100, 0x1000000);
        MarkupExample.createColumn(table, "Price", 150, 0x1000000);
        MarkupExample.createColumn(table, "Distributor", 300, 16384);
        this.createItems(table);
    }

    private void createItems(Table table) {
        int i = 0;
        while (i < CARS_DATA.length) {
            TableItem item = new TableItem(table, 0);
            int j = 0;
            while (j < CARS_DATA[i].length) {
                item.setText(j, this.formatData(CARS_DATA[i][j], j));
                ++j;
            }
            ++i;
        }
    }

    private String formatData(String text, int column) {
        StringBuilder builder = new StringBuilder();
        String imageUrl = MarkupExample.getImageUrl(this.carImageLocation);
        switch (column) {
            case 0: {
                builder.append("<img src=\"");
                builder.append(imageUrl);
                builder.append("\" style=\"float:left;padding:5px\" width=\"130\" height=\"70\" />");
                builder.append("<b>");
                builder.append(text);
                builder.append("</b>");
                builder.append("<small><br/>");
                builder.append(this.createGearboxImageTag());
                builder.append("<i>Gearbox: Manual</i><br/>");
                builder.append(this.createFuelImageTag());
                builder.append("<i>Fuel Type: Petrol</i>");
                builder.append("<br/><a style='color:#' href=\"https://www.google.com/search?q=");
                builder.append(text);
                builder.append("\" target=\"_blank\">More Info</a>");
                builder.append("</small>");
                break;
            }
            case 1: {
                builder.append("<b>");
                builder.append(text);
                builder.append("</b>");
                break;
            }
            case 2: {
                builder.append("<span>");
                builder.append(text);
                builder.append("</span>");
                break;
            }
            case 3: {
                builder.append(text);
                builder.append("<br/><em><small>");
                builder.append("Contacts: none");
                builder.append("</small></em>");
            }
        }
        return builder.toString();
    }

    private String createGearboxImageTag() {
        String imageUrl = MarkupExample.getImageUrl(this.gearImageLocation);
        return "<img src='" + imageUrl + "' width='10' height='10' style='padding-right:5px'/>";
    }

    private String createFuelImageTag() {
        String imageUrl = MarkupExample.getImageUrl(this.fuelImageLocation);
        return "<img src='" + imageUrl + "' width='10' height='10' style='padding-right:5px'/>";
    }

    private static TableColumn createColumn(Table table, String name, int width, int alignment) {
        TableColumn column = new TableColumn(table, 0);
        column.setText(name);
        column.setWidth(width);
        column.setAlignment(alignment);
        return column;
    }

    private static String registerImage(String resourceName) throws IOException {
        ResourceManager resourceManager = RWT.getResourceManager();
        if (!resourceManager.isRegistered(resourceName)) {
            InputStream inputStream = CLASSLOADER.getResourceAsStream(resourceName);
            if (inputStream == null) {
                throw new RuntimeException("Resource not found");
            }
            try {
                resourceManager.register(resourceName, inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        return resourceManager.getLocation(resourceName);
    }

    private static String getImageUrl(String location) {
        return String.valueOf(RWT.getRequest().getContextPath()) + "/" + location;
    }
}

