/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.buttonkit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;

public class ButtonOperationHandler
extends ControlOperationHandler<Button> {
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_TEXT = "text";

    public ButtonOperationHandler(Button button) {
        super(button);
    }

    @Override
    public void handleSet(Button button, JsonObject properties) {
        super.handleSet(button, properties);
        this.handleSetSelection(button, properties);
        this.handleSetText(button, properties);
    }

    @Override
    public void handleNotify(Button button, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(button, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(button, properties);
        } else {
            super.handleNotify(button, eventName, properties);
        }
    }

    public void handleSetSelection(Button button, JsonObject properties) {
        JsonValue selection = properties.get(PROP_SELECTION);
        if (selection != null) {
            button.setSelection(selection.asBoolean());
        }
    }

    public void handleSetText(Button button, JsonObject properties) {
        JsonValue text = properties.get(PROP_TEXT);
        if (text != null) {
            button.setText(text.asString());
        }
    }

    public void handleNotifySelection(Button button, JsonObject properties) {
        Event event = ButtonOperationHandler.createSelectionEvent(13, properties);
        if ((button.getStyle() & 0x10) != 0 && !button.getSelection()) {
            event.time = -1;
        }
        button.notifyListeners(13, event);
    }

    public void handleNotifyDefaultSelection(Button button, JsonObject properties) {
        Event event = ButtonOperationHandler.createSelectionEvent(14, properties);
        button.notifyListeners(14, event);
    }
}

