/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rap.rwt.internal.theme.CssValue;

public class CssDimension
implements CssValue {
    public static final CssDimension ZERO = new CssDimension(0);
    public static final CssDimension AUTO = new CssDimension(Integer.MIN_VALUE);
    private static final Pattern LENGTH_PATTERN = Pattern.compile("((\\+|-)?\\d+)(em|ex|px|pt|pc|in|cm|mm|%)?");
    public final int value;

    private CssDimension(int value) {
        this.value = value;
    }

    public static CssDimension create(int value) {
        return value == 0 ? ZERO : new CssDimension(value);
    }

    public static CssDimension valueOf(String input) {
        if (input == null) {
            throw new NullPointerException("null argument");
        }
        if ("auto".equals(input)) {
            return AUTO;
        }
        Integer parsed = CssDimension.parseLength(input);
        if (parsed == null) {
            throw new IllegalArgumentException("Illegal dimension parameter: " + input);
        }
        return CssDimension.create(parsed);
    }

    @Override
    public String toDefaultString() {
        return this.value == Integer.MIN_VALUE ? "auto" : String.valueOf(this.value) + "px";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CssDimension) {
            CssDimension other = (CssDimension)object;
            return other.value == this.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value * 47;
    }

    public String toString() {
        return "CssDimension{ " + this.value + " }";
    }

    static Integer parseLength(String input) {
        Integer result = null;
        Matcher matcher = LENGTH_PATTERN.matcher(input);
        if (matcher.matches()) {
            result = Integer.valueOf(matcher.group(1));
            String unit = matcher.group(3);
            if (unit != null && "%".equals(unit)) {
                throw new IllegalArgumentException("Percentages not supported: " + input);
            }
            if (unit != null && !"px".equals(unit)) {
                throw new IllegalArgumentException("Unit not supported: " + input);
            }
        }
        return result;
    }
}

