/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.datetimekit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;

public class DateTimeOperationHandler
extends ControlOperationHandler<DateTime> {
    private static final String PROP_YEAR = "year";
    private static final String PROP_MONTH = "month";
    private static final String PROP_DAY = "day";
    private static final String PROP_HOURS = "hours";
    private static final String PROP_MINUTES = "minutes";
    private static final String PROP_SECONDS = "seconds";

    public DateTimeOperationHandler(DateTime dateTime) {
        super(dateTime);
    }

    @Override
    public void handleSet(DateTime dateTime, JsonObject properties) {
        super.handleSet(dateTime, properties);
        this.handleSetDate(dateTime, properties);
        this.handleSetTime(dateTime, properties);
    }

    @Override
    public void handleNotify(DateTime dateTime, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(dateTime, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(dateTime, properties);
        } else {
            super.handleNotify(dateTime, eventName, properties);
        }
    }

    public void handleSetDate(DateTime dateTime, JsonObject properties) {
        JsonValue yearValue = properties.get(PROP_YEAR);
        JsonValue monthValue = properties.get(PROP_MONTH);
        JsonValue dayValue = properties.get(PROP_DAY);
        if (yearValue != null && monthValue != null && dayValue != null) {
            dateTime.setDate(yearValue.asInt(), monthValue.asInt(), dayValue.asInt());
        }
    }

    public void handleSetTime(DateTime dateTime, JsonObject properties) {
        JsonValue hoursValue = properties.get(PROP_HOURS);
        JsonValue minutesValue = properties.get(PROP_MINUTES);
        JsonValue secondsValue = properties.get(PROP_SECONDS);
        if (hoursValue != null && minutesValue != null && secondsValue != null) {
            dateTime.setTime(hoursValue.asInt(), minutesValue.asInt(), secondsValue.asInt());
        }
    }

    public void handleNotifySelection(DateTime dateTime, JsonObject properties) {
        Event event = DateTimeOperationHandler.createSelectionEvent(13, properties);
        dateTime.notifyListeners(13, event);
    }

    public void handleNotifyDefaultSelection(DateTime dateTime, JsonObject properties) {
        Event event = DateTimeOperationHandler.createSelectionEvent(14, properties);
        dateTime.notifyListeners(14, event);
    }
}

