/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.IGridAdapter;
import org.eclipse.nebula.widgets.grid.internal.IScrollBarProxy;
import org.eclipse.nebula.widgets.grid.internal.NullScrollBarProxy;
import org.eclipse.nebula.widgets.grid.internal.ScrollBarProxyAdapter;
import org.eclipse.nebula.widgets.grid.internal.gridkit.GridLCA;
import org.eclipse.nebula.widgets.grid.internal.gridkit.GridThemeAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.Size;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.template.Template;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.ItemProvider;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Grid
extends Composite {
    private static final int MIN_ITEM_HEIGHT = 16;
    private static final int GRID_WIDTH = 1;
    private List<GridItem> items = new ArrayList<GridItem>();
    private List<GridItem> rootItems = new ArrayList<GridItem>();
    private List<GridItem> selectedItems = new ArrayList<GridItem>();
    private List<Point> selectedCells = new ArrayList<Point>();
    private List<GridColumn> columns = new ArrayList<GridColumn>();
    private List<GridColumn> displayOrderedColumns = new ArrayList<GridColumn>();
    private List<GridColumnGroup> columnGroups = new ArrayList<GridColumnGroup>();
    private GridItem focusItem;
    private GridColumn focusColumn;
    private GridColumn treeColumn;
    private GridColumn rowHeadersColumn;
    private boolean isInternalColumn;
    private boolean isTree;
    private boolean disposing;
    private boolean columnHeadersVisible;
    private boolean columnFootersVisible;
    private boolean linesVisible = true;
    private boolean autoHeight;
    private int currentVisibleItems;
    private int selectionType = 4;
    private boolean selectionEnabled = true;
    private boolean cellSelectionEnabled;
    private int customItemHeight = -1;
    private int groupHeaderHeight;
    private Point itemImageSize;
    private Listener resizeListener;
    private Listener disposeListener;
    private boolean isTemporaryResize;
    private IScrollBarProxy vScroll;
    private IScrollBarProxy hScroll;
    private boolean scrollValuesObsolete;
    private boolean defaultRowHeadersTextObsolete;
    private int topIndex = -1;
    private int bottomIndex = -1;
    private boolean bottomIndexShownCompletely;
    private final IGridAdapter gridAdapter;
    boolean hasDifferingHeights;
    private boolean hasSpanning;
    LayoutCache layoutCache;

    public Grid(Composite parent, int style) {
        super(parent, Grid.checkStyle(style));
        if ((style & 2) != 0) {
            this.selectionType = 2;
        }
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().setVisible(false);
            this.vScroll = new ScrollBarProxyAdapter(this.getVerticalBar());
        } else {
            this.vScroll = new NullScrollBarProxy();
        }
        if (this.getHorizontalBar() != null) {
            this.getHorizontalBar().setVisible(false);
            this.hScroll = new ScrollBarProxyAdapter(this.getHorizontalBar());
        } else {
            this.hScroll = new NullScrollBarProxy();
        }
        this.gridAdapter = new GridAdapter();
        this.layoutCache = new LayoutCache();
        this.initListeners();
        this.createRowHeadersColumn();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point rreferredSize = null;
        if (wHint == -1 || hHint == -1) {
            rreferredSize = this.getTableSize();
            rreferredSize.x += 2 * this.getBorderWidth();
            rreferredSize.y += 2 * this.getBorderWidth();
        }
        int width = 0;
        int height = 0;
        if (wHint == -1) {
            width += rreferredSize.x;
            if (this.getVerticalBar() != null) {
                width += this.getVerticalBar().getSize().x;
            }
        } else {
            width = wHint;
        }
        if (hHint == -1) {
            height += rreferredSize.y;
            if (this.getHorizontalBar() != null) {
                height += this.getHorizontalBar().getSize().y;
            }
        } else {
            height = hHint;
        }
        return new Point(width, height);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(17, (Listener)typedListener);
        this.addListener(18, (Listener)typedListener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(17, (SWTEventListener)listener);
        this.removeListener(18, (SWTEventListener)listener);
    }

    public void setItemCount(int count) {
        this.checkWidget();
        int itemCount = Math.max(0, count);
        if (itemCount < this.items.size()) {
            this.selectedCells.clear();
        }
        while (itemCount < this.items.size()) {
            int flatIndex = this.items.size() - 1;
            this.items.get(flatIndex).dispose(flatIndex);
        }
        while (itemCount > this.items.size()) {
            new GridItem(this, null, 0, -1);
        }
        this.redraw();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public GridItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new GridItem[this.items.size()]);
    }

    public GridItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error((int)6);
        }
        return this.items.get(index);
    }

    public GridItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        GridItem result = null;
        if (point.x >= 0 && point.x <= this.getClientArea().width) {
            Point p = new Point(point.x, point.y);
            int y = 0;
            if (this.columnHeadersVisible) {
                y += this.getHeaderHeight();
            }
            if (p.y > y) {
                int row = this.getTopIndex();
                while (row < this.items.size() && y <= this.getClientArea().height && result == null) {
                    GridItem currentItem = this.items.get(row);
                    if (currentItem.isVisible()) {
                        int currentItemHeight = currentItem.getHeight();
                        if (p.y >= y && p.y < y + currentItemHeight) {
                            result = currentItem;
                        }
                        y += currentItemHeight;
                    }
                    ++row;
                }
            }
        }
        return result;
    }

    public int indexOf(GridItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        return item.getParent() == this ? this.items.indexOf((Object)item) : -1;
    }

    public int getRootItemCount() {
        this.checkWidget();
        return this.rootItems.size();
    }

    public GridItem[] getRootItems() {
        this.checkWidget();
        return this.rootItems.toArray(new GridItem[this.rootItems.size()]);
    }

    public GridItem getRootItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.rootItems.size()) {
            SWT.error((int)6);
        }
        return this.rootItems.get(index);
    }

    public GridItem getNextVisibleItem(GridItem item) {
        this.checkWidget();
        GridItem result = null;
        int index = this.items.indexOf((Object)item);
        if (index != this.items.size() - 1) {
            result = this.items.get(index + 1);
            while (result != null && !result.isVisible()) {
                result = ++index != this.items.size() - 1 ? this.items.get(index + 1) : null;
            }
        }
        return result;
    }

    public GridItem getPreviousVisibleItem(GridItem item) {
        this.checkWidget();
        GridItem result = null;
        int index = 0;
        index = item == null ? this.items.size() : this.items.indexOf((Object)item);
        if (index > 0) {
            result = this.items.get(index - 1);
            while (result != null && !result.isVisible()) {
                result = --index > 0 ? this.items.get(index - 1) : null;
            }
        }
        return result;
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columns.size();
    }

    public GridColumn[] getColumns() {
        this.checkWidget();
        return this.columns.toArray(new GridColumn[this.columns.size()]);
    }

    public GridColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index > this.getColumnCount() - 1) {
            SWT.error((int)6);
        }
        return this.columns.get(index);
    }

    public GridColumn getColumn(Point point) {
        GridItem item;
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        GridColumn overThis = null;
        int x2 = 0;
        if (this.isRowHeaderVisible()) {
            if (point.x <= this.rowHeadersColumn.getWidth()) {
                return null;
            }
            x2 += this.rowHeadersColumn.getWidth();
        }
        x2 -= this.hScroll.getSelection();
        for (GridColumn column : this.displayOrderedColumns) {
            if (!column.isVisible()) continue;
            if (point.x >= x2 && point.x < x2 + column.getWidth()) {
                overThis = column;
                break;
            }
            x2 += column.getWidth();
        }
        if (overThis == null) {
            return null;
        }
        if (this.hasSpanning && (item = this.getItem(point)) != null) {
            int displayColIndex = this.displayOrderedColumns.indexOf((Object)overThis);
            int i = 0;
            while (i < displayColIndex) {
                int colIndex;
                int span;
                if (this.displayOrderedColumns.get(i).isVisible() && i + (span = item.getColumnSpan(colIndex = this.indexOf(this.displayOrderedColumns.get(i)))) >= displayColIndex) {
                    overThis = this.displayOrderedColumns.get(i);
                    break;
                }
                ++i;
            }
        }
        return overThis;
    }

    public int indexOf(GridColumn column) {
        this.checkWidget();
        if (column == null) {
            SWT.error((int)4);
        }
        return column.getParent() == this ? this.columns.indexOf((Object)column) : -1;
    }

    public void setColumnOrder(int[] order) {
        int i;
        this.checkWidget();
        if (order == null) {
            SWT.error((int)4);
        }
        if (order.length != this.displayOrderedColumns.size()) {
            SWT.error((int)5);
        }
        boolean[] seen = new boolean[this.displayOrderedColumns.size()];
        int i2 = 0;
        while (i2 < order.length) {
            if (order[i2] < 0 || order[i2] >= this.displayOrderedColumns.size()) {
                SWT.error((int)5);
            }
            if (seen[order[i2]]) {
                SWT.error((int)5);
            }
            seen[order[i2]] = true;
            ++i2;
        }
        if (this.columnGroups.size() != 0) {
            GridColumnGroup currentGroup = null;
            int columnsInGroup = 0;
            i = 0;
            while (i < order.length) {
                GridColumn column = this.getColumn(order[i]);
                if (currentGroup != null) {
                    if (column.getColumnGroup() != currentGroup && columnsInGroup > 0) {
                        SWT.error((int)5);
                    } else if (--columnsInGroup <= 0) {
                        currentGroup = null;
                    }
                } else if (column.getColumnGroup() != null) {
                    currentGroup = column.getColumnGroup();
                    columnsInGroup = currentGroup.getColumns().length - 1;
                }
                ++i;
            }
        }
        GridColumn[] columns = this.getColumns();
        int[] oldOrder = this.getColumnOrder();
        this.displayOrderedColumns.clear();
        i = 0;
        while (i < order.length) {
            this.displayOrderedColumns.add(columns[order[i]]);
            ++i;
        }
        i = 0;
        while (i < order.length) {
            if (oldOrder[i] != order[i]) {
                columns[order[i]].fireMoved();
            }
            ++i;
        }
        this.updatePrimaryCheckColumn();
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] result = new int[this.columns.size()];
        int i = 0;
        while (i < result.length) {
            GridColumn column = this.displayOrderedColumns.get(i);
            result[i] = this.columns.indexOf((Object)column);
            ++i;
        }
        return result;
    }

    public GridColumn getNextVisibleColumn(GridColumn column) {
        this.checkWidget();
        GridColumn result = null;
        int index = this.displayOrderedColumns.indexOf((Object)column);
        if (index != this.displayOrderedColumns.size() - 1) {
            result = this.displayOrderedColumns.get(index + 1);
            while (result != null && !result.isVisible()) {
                result = ++index != this.displayOrderedColumns.size() - 1 ? this.displayOrderedColumns.get(index + 1) : null;
            }
        }
        return result;
    }

    public GridColumn getPreviousVisibleColumn(GridColumn column) {
        this.checkWidget();
        GridColumn result = null;
        int index = 0;
        index = column == null ? this.displayOrderedColumns.size() : this.displayOrderedColumns.indexOf((Object)column);
        if (index > 0) {
            result = this.displayOrderedColumns.get(index - 1);
            while (result != null && !result.isVisible()) {
                result = --index > 0 ? this.displayOrderedColumns.get(index - 1) : null;
            }
        }
        return result;
    }

    public int getColumnGroupCount() {
        this.checkWidget();
        return this.columnGroups.size();
    }

    public GridColumnGroup[] getColumnGroups() {
        this.checkWidget();
        return this.columnGroups.toArray(new GridColumnGroup[this.columnGroups.size()]);
    }

    public GridColumnGroup getColumnGroup(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnGroups.size()) {
            SWT.error((int)6);
        }
        return this.columnGroups.get(index);
    }

    public void clear(int index, boolean allChildren) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error((int)6);
        }
        this.items.get(index).clear(allChildren);
        this.redraw();
    }

    public void clear(int start, int end, boolean allChildren) {
        this.checkWidget();
        if (start <= end) {
            if (start < 0 || start > end || end >= this.items.size()) {
                SWT.error((int)6);
            }
            int i = start;
            while (i <= end) {
                this.items.get(i).clear(allChildren);
                ++i;
            }
            this.redraw();
        }
    }

    public void clear(int[] indices, boolean allChildren) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (indices.length > 0) {
            int i = 0;
            while (i < indices.length) {
                if (!this.isValidItemIndex(indices[i])) {
                    SWT.error((int)6);
                }
                ++i;
            }
            i = 0;
            while (i < indices.length) {
                this.items.get(indices[i]).clear(allChildren);
                ++i;
            }
            this.redraw();
        }
    }

    public void clearAll(boolean allChildren) {
        this.checkWidget();
        int itemsCount = this.items.size();
        if (itemsCount > 0) {
            this.clear(0, itemsCount - 1, allChildren);
            this.itemImageSize = null;
            this.setCellToolTipsEnabled(false);
            this.layoutCache.invalidateItemHeight();
        }
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        this.checkWidget();
        if (!selectionEnabled) {
            this.selectedItems.clear();
        }
        this.selectionEnabled = selectionEnabled;
    }

    public boolean getSelectionEnabled() {
        this.checkWidget();
        return this.selectionEnabled;
    }

    public boolean getCellSelectionEnabled() {
        this.checkWidget();
        return this.cellSelectionEnabled;
    }

    public void setCellSelectionEnabled(boolean cellSelection) {
        this.checkWidget();
        if (cellSelection) {
            if ((this.getStyle() & 4) == 0) {
                this.selectionType = 2;
            }
            this.selectedItems.clear();
        } else {
            this.selectedCells.clear();
        }
        this.cellSelectionEnabled = cellSelection;
    }

    public boolean isCellSelectionEnabled() {
        return this.cellSelectionEnabled;
    }

    public void select(int index) {
        this.checkWidget();
        if (this.selectionEnabled && this.isValidItemIndex(index)) {
            if (!this.cellSelectionEnabled && this.selectionType == 4) {
                this.selectedItems.clear();
            }
            this.internalSelect(index);
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (this.selectionEnabled && (this.selectionType != 4 || start == end)) {
            if (!this.cellSelectionEnabled && this.selectionType == 4) {
                this.selectedItems.clear();
            }
            int index = Math.max(0, start);
            while (index <= Math.min(this.items.size() - 1, end)) {
                this.internalSelect(index);
                ++index;
            }
        }
    }

    public void select(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (this.selectionEnabled && (this.selectionType != 4 || indices.length <= 1)) {
            if (!this.cellSelectionEnabled && this.selectionType == 4) {
                this.selectedItems.clear();
            }
            int i = 0;
            while (i < indices.length) {
                this.internalSelect(indices[i]);
                ++i;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if (this.selectionEnabled && this.selectionType != 4) {
            if (this.cellSelectionEnabled) {
                this.selectAllCells();
            } else {
                this.selectedItems.clear();
                this.selectedItems.addAll(this.items);
            }
        }
    }

    public void selectCell(Point cell) {
        this.checkWidget();
        if (this.cellSelectionEnabled) {
            if (cell == null) {
                SWT.error((int)4);
            }
            this.addToCellSelection(cell);
        }
    }

    public void selectCells(Point[] cells) {
        this.checkWidget();
        if (this.cellSelectionEnabled) {
            Point cell;
            if (cells == null) {
                SWT.error((int)4);
            }
            Point[] pointArray = cells;
            int n = cells.length;
            int n2 = 0;
            while (n2 < n) {
                cell = pointArray[n2];
                if (cell == null) {
                    SWT.error((int)4);
                }
                ++n2;
            }
            pointArray = cells;
            n = cells.length;
            n2 = 0;
            while (n2 < n) {
                cell = pointArray[n2];
                this.addToCellSelection(cell);
                ++n2;
            }
        }
    }

    public void selectAllCells() {
        this.checkWidget();
        this.internalSelectAll();
    }

    public void selectColumn(int col) {
        this.checkWidget();
        this.selectCells(this.getCells(this.getColumn(col)));
    }

    public void selectColumnGroup(int colGroup) {
        this.selectColumnGroup(this.getColumnGroup(colGroup));
    }

    public void selectColumnGroup(GridColumnGroup colGroup) {
        this.checkWidget();
        this.selectCells(this.getCells(colGroup));
    }

    public void deselect(int index) {
        this.checkWidget();
        if (this.isValidItemIndex(index)) {
            this.internalDeselect(index);
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        int index = Math.max(0, start);
        while (index <= Math.min(this.items.size() - 1, end)) {
            this.internalDeselect(index);
            ++index;
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        int i = 0;
        while (i < indices.length) {
            this.internalDeselect(indices[i]);
            ++i;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.internalDeselectAll();
    }

    public void deselectCell(Point cell) {
        this.checkWidget();
        if (cell == null) {
            SWT.error((int)4);
        }
        this.selectedCells.remove(cell);
    }

    public void deselectCells(Point[] cells) {
        Point cell;
        this.checkWidget();
        if (cells == null) {
            SWT.error((int)4);
        }
        Point[] pointArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            cell = pointArray[n2];
            if (cell == null) {
                SWT.error((int)4);
            }
            ++n2;
        }
        pointArray = cells;
        n = cells.length;
        n2 = 0;
        while (n2 < n) {
            cell = pointArray[n2];
            this.selectedCells.remove(cell);
            ++n2;
        }
    }

    public void deselectAllCells() {
        this.checkWidget();
        this.selectedCells.clear();
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (this.selectionEnabled && this.isValidItemIndex(index)) {
            this.internalDeselectAll();
            this.internalSelect(index);
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if (this.selectionEnabled && (this.selectionType != 4 || start == end)) {
            this.internalDeselectAll();
            int index = Math.max(0, start);
            while (index <= Math.min(this.items.size() - 1, end)) {
                this.internalSelect(index);
                ++index;
            }
        }
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (this.selectionEnabled && (this.selectionType != 4 || indices.length <= 1)) {
            this.internalDeselectAll();
            int i = 0;
            while (i < indices.length) {
                this.internalSelect(indices[i]);
                ++i;
            }
        }
    }

    public void setSelection(GridItem[] items) {
        this.checkWidget();
        if (items == null) {
            SWT.error((int)4);
        }
        if (this.selectionEnabled && (this.selectionType != 4 || items.length <= 1)) {
            this.internalDeselectAll();
            GridItem[] gridItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                GridItem item = gridItemArray[n2];
                if (item != null) {
                    if (item.isDisposed()) {
                        SWT.error((int)5);
                    }
                    this.internalSelect(this.items.indexOf((Object)item));
                }
                ++n2;
            }
        }
    }

    public GridItem[] getSelection() {
        this.checkWidget();
        if (this.cellSelectionEnabled) {
            ArrayList<GridItem> items = new ArrayList<GridItem>();
            int itemCount = this.getItemCount();
            for (Point cell : this.selectedCells) {
                GridItem item;
                if (cell.y < 0 || cell.y >= itemCount || items.contains((Object)(item = this.getItem(cell.y)))) continue;
                items.add(item);
            }
            return items.toArray(new GridItem[0]);
        }
        return this.selectedItems.toArray(new GridItem[this.selectedItems.size()]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        if (this.cellSelectionEnabled) {
            ArrayList<GridItem> items = new ArrayList<GridItem>();
            for (Point cell : this.selectedCells) {
                GridItem item = this.getItem(cell.y);
                if (items.contains((Object)item)) continue;
                items.add(item);
            }
            return items.size();
        }
        return this.selectedItems.size();
    }

    public int getCellSelectionCount() {
        this.checkWidget();
        return this.selectedCells.size();
    }

    public void setCellSelection(Point cell) {
        this.checkWidget();
        if (this.cellSelectionEnabled) {
            if (cell == null) {
                SWT.error((int)4);
            }
            if (!this.isValidCell(cell)) {
                SWT.error((int)5);
            }
            this.selectedCells.clear();
            this.addToCellSelection(cell);
        }
    }

    public void setCellSelection(Point[] cells) {
        this.checkWidget();
        if (this.cellSelectionEnabled) {
            Point cell;
            if (cells == null) {
                SWT.error((int)4);
            }
            Point[] pointArray = cells;
            int n = cells.length;
            int n2 = 0;
            while (n2 < n) {
                cell = pointArray[n2];
                if (cell == null) {
                    SWT.error((int)4);
                }
                if (!this.isValidCell(cell)) {
                    SWT.error((int)5);
                }
                ++n2;
            }
            this.selectedCells.clear();
            pointArray = cells;
            n = cells.length;
            n2 = 0;
            while (n2 < n) {
                cell = pointArray[n2];
                this.addToCellSelection(cell);
                ++n2;
            }
        }
    }

    public Point[] getCellSelection() {
        this.checkWidget();
        return this.selectedCells.toArray(new Point[this.selectedCells.size()]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int result = -1;
        if (this.cellSelectionEnabled) {
            if (this.selectedCells.size() != 0) {
                result = this.selectedCells.get((int)0).y;
            }
        } else if (this.selectedItems.size() != 0) {
            result = this.items.indexOf((Object)this.selectedItems.get(0));
        }
        return result;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int[] result = new int[]{};
        if (this.cellSelectionEnabled) {
            ArrayList<GridItem> selectedRows = new ArrayList<GridItem>();
            for (Point cell : this.selectedCells) {
                GridItem item = this.getItem(cell.y);
                if (selectedRows.contains((Object)item)) continue;
                selectedRows.add(item);
            }
            result = new int[selectedRows.size()];
            int i = 0;
            while (i < result.length) {
                GridItem item = (GridItem)((Object)selectedRows.get(i));
                result[i] = this.items.indexOf((Object)item);
                ++i;
            }
        } else {
            result = new int[this.selectedItems.size()];
            int i = 0;
            while (i < result.length) {
                GridItem item = this.selectedItems.get(i);
                result[i] = this.items.indexOf((Object)item);
                ++i;
            }
        }
        return result;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        boolean result = false;
        if (this.isValidItemIndex(index)) {
            if (this.cellSelectionEnabled) {
                for (Point cell : this.selectedCells) {
                    if (cell.y != index) continue;
                    result = true;
                }
            } else {
                result = this.isSelected(this.items.get(index));
            }
        }
        return result;
    }

    public boolean isSelected(GridItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        boolean result = false;
        if (this.cellSelectionEnabled) {
            int index = this.items.indexOf((Object)item);
            if (index != -1) {
                for (Point cell : this.selectedCells) {
                    if (cell.y != index) continue;
                    result = true;
                }
            }
        } else {
            result = this.selectedItems.contains((Object)item);
        }
        return result;
    }

    public boolean isCellSelected(Point cell) {
        this.checkWidget();
        if (cell == null) {
            SWT.error((int)4);
        }
        return this.selectedCells.contains(cell);
    }

    public Point getCell(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        if (point.x < 0 || point.x > this.getClientArea().width) {
            return null;
        }
        GridItem item = this.getItem(point);
        GridColumn column = this.getColumn(point);
        if (item != null && column != null) {
            return new Point(this.indexOf(column), this.indexOf(item));
        }
        return null;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index > this.items.size() - 1) {
            SWT.error((int)6);
        }
        this.items.get(index).dispose(index);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        int i = end;
        while (i >= start) {
            if (i < 0 || i > this.items.size() - 1) {
                SWT.error((int)6);
            }
            this.items.get(i).dispose(i);
            --i;
        }
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        GridItem[] removeThese = new GridItem[indices.length];
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (this.isValidItemIndex(index)) {
                removeThese[i] = this.items.get(index);
            } else {
                SWT.error((int)6);
            }
            ++i;
        }
        i = 0;
        while (i < removeThese.length) {
            removeThese[i].dispose();
            ++i;
        }
    }

    public void removeAll() {
        this.checkWidget();
        while (this.items.size() > 0) {
            int flatIndex = this.items.size() - 1;
            this.items.get(flatIndex).dispose(flatIndex);
        }
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        if (this.columnHeadersVisible != show) {
            this.columnHeadersVisible = show;
            this.layoutCache.invalidateHeaderHeight();
            this.scheduleRedraw();
        }
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.columnHeadersVisible;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!this.layoutCache.hasHeaderHeight()) {
            this.layoutCache.headerHeight = this.computeHeaderHeight();
        }
        return this.layoutCache.headerHeight;
    }

    public void setFooterVisible(boolean show) {
        this.checkWidget();
        if (this.columnFootersVisible != show) {
            this.columnFootersVisible = show;
            this.layoutCache.invalidateFooterHeight();
            this.scheduleRedraw();
        }
    }

    public boolean getFooterVisible() {
        this.checkWidget();
        return this.columnFootersVisible;
    }

    public int getFooterHeight() {
        this.checkWidget();
        if (!this.layoutCache.hasFooterHeight()) {
            this.layoutCache.footerHeight = this.computeFooterHeight();
        }
        return this.layoutCache.footerHeight;
    }

    public int getGroupHeaderHeight() {
        this.checkWidget();
        if (!this.layoutCache.hasHeaderHeight()) {
            this.layoutCache.headerHeight = this.computeHeaderHeight();
        }
        return this.groupHeaderHeight;
    }

    public void setLinesVisible(boolean linesVisible) {
        this.checkWidget();
        this.linesVisible = linesVisible;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    public void setFocusItem(GridItem item) {
        this.checkWidget();
        if (item == null || item.isDisposed() || item.getParent() != this || !item.isVisible()) {
            SWT.error((int)5);
        }
        this.focusItem = item;
    }

    public GridItem getFocusItem() {
        this.checkWidget();
        return this.focusItem;
    }

    public void setFocusColumn(GridColumn column) {
        this.checkWidget();
        if (column == null || column.isDisposed() || column.getParent() != this || !column.isVisible()) {
            SWT.error((int)5);
        }
        if (this.isCellSelectionEnabled()) {
            this.focusColumn = column;
        }
    }

    public GridColumn getFocusColumn() {
        this.checkWidget();
        return this.isCellSelectionEnabled() ? this.focusColumn : null;
    }

    public Point getFocusCell() {
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            return null;
        }
        int x = -1;
        int y = -1;
        if (this.focusColumn != null) {
            x = this.indexOf(this.focusColumn);
        }
        if (this.focusItem != null) {
            y = this.indexOf(this.focusItem);
        }
        return new Point(x, y);
    }

    public void setItemHeight(int height) {
        this.checkWidget();
        if (height < 1) {
            SWT.error((int)5);
        }
        if (this.customItemHeight != height) {
            this.customItemHeight = height;
            this.hasDifferingHeights = false;
            this.scheduleRedraw();
        }
    }

    public int getItemHeight() {
        this.checkWidget();
        if (this.customItemHeight == -1) {
            if (!this.layoutCache.hasItemHeight()) {
                this.layoutCache.itemHeight = this.computeItemHeight();
            }
            return this.layoutCache.itemHeight;
        }
        return this.customItemHeight;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.layoutCache.invalidateItemHeight();
        this.scheduleRedraw();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if (this.isValidItemIndex(index)) {
            this.updateScrollBars();
            GridItem item = this.items.get(index);
            if (item.isVisible() && this.vScroll.getVisible()) {
                int vScrollAmount = 0;
                int i = 0;
                while (i < index) {
                    if (this.items.get(i).isVisible()) {
                        ++vScrollAmount;
                    }
                    ++i;
                }
                this.vScroll.setSelection(vScrollAmount);
                this.invalidateTopBottomIndex();
                this.redraw();
            }
        }
    }

    public int getTopIndex() {
        this.checkWidget();
        if (this.topIndex == -1) {
            this.updateScrollBars();
            if (this.vScroll.getVisible()) {
                int firstVisibleIndex = this.vScroll.getSelection();
                if (this.isTree) {
                    Iterator<GridItem> iterator = this.items.iterator();
                    int row = firstVisibleIndex + 1;
                    while (row > 0 && iterator.hasNext()) {
                        GridItem item = iterator.next();
                        if (!item.isVisible() || --row != 0) continue;
                        firstVisibleIndex = this.items.indexOf((Object)item);
                    }
                }
                this.topIndex = firstVisibleIndex;
            } else {
                this.topIndex = 0;
            }
        }
        return this.topIndex;
    }

    public void showItem(GridItem item) {
        int visibleGridHeight;
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (item.isDisposed()) {
            SWT.error((int)5);
        }
        if (item.getParent() == this && (visibleGridHeight = this.getVisibleGridHeight()) >= 1) {
            this.updateScrollBars();
            GridItem parent = item.getParentItem();
            while (parent != null) {
                if (!parent.isExpanded()) {
                    parent.setExpanded(true);
                    parent.fireEvent(17);
                }
                parent = parent.getParentItem();
            }
            if (!this.isShown(item)) {
                this.setTopIndex(this.items.indexOf((Object)item));
            }
        }
    }

    public void showColumn(GridColumn column) {
        this.checkWidget();
        if (column == null) {
            SWT.error((int)4);
        }
        if (column.isDisposed()) {
            SWT.error((int)5);
        }
        if (column.getParent() == this) {
            this.updateScrollBars();
            if (!column.isVisible()) {
                GridColumnGroup group;
                group.setExpanded(!(group = column.getColumnGroup()).getExpanded());
                if (group.getExpanded()) {
                    group.notifyListeners(17, new Event());
                } else {
                    group.notifyListeners(18, new Event());
                }
            }
            if (this.hScroll.getVisible()) {
                int offset = this.hScroll.getSelection();
                int x = this.getColumnHeaderXPosition(column);
                if (x < 0 || x + column.getWidth() > this.getClientArea().width) {
                    if (x >= 0 && column.getWidth() <= this.getClientArea().width) {
                        x -= this.getClientArea().width - column.getWidth();
                    }
                    this.hScroll.setSelection(offset + x);
                }
            }
        }
    }

    public void showSelection() {
        this.checkWidget();
        GridItem item = null;
        if (this.cellSelectionEnabled) {
            if (this.selectedCells.size() != 0) {
                Point cell = this.selectedCells.get(0);
                item = this.getItem(cell.y);
                this.showItem(item);
                GridColumn column = this.getColumn(cell.x);
                this.showColumn(column);
            }
        } else if (this.selectedItems.size() != 0) {
            item = this.selectedItems.get(0);
            this.showItem(item);
        }
    }

    public void setAutoHeight(boolean autoHeight) {
        this.checkWidget();
        if (this.autoHeight != autoHeight) {
            this.autoHeight = autoHeight;
            this.layoutCache.invalidateHeaderHeight();
            this.layoutCache.invalidateFooterHeight();
            this.scheduleRedraw();
        }
    }

    public boolean isAutoHeight() {
        this.checkWidget();
        return this.autoHeight;
    }

    public void recalculateHeader() {
        int previous = this.getHeaderHeight();
        this.layoutCache.headerHeight = this.computeHeaderHeight();
        if (previous != this.layoutCache.headerHeight) {
            this.scrollValuesObsolete = true;
            this.scheduleRedraw();
        }
    }

    public void setRowHeaderVisible(boolean show) {
        this.setRowHeaderVisible(show, 10);
    }

    public void setRowHeaderVisible(boolean show, int minWidth) {
        this.checkWidget();
        if (this.rowHeadersColumn != null) {
            if (show) {
                this.rowHeadersColumn.setMinimumWidth(Math.max(10, minWidth));
            } else {
                this.rowHeadersColumn.setMinimumWidth(0);
                this.rowHeadersColumn.setWidth(0);
            }
        }
    }

    public void setItemHeaderWidth(int width) {
        this.checkWidget();
        if (this.rowHeadersColumn != null) {
            this.rowHeadersColumn.setWidth(width);
        }
    }

    public int getItemHeaderWidth() {
        this.checkWidget();
        return this.rowHeadersColumn != null ? this.rowHeadersColumn.getWidth() : 0;
    }

    public boolean isRowHeaderVisible() {
        this.checkWidget();
        return this.rowHeadersColumn != null && this.rowHeadersColumn.getWidth() > 0;
    }

    public void setWordWrapHeader(boolean enabled) {
        this.checkWidget();
        if (this.rowHeadersColumn != null) {
            this.rowHeadersColumn.setWordWrap(enabled);
        }
    }

    public boolean isWordWrapHeader() {
        this.checkWidget();
        return this.rowHeadersColumn != null ? this.rowHeadersColumn.getWordWrap() : false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ItemProvider.class || adapter == IGridAdapter.class || adapter == ICellToolTipAdapter.class) {
            return (T)this.gridAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)((Object)GridLCA.INSTANCE);
        }
        return (T)super.getAdapter(adapter);
    }

    public void setData(String key, Object value) {
        if (!"org.eclipse.rap.rwt.markupEnabled".equals(key) || !MarkupUtil.isMarkupEnabledFor((Widget)this)) {
            MarkupUtil.checkMarkupPrecondition((String)key, (MarkupUtil.MarkupTarget)MarkupUtil.MarkupTarget.TEXT, () -> this.items.size() == 0);
            if ("org.eclipse.rap.rwt.rowTemplate".equals(key) && value instanceof Template) {
                this.rowHeadersColumn = null;
            }
            super.setData(key, value);
        }
    }

    int newItem(GridItem item, int index, boolean root) {
        int row = 0;
        GridItem parentItem = item.getParentItem();
        if (!this.isTree && parentItem != null) {
            this.isTree = true;
        }
        int flatIndex = index;
        if (root && index != -1) {
            flatIndex = index >= this.rootItems.size() ? -1 : this.items.indexOf((Object)this.rootItems.get(index));
        } else if (!root) {
            if (index >= parentItem.getItemCount() || index == -1) {
                GridItem rightMostDescendent = parentItem;
                while (rightMostDescendent.hasChildren()) {
                    int lastChildIndex = rightMostDescendent.getItemCount() - 1;
                    rightMostDescendent = rightMostDescendent.getItem(lastChildIndex);
                }
                flatIndex = this.items.indexOf((Object)rightMostDescendent) + 1;
            } else {
                flatIndex = this.items.indexOf((Object)parentItem.getItem(index));
            }
        }
        if (flatIndex == -1) {
            this.items.add(item);
            row = this.items.size() - 1;
        } else {
            this.items.add(flatIndex, item);
            row = flatIndex;
        }
        this.updateVisibleItems(1);
        this.scheduleRedraw();
        return row;
    }

    void removeItem(int index) {
        GridItem item = this.items.remove(index);
        if (!this.disposing) {
            this.selectedItems.remove((Object)item);
            Point[] cells = this.getCells(item);
            int i = 0;
            while (i < cells.length) {
                this.selectedCells.remove(cells[i]);
                ++i;
            }
            if (this.focusItem == item) {
                this.focusItem = null;
            }
            if (item.isVisible()) {
                this.updateVisibleItems(-1);
            }
            this.scheduleRedraw();
        }
    }

    void newRootItem(GridItem item, int index) {
        if (index == -1 || index >= this.rootItems.size()) {
            this.rootItems.add(item);
            item.index = this.rootItems.size() - 1;
        } else {
            this.rootItems.add(index, item);
            item.index = index;
        }
        this.adjustItemIndices(item.index + 1);
    }

    void removeRootItem(int index) {
        this.rootItems.remove(index);
        this.adjustItemIndices(index);
    }

    private void adjustItemIndices(int start) {
        int i = start;
        while (i < this.rootItems.size()) {
            this.rootItems.get((int)i).index = i;
            ++i;
        }
    }

    void newColumn(GridColumn column, int index) {
        if (!this.isInternalColumn) {
            if (index == -1) {
                this.columns.add(column);
                this.displayOrderedColumns.add(column);
            } else {
                this.columns.add(index, column);
                this.displayOrderedColumns.add(index, column);
            }
            this.updatePrimaryCheckColumn();
            for (GridItem item : this.items) {
                item.columnAdded(index);
            }
            if (column.isCheck()) {
                this.layoutCache.invalidateItemHeight();
            }
            this.layoutCache.invalidateHeaderHeight();
            this.layoutCache.invalidateFooterHeight();
            this.scheduleRedraw();
        }
    }

    void removeColumn(GridColumn column) {
        int index = this.columns.indexOf((Object)column);
        if (this.cellSelectionEnabled) {
            ArrayList<Point> removeSelectedCells = new ArrayList<Point>();
            for (Point cell : this.selectedCells) {
                if (cell.x != index) continue;
                removeSelectedCells.add(cell);
            }
            if (removeSelectedCells.size() > 0) {
                this.selectedCells.removeAll(removeSelectedCells);
            }
            for (Point cell : this.selectedCells) {
                if (cell.x < index) continue;
                --cell.x;
            }
        }
        this.columns.remove(index);
        this.displayOrderedColumns.remove((Object)column);
        if (this.focusColumn == column) {
            this.focusColumn = null;
        }
        this.updatePrimaryCheckColumn();
        for (GridItem item : this.items) {
            item.columnRemoved(index);
        }
        if (column.isCheck()) {
            this.layoutCache.invalidateItemHeight();
        }
        this.layoutCache.invalidateHeaderHeight();
        this.layoutCache.invalidateFooterHeight();
        this.scheduleRedraw();
    }

    void newColumnGroup(GridColumnGroup group) {
        this.columnGroups.add(group);
        if (this.columnGroups.size() == 1) {
            this.layoutCache.invalidateHeaderHeight();
        }
        this.scheduleRedraw();
    }

    void removeColumnGroup(GridColumnGroup group) {
        this.columnGroups.remove((Object)group);
        if (this.columnGroups.size() == 0) {
            this.layoutCache.invalidateHeaderHeight();
        }
        this.scheduleRedraw();
    }

    boolean isDisposing() {
        return this.disposing;
    }

    void updateVisibleItems(int amount) {
        this.currentVisibleItems += amount;
    }

    GridColumn[] getColumnsInOrder() {
        this.checkWidget();
        return this.displayOrderedColumns.toArray(new GridColumn[this.columns.size()]);
    }

    void imageSetOnItem(Image image) {
        if (image != null && this.itemImageSize == null) {
            Rectangle imageBounds = image.getBounds();
            this.itemImageSize = new Point(imageBounds.width, imageBounds.height);
            this.layoutCache.invalidateItemHeight();
            this.scheduleRedraw();
        }
    }

    int getMaxContentWidth(GridColumn column) {
        this.doRedraw();
        return Grid.getMaxInnerWidth(this.getRootItems(), this.columns.indexOf((Object)column));
    }

    int getBottomIndex() {
        this.checkWidget();
        if (this.bottomIndex == -1) {
            int topIndex = this.getTopIndex();
            int visibleGridHeight = this.getVisibleGridHeight();
            if (this.items.size() == 0) {
                this.bottomIndex = 0;
            } else if (visibleGridHeight < 1) {
                this.bottomIndex = topIndex;
            } else {
                RowRange range = this.getRowRange(topIndex, visibleGridHeight, false, false);
                this.bottomIndex = range.endIndex;
                this.bottomIndexShownCompletely = range.height <= visibleGridHeight;
            }
        }
        return this.bottomIndex;
    }

    Point getOrigin(GridColumn column, GridItem item) {
        int x = column.getLeft() - this.hScroll.getSelection();
        int y = 0;
        if (item != null) {
            if (this.columnHeadersVisible) {
                y += this.getHeaderHeight();
            }
            int topIndex = this.getTopIndex();
            int itemIndex = this.items.indexOf((Object)item);
            if (itemIndex == -1) {
                SWT.error((int)5);
            }
            while (topIndex != itemIndex) {
                GridItem currentItem;
                if (topIndex < itemIndex) {
                    currentItem = this.items.get(topIndex);
                    if (currentItem.isVisible()) {
                        y += currentItem.getHeight();
                    }
                    ++topIndex;
                    continue;
                }
                if (topIndex <= itemIndex || !(currentItem = this.items.get(--topIndex)).isVisible()) continue;
                y -= currentItem.getHeight();
            }
        }
        return new Point(x, y);
    }

    boolean isShown(GridItem item) {
        this.checkWidget();
        boolean result = false;
        if (item.isVisible()) {
            int itemIndex = this.items.indexOf((Object)item);
            if (itemIndex == -1) {
                SWT.error((int)5);
            }
            int firstVisibleIndex = this.getTopIndex();
            int lastVisibleIndex = this.getBottomIndex();
            result = itemIndex >= firstVisibleIndex && itemIndex < lastVisibleIndex || itemIndex == lastVisibleIndex && this.bottomIndexShownCompletely;
        }
        return result;
    }

    private void doRedraw() {
        if (this.isVirtual() && this.items.size() > 0) {
            int index = this.getTopIndex();
            while (index <= this.getBottomIndex()) {
                GridItem item = this.items.get(index);
                if (item.isVisible()) {
                    item.ensureItemData();
                    item.handleVirtual();
                }
                ++index;
            }
        }
        this.updateDefaultRowHeadersText();
        this.updateScrollBars();
    }

    boolean isVirtual() {
        return (this.getStyle() & 0x10000000) != 0;
    }

    private void updateDefaultRowHeadersText() {
        if (this.isRowHeaderVisible() && this.defaultRowHeadersTextObsolete) {
            int rowCounter = 1;
            int index = 0;
            while (index < this.items.size()) {
                GridItem item = this.items.get(index);
                if (item.isVisible()) {
                    item.setDefaultHeaderText(Integer.toString(rowCounter++));
                }
                ++index;
            }
            this.defaultRowHeadersTextObsolete = false;
        }
    }

    void updateScrollBars() {
        if (this.scrollValuesObsolete) {
            Point preferredSize = this.getTableSize();
            Rectangle clientArea = this.getScrollableArea();
            int doublePass = 1;
            while (doublePass <= 2) {
                if (preferredSize.y > clientArea.height) {
                    this.vScroll.setVisible(true);
                } else {
                    this.vScroll.setVisible(false);
                    this.vScroll.setValues(0, 0, 1, 1, 1, 1);
                }
                if (preferredSize.x > clientArea.width) {
                    this.hScroll.setVisible(true);
                } else {
                    this.hScroll.setVisible(false);
                    this.hScroll.setValues(0, 0, 1, 1, 1, 1);
                }
                clientArea = this.getScrollableArea();
                ++doublePass;
            }
            if (this.vScroll.getVisible()) {
                int max = this.currentVisibleItems;
                int thumb = 1;
                int visibleGridHeight = this.getVisibleGridHeight();
                if (!this.hasDifferingHeights) {
                    thumb = visibleGridHeight / this.getItemHeight();
                } else if (visibleGridHeight >= 1) {
                    RowRange range = this.getRowRange(-1, visibleGridHeight, true, true);
                    max -= range.rows - 1;
                }
                int selection = Math.min(this.vScroll.getSelection(), max);
                this.vScroll.setValues(selection, 0, max, thumb, 1, thumb);
            }
            if (this.hScroll.getVisible()) {
                int hiddenArea = preferredSize.x - clientArea.width;
                int selection = Math.min(this.hScroll.getSelection(), hiddenArea);
                this.hScroll.setValues(selection, 0, preferredSize.x, clientArea.width, 5, clientArea.width);
            }
            this.scrollValuesObsolete = false;
        }
    }

    private Rectangle getScrollableArea() {
        Rectangle clientArea = this.getClientArea();
        clientArea.width -= this.getItemHeaderWidth();
        return clientArea;
    }

    protected IScrollBarProxy getHorizontalScrollBarProxy() {
        this.checkWidget();
        return this.hScroll;
    }

    protected IScrollBarProxy getVerticalScrollBarProxy() {
        this.checkWidget();
        return this.vScroll;
    }

    private void initListeners() {
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                Grid.this.onResize();
            }
        };
        this.addListener(11, this.resizeListener);
        this.disposeListener = new Listener(){

            public void handleEvent(Event event) {
                Grid.this.onDispose(event);
            }
        };
        this.addListener(12, this.disposeListener);
    }

    private void onResize() {
        if (TextSizeUtil.isTemporaryResize()) {
            this.isTemporaryResize = true;
            this.layoutCache.invalidateHeaderHeight();
            this.layoutCache.invalidateFooterHeight();
            this.layoutCache.invalidateItemHeight();
        } else {
            if (this.isTemporaryResize) {
                this.isTemporaryResize = false;
                this.repackColumns();
            }
            this.scheduleRedraw();
        }
    }

    private void onDispose(Event event) {
        this.removeListener(11, this.resizeListener);
        this.removeListener(12, this.disposeListener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.disposing = true;
        for (GridItem item : this.items) {
            item.dispose();
        }
        for (GridColumn column : this.columns) {
            column.dispose();
        }
        for (GridColumnGroup group : this.columnGroups) {
            group.dispose();
        }
        if (this.rowHeadersColumn != null) {
            this.rowHeadersColumn.dispose();
        }
    }

    void setCellToolTipsEnabled(boolean enabled) {
        this.setData(ICellToolTipProvider.ENABLE_CELL_TOOLTIP, enabled);
    }

    private Point getTableSize() {
        int width = 0;
        int height = 0;
        if (this.columnHeadersVisible) {
            height += this.getHeaderHeight();
        }
        if (this.columnFootersVisible) {
            height += this.getFooterHeight();
        }
        height += this.getGridHeight();
        for (GridColumn column : this.columns) {
            if (!column.isVisible()) continue;
            width += column.getWidth();
        }
        return new Point(width, height);
    }

    private int getGridHeight() {
        int result = 0;
        if (this.hasDifferingHeights) {
            for (GridItem item : this.items) {
                if (!item.isVisible()) continue;
                result += item.getHeight();
            }
        } else {
            result = this.currentVisibleItems * this.getItemHeight();
        }
        return result;
    }

    private int getVisibleGridHeight() {
        int headerHeight = this.columnHeadersVisible ? this.getHeaderHeight() : 0;
        int footerHeight = this.columnFootersVisible ? this.getFooterHeight() : 0;
        return this.getClientArea().height - headerHeight - footerHeight;
    }

    private static int getMaxInnerWidth(GridItem[] items, int index) {
        int maxInnerWidth = 0;
        GridItem[] gridItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            GridItem item = gridItemArray[n2];
            if (item.isResolved()) {
                maxInnerWidth = Math.max(maxInnerWidth, item.getPreferredWidth(index));
                if (item.isExpanded()) {
                    int innerWidth = Grid.getMaxInnerWidth(item.getItems(), index);
                    maxInnerWidth = Math.max(maxInnerWidth, innerWidth);
                }
            }
            ++n2;
        }
        return maxInnerWidth;
    }

    private void internalSelect(int index) {
        if (this.isValidItemIndex(index)) {
            GridItem item = this.items.get(index);
            if (this.cellSelectionEnabled) {
                this.selectCells(this.getCells(item));
            } else if (!this.selectedItems.contains((Object)item)) {
                this.selectedItems.add(item);
            }
        }
    }

    private void internalSelectAll() {
        int i = 0;
        while (i < this.items.size()) {
            GridItem item = this.items.get(i);
            if (item.isVisible()) {
                this.internalSelect(i);
            }
            ++i;
        }
    }

    private void internalDeselect(int index) {
        if (this.isValidItemIndex(index)) {
            GridItem item = this.items.get(index);
            if (this.cellSelectionEnabled) {
                this.deselectCells(this.getCells(item));
            } else if (this.selectedItems.contains((Object)item)) {
                this.selectedItems.remove((Object)item);
            }
        }
    }

    private void internalDeselectAll() {
        if (this.cellSelectionEnabled) {
            this.selectedCells.clear();
        } else {
            this.selectedItems.clear();
        }
    }

    private Point[] getCells(GridItem item) {
        ArrayList<Point> cells = new ArrayList<Point>();
        int itemIndex = this.items.indexOf((Object)item);
        int span = 0;
        for (GridColumn nextCol : this.displayOrderedColumns) {
            if (span > 0) {
                --span;
                continue;
            }
            if (!nextCol.isVisible()) continue;
            span = item.getColumnSpan(this.indexOf(nextCol));
            cells.add(new Point(this.indexOf(nextCol), itemIndex));
        }
        return cells.toArray(new Point[0]);
    }

    private Point[] getCells(GridColumn col) {
        ArrayList<Point> cells = new ArrayList<Point>();
        int colIndex = this.indexOf(col);
        int columnAtPosition = 0;
        for (GridColumn nextCol : this.displayOrderedColumns) {
            if (!nextCol.isVisible()) continue;
            if (nextCol == col) break;
            ++columnAtPosition;
        }
        GridItem item = null;
        if (this.getItemCount() > 0) {
            item = this.getItem(0);
        }
        while (item != null) {
            int position = -1;
            boolean spanned = false;
            for (GridColumn nextCol : this.displayOrderedColumns) {
                if (!nextCol.isVisible()) continue;
                if (nextCol == col) break;
                int span = item.getColumnSpan(this.indexOf(nextCol));
                if (position + span < columnAtPosition) continue;
                spanned = true;
                break;
            }
            if (!spanned && item.getColumnSpan(colIndex) == 0) {
                cells.add(new Point(colIndex, this.indexOf(item)));
            }
            item = this.getNextVisibleItem(item);
        }
        return cells.toArray(new Point[0]);
    }

    private Point[] getCells(GridColumnGroup colGroup) {
        ArrayList<Point> cells = new ArrayList<Point>();
        GridColumn[] gridColumnArray = colGroup.getColumns();
        int n = gridColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumn col = gridColumnArray[n2];
            Point[] pointArray = this.getCells(col);
            int n3 = pointArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Point cell = pointArray[n4];
                cells.add(cell);
                ++n4;
            }
            ++n2;
        }
        return cells.toArray(new Point[0]);
    }

    private void addToCellSelection(Point newCell) {
        if (newCell.x < 0 || newCell.x >= this.columns.size()) {
            return;
        }
        if (newCell.y < 0 || newCell.y >= this.items.size()) {
            return;
        }
        Iterator<Point> it = this.selectedCells.iterator();
        boolean found = false;
        while (it.hasNext()) {
            Point p = it.next();
            if (!newCell.equals((Object)p)) continue;
            found = true;
            break;
        }
        if (!found) {
            if (this.selectionType == 4 && this.selectedCells.size() > 0) {
                return;
            }
            this.selectedCells.add(newCell);
        }
    }

    private void updatePrimaryCheckColumn() {
        if ((this.getStyle() & 0x20) == 32) {
            for (GridColumn column : this.columns) {
                column.setTableCheck(false);
            }
            if (this.treeColumn != null) {
                this.treeColumn.setTableCheck(true);
            } else if (this.displayOrderedColumns.size() > 0) {
                this.displayOrderedColumns.get(0).setTableCheck(true);
            }
        }
    }

    private int computeItemHeight() {
        int result = Math.max(this.getItemImageSize().y, TextSizeUtil.getCharHeight((Font)this.getFont()));
        if (this.hasCheckBoxes()) {
            result = Math.max(this.getCheckBoxImageOuterSize().height, result);
        }
        BoxDimensions cellPadding = this.getCellPadding();
        result += cellPadding.top + cellPadding.bottom;
        ++result;
        result = Math.max(result, 16);
        return result;
    }

    private int computeHeaderHeight() {
        int result = 0;
        this.groupHeaderHeight = 0;
        if (this.columnHeadersVisible) {
            Image image;
            String text;
            Font font;
            int columnHeaderHeight = 0;
            int i = 0;
            while (i < this.getColumnCount()) {
                GridColumn column = this.columns.get(i);
                font = column.getHeaderFont();
                text = column.getText();
                image = column.getImage();
                int wrapWidth = this.autoHeight && column.getHeaderWordWrap() ? column.getHeaderWrapWidth() : 0;
                int computedHeight = this.computeColumnHeight(font, text, image, 0, wrapWidth);
                columnHeaderHeight = Math.max(columnHeaderHeight, computedHeight);
                ++i;
            }
            i = 0;
            while (i < this.getColumnGroupCount()) {
                GridColumnGroup group = this.columnGroups.get(i);
                font = group.getHeaderFont();
                text = group.getText();
                image = group.getImage();
                int chevronHeight = group.getChevronHeight();
                int wrapWidth = this.autoHeight && group.getHeaderWordWrap() ? group.getHeaderWrapWidth() : 0;
                int computedHeight = this.computeColumnHeight(font, text, image, chevronHeight, wrapWidth);
                this.groupHeaderHeight = Math.max(this.groupHeaderHeight, computedHeight);
                ++i;
            }
            result = columnHeaderHeight + this.groupHeaderHeight;
        }
        return result;
    }

    private int computeFooterHeight() {
        int result = 0;
        if (this.columnFootersVisible) {
            int columnFooterHeight = 0;
            int i = 0;
            while (i < this.getColumnCount()) {
                GridColumn column = this.columns.get(i);
                Font font = column.getFooterFont();
                String text = column.getFooterText();
                Image image = column.getFooterImage();
                int wrapWidth = this.autoHeight && column.getHeaderWordWrap() ? column.getFooterWrapWidth() : 0;
                int computedHeight = this.computeColumnHeight(font, text, image, 0, wrapWidth);
                columnFooterHeight = Math.max(columnFooterHeight, computedHeight);
                ++i;
            }
            result = columnFooterHeight;
        }
        return result;
    }

    private int computeColumnHeight(Font font, String text, Image image, int minHeight, int wrapWidth) {
        int result = minHeight;
        int textHeight = 0;
        textHeight = text.contains("\n") || wrapWidth > 0 ? TextSizeUtil.textExtent((Font)font, (String)text, (int)wrapWidth).y : TextSizeUtil.getCharHeight((Font)font);
        result = Math.max(result, textHeight);
        int imageHeight = image == null ? 0 : image.getBounds().height;
        result = Math.max(result, imageHeight);
        BoxDimensions headerPadding = this.getHeaderPadding();
        result += headerPadding.top + headerPadding.bottom;
        return result += this.getThemeAdapter().getHeaderBorderBottomWidth((Control)this);
    }

    private void repackColumns() {
        int i = 0;
        while (i < this.getColumnCount()) {
            this.columns.get(i).repack();
            ++i;
        }
    }

    private int getColumnHeaderXPosition(GridColumn column) {
        int result = -1;
        if (column.isVisible()) {
            result = column.getLeft() - this.hScroll.getSelection();
        }
        return result;
    }

    private int getCellLeft(int index) {
        return this.getColumn(index).getLeft();
    }

    private int getCellWidth(int index) {
        GridColumn column = this.getColumn(index);
        return column.isVisible() ? column.getWidth() : 0;
    }

    private int getCheckBoxOffset(int index) {
        int result = -1;
        BoxDimensions padding = this.getCellPadding();
        if (this.isColumnCentered(index) && !this.isTreeColumn(index) && !this.hasColumnImages(index) && !this.hasColumnTexts(index)) {
            result = (this.getCellWidth(index) - this.getCheckBoxImageSize().width) / 2;
            result = Math.max(result, padding.left);
        }
        if (result == -1) {
            result = this.getCheckBoxMargin().left;
            if (!this.isTreeColumn(index)) {
                result += padding.left;
            }
        }
        return result;
    }

    private int getCheckBoxWidth(int index) {
        return this.getColumn(index).isCheck() ? this.getCheckBoxImageSize().width : 0;
    }

    private int getImageOffset(int index) {
        int result = 0;
        if (!this.isTreeColumn(index)) {
            result += this.getCellPadding().left;
        }
        if (this.getColumn(index).isCheck()) {
            result += this.getCheckBoxImageOuterSize().width;
        }
        return result;
    }

    private int getImageWidth(int index) {
        if (this.hasColumnImages(index)) {
            int availableWidth = this.getCellWidth(index);
            if (!this.isTreeColumn(index)) {
                availableWidth -= this.getCellPadding().left;
            }
            availableWidth = Math.max(0, availableWidth);
            return Math.min(this.getItemImageSize().x, availableWidth);
        }
        return 0;
    }

    private int getTextOffset(int index) {
        int result = this.getImageOffset(index);
        if (this.hasColumnImages(index)) {
            result += this.getItemImageSize().x;
            result += this.getCellSpacing();
        }
        return result;
    }

    private int getTextWidth(int index) {
        return Math.max(0, this.getCellWidth(index) - this.getTextOffset(index) - this.getCellPadding().right);
    }

    private int getRowHeaderImageOffset() {
        return this.getCellPadding().left;
    }

    private int getRowHeaderImageWidth() {
        if (this.hasColumnImages(Integer.MIN_VALUE)) {
            int availableWidth = Math.max(0, this.getItemHeaderWidth() - this.getCellPadding().left);
            return Math.min(this.getItemImageSize().x, availableWidth);
        }
        return 0;
    }

    private int getRowHeaderTextOffset() {
        int result = this.getRowHeaderImageOffset();
        if (this.hasColumnImages(Integer.MIN_VALUE)) {
            result += this.getItemImageSize().x;
            result += this.getCellSpacing();
        }
        return result;
    }

    private int getRowHeaderTextWidth() {
        return Math.max(0, this.getItemHeaderWidth() - this.getRowHeaderTextOffset() - this.getCellPadding().right);
    }

    Point getItemImageSize() {
        Point result = new Point(0, 0);
        if (this.itemImageSize != null) {
            result.x = this.itemImageSize.x;
            result.y = this.itemImageSize.y;
        }
        return result;
    }

    boolean hasColumnImages(int index) {
        if (index == Integer.MIN_VALUE) {
            return this.rowHeadersColumn != null && this.rowHeadersColumn.imageCount > 0;
        }
        return this.getColumn((int)index).imageCount > 0;
    }

    boolean hasColumnTexts(int index) {
        if (index == Integer.MIN_VALUE) {
            return this.rowHeadersColumn != null && this.rowHeadersColumn.textCount > 0;
        }
        return this.getColumn((int)index).textCount > 0;
    }

    private boolean hasCheckBoxes() {
        boolean result = (this.getStyle() & 0x20) != 0;
        int i = 0;
        while (i < this.getColumnCount() && !result) {
            GridColumn column = this.columns.get(i);
            if (column.isCheck()) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    Size getCheckBoxImageOuterSize() {
        Size imageSize = this.getCheckBoxImageSize();
        BoxDimensions margin = this.getCheckBoxMargin();
        int width = imageSize.width + margin.left + margin.right;
        int height = imageSize.height + margin.top + margin.bottom;
        return new Size(width, height);
    }

    void setTreeColumn(GridColumn column) {
        this.treeColumn = column;
        this.updatePrimaryCheckColumn();
    }

    boolean isTreeColumn(int index) {
        boolean result = false;
        if (this.isTree && index < this.columns.size()) {
            result = this.treeColumn != null ? this.columns.get(index) == this.treeColumn : index == this.getColumnOrder()[0];
        }
        return result;
    }

    private boolean isColumnCentered(int index) {
        return this.getColumn(index).getAlignment() == 0x1000000;
    }

    private Size getCheckBoxImageSize() {
        if (!this.layoutCache.hasCheckBoxImageSize()) {
            this.layoutCache.checkBoxImageSize = this.getThemeAdapter().getCheckBoxImageSize((Control)this);
        }
        return this.layoutCache.checkBoxImageSize;
    }

    private BoxDimensions getCheckBoxMargin() {
        if (!this.layoutCache.hasCheckBoxMargin()) {
            this.layoutCache.checkBoxMargin = this.getThemeAdapter().getCheckBoxMargin((Control)this);
        }
        return this.layoutCache.checkBoxMargin;
    }

    BoxDimensions getCellPadding() {
        if (!this.layoutCache.hasCellPadding()) {
            this.layoutCache.cellPadding = this.getThemeAdapter().getCellPadding((Control)this);
        }
        return this.layoutCache.cellPadding;
    }

    BoxDimensions getHeaderPadding() {
        if (!this.layoutCache.hasHeaderPadding()) {
            this.layoutCache.headerPadding = this.getThemeAdapter().getHeaderPadding((Control)this);
        }
        return this.layoutCache.headerPadding;
    }

    int getIndentationWidth() {
        if (!this.isTree) {
            return 0;
        }
        if (!this.layoutCache.hasIndentationWidth()) {
            this.layoutCache.indentationWidth = this.getThemeAdapter().getIndentationWidth((Control)this);
        }
        return this.layoutCache.indentationWidth;
    }

    int getCellSpacing() {
        if (!this.layoutCache.hasCellSpacing()) {
            this.layoutCache.cellSpacing = this.getThemeAdapter().getCellSpacing((Control)this);
        }
        return this.layoutCache.cellSpacing;
    }

    private GridThemeAdapter getThemeAdapter() {
        return (GridThemeAdapter)this.getAdapter(ThemeAdapter.class);
    }

    private static int checkStyle(int style) {
        int mask = 302517030;
        int result = style & mask;
        result |= 0x20000000;
        return result |= 0x10000;
    }

    private RowRange getRowRange(int start, int availableHeight, boolean forceEndCompletelyInside, boolean inverse) {
        RowRange result = new RowRange();
        int startIndex = start;
        if (startIndex == -1) {
            if (inverse) {
                startIndex = this.items.size();
            }
            while (this.isValidItemIndex(startIndex += inverse ? -1 : 1) && !this.items.get(startIndex).isVisible()) {
            }
            if (!this.isValidItemIndex(startIndex)) {
                result = null;
            }
        }
        if (result != null) {
            if (startIndex < 0 || startIndex >= this.items.size() || !this.items.get(startIndex).isVisible()) {
                SWT.error((int)5);
            }
            if (availableHeight <= 0) {
                result.startIndex = startIndex;
                result.endIndex = startIndex;
                result.rows = 0;
                result.height = 0;
            } else if (this.isTree || this.hasDifferingHeights) {
                int otherIndex = startIndex;
                int consumedItems = 0;
                int consumedHeight = 0;
                ++consumedItems;
                consumedHeight += this.items.get(otherIndex).getHeight();
                boolean abort = false;
                while (consumedHeight + 1 <= availableHeight && !abort) {
                    GridItem nextItem;
                    int nextIndex = otherIndex;
                    while ((nextItem = this.isValidItemIndex(nextIndex += inverse ? -1 : 1) ? this.items.get(nextIndex) : null) != null && !nextItem.isVisible()) {
                    }
                    if (nextItem == null || forceEndCompletelyInside && consumedHeight + nextItem.getHeight() > availableHeight) {
                        abort = true;
                        continue;
                    }
                    ++consumedItems;
                    consumedHeight += nextItem.getHeight();
                    otherIndex = nextIndex;
                }
                result.startIndex = !inverse ? startIndex : otherIndex;
                result.endIndex = !inverse ? otherIndex : startIndex;
                result.rows = consumedItems;
                result.height = consumedHeight;
            } else {
                int availableRows = availableHeight / this.getItemHeight();
                if (!forceEndCompletelyInside && availableRows * this.getItemHeight() < availableHeight) {
                    ++availableRows;
                }
                int otherIndex = startIndex + (availableRows - 1) * (inverse ? -1 : 1);
                otherIndex = Math.max(otherIndex, 0);
                otherIndex = Math.min(otherIndex, this.items.size() - 1);
                result.startIndex = !inverse ? startIndex : otherIndex;
                result.endIndex = !inverse ? otherIndex : startIndex;
                result.rows = result.endIndex - result.startIndex + 1;
                result.height = this.getItemHeight() * result.rows;
            }
        }
        return result;
    }

    private boolean isValidItemIndex(int index) {
        return index >= 0 && index < this.items.size();
    }

    private boolean isValidCell(Point cell) {
        if (cell.x < 0 || cell.x >= this.columns.size()) {
            return false;
        }
        return cell.y >= 0 && cell.y < this.items.size();
    }

    int internalIndexOf(GridItem item) {
        return this.items.indexOf((Object)item);
    }

    void scheduleRedraw() {
        this.invalidateScrollBars();
        this.invalidateTopBottomIndex();
        this.redraw();
    }

    void invalidateTopBottomIndex() {
        this.topIndex = -1;
        this.bottomIndex = -1;
    }

    void invalidateScrollBars() {
        this.scrollValuesObsolete = true;
    }

    void invalidateDefaultRowHeadersText() {
        this.defaultRowHeadersTextObsolete = true;
        this.redraw();
    }

    void setHasSpanning(boolean hasSpanning) {
        this.hasSpanning = hasSpanning;
    }

    boolean isRowHeadersColumn(GridColumn column) {
        return column != null && column == this.rowHeadersColumn;
    }

    GridColumn getRowHeadersColumn() {
        return this.rowHeadersColumn;
    }

    private void createRowHeadersColumn() {
        this.isInternalColumn = true;
        this.rowHeadersColumn = new GridColumn(this, 0);
        this.rowHeadersColumn.setMoveable(false);
        this.rowHeadersColumn.setMinimumWidth(0);
        this.rowHeadersColumn.setWidth(0);
        this.isInternalColumn = false;
    }

    private boolean isFixedColumn(GridColumn column) {
        int fixedColumns = this.getFixedColumns();
        if (fixedColumns <= 0) {
            return false;
        }
        if (this.isRowHeadersColumn(column)) {
            return true;
        }
        int[] columnOrder = this.getColumnOrder();
        int visualIndex = -1;
        int i = 0;
        while (i < columnOrder.length && visualIndex == -1) {
            if (this.indexOf(column) == columnOrder[i]) {
                visualIndex = i;
            }
            ++i;
        }
        return visualIndex < fixedColumns - 1;
    }

    private int getFixedColumns() {
        if (!(this.getData("org.eclipse.rap.rwt.rowTemplate") instanceof Template)) {
            Object fixedColumns = this.getData("org.eclipse.rap.rwt.fixedColumns");
            if (fixedColumns instanceof Integer) {
                return (Integer)fixedColumns + 1;
            }
            return 1;
        }
        return -1;
    }

    private final class CellToolTipProvider
    implements ICellToolTipProvider,
    SerializableCompatibility {
        private CellToolTipProvider() {
        }

        public void getToolTipText(Item item, int columnIndex) {
            String toolTipText = ((GridItem)item).getToolTipText(columnIndex);
            Grid.this.getAdapter(ICellToolTipAdapter.class).setCellToolTipText(toolTipText);
        }
    }

    private final class GridAdapter
    implements IGridAdapter,
    ICellToolTipAdapter,
    ItemProvider,
    SerializableCompatibility {
        private String toolTipText;
        private ICellToolTipProvider provider;

        public GridAdapter() {
            this.provider = new CellToolTipProvider();
        }

        @Override
        public void invalidateTopIndex() {
            Grid.this.invalidateTopBottomIndex();
            Grid.this.redraw();
        }

        @Override
        public int getIndentationWidth() {
            return Grid.this.getIndentationWidth();
        }

        @Override
        public int getCellLeft(int index) {
            return Grid.this.getCellLeft(index);
        }

        @Override
        public int getCellWidth(int index) {
            return Grid.this.getCellWidth(index);
        }

        @Override
        public int getCheckBoxOffset(int index) {
            return Grid.this.getCheckBoxOffset(index);
        }

        @Override
        public int getCheckBoxWidth(int index) {
            return Grid.this.getCheckBoxWidth(index);
        }

        @Override
        public int getImageOffset(int index) {
            return Grid.this.getImageOffset(index);
        }

        @Override
        public int getImageWidth(int index) {
            return Grid.this.getImageWidth(index);
        }

        @Override
        public int getTextOffset(int index) {
            return Grid.this.getTextOffset(index);
        }

        @Override
        public int getTextWidth(int index) {
            return Grid.this.getTextWidth(index);
        }

        @Override
        public int getRowHeaderImageOffset() {
            return Grid.this.getRowHeaderImageOffset();
        }

        @Override
        public int getRowHeaderImageWidth() {
            return Grid.this.getRowHeaderImageWidth();
        }

        @Override
        public int getRowHeaderTextOffset() {
            return Grid.this.getRowHeaderTextOffset();
        }

        @Override
        public int getRowHeaderTextWidth() {
            return Grid.this.getRowHeaderTextWidth();
        }

        @Override
        public int getItemIndex(GridItem item) {
            return item.index;
        }

        public ICellToolTipProvider getCellToolTipProvider() {
            return this.provider;
        }

        public void setCellToolTipProvider(ICellToolTipProvider provider) {
            this.provider = provider;
        }

        public String getCellToolTipText() {
            return this.toolTipText;
        }

        public void setCellToolTipText(String toolTipText) {
            this.toolTipText = toolTipText;
        }

        @Override
        public void doRedraw() {
            Grid.this.doRedraw();
        }

        public void provideItems(WidgetTreeVisitor visitor) {
            for (GridColumnGroup columnGroup : Grid.this.columnGroups) {
                visitor.visit((Widget)columnGroup);
            }
            if (Grid.this.rowHeadersColumn != null) {
                visitor.visit((Widget)Grid.this.rowHeadersColumn);
            }
            for (GridColumn column : Grid.this.columns) {
                visitor.visit((Widget)column);
            }
            if (Grid.this.isVirtual()) {
                for (GridItem item : Grid.this.items) {
                    if (!item.isResolved()) continue;
                    visitor.visit((Widget)item);
                }
            } else {
                for (GridItem item : Grid.this.items) {
                    visitor.visit((Widget)item);
                }
            }
        }

        @Override
        public int getFixedColumns() {
            return Grid.this.getFixedColumns();
        }

        @Override
        public boolean isFixedColumn(GridColumn column) {
            return Grid.this.isFixedColumn(column);
        }

        @Override
        public int getTreeColumn() {
            int offset;
            int n = offset = Grid.this.rowHeadersColumn != null ? 1 : 0;
            if (Grid.this.treeColumn != null) {
                return Grid.this.indexOf(Grid.this.treeColumn) + offset;
            }
            if (Grid.this.getColumnCount() > 0) {
                return Grid.this.getColumnOrder()[0] + offset;
            }
            return -1;
        }

        @Override
        public int getSelectionType() {
            return Grid.this.selectionType;
        }

        @Override
        public GridColumn getRowHeadersColumn() {
            return Grid.this.getRowHeadersColumn();
        }
    }

    static final class LayoutCache
    implements SerializableCompatibility {
        private static final int UNKNOWN = -1;
        int headerHeight = -1;
        int footerHeight = -1;
        int itemHeight = -1;
        int cellSpacing = -1;
        int indentationWidth = -1;
        BoxDimensions cellPadding;
        BoxDimensions headerPadding;
        BoxDimensions checkBoxMargin;
        Size checkBoxImageSize;

        LayoutCache() {
        }

        public boolean hasHeaderPadding() {
            return this.headerPadding != null;
        }

        public void invalidateHeaderPadding() {
            this.headerPadding = null;
        }

        public boolean hasHeaderHeight() {
            return this.headerHeight != -1;
        }

        public void invalidateHeaderHeight() {
            this.headerHeight = -1;
        }

        public boolean hasFooterHeight() {
            return this.footerHeight != -1;
        }

        public void invalidateFooterHeight() {
            this.footerHeight = -1;
        }

        public boolean hasItemHeight() {
            return this.itemHeight != -1;
        }

        public void invalidateItemHeight() {
            this.itemHeight = -1;
        }

        public boolean hasCellSpacing() {
            return this.cellSpacing != -1;
        }

        public void invalidateCellSpacing() {
            this.cellSpacing = -1;
        }

        public boolean hasIndentationWidth() {
            return this.indentationWidth != -1;
        }

        public void invalidateIndentationWidth() {
            this.indentationWidth = -1;
        }

        public boolean hasCellPadding() {
            return this.cellPadding != null;
        }

        public void invalidateCellPadding() {
            this.cellPadding = null;
        }

        public boolean hasCheckBoxMargin() {
            return this.checkBoxMargin != null;
        }

        public void invalidateCheckBoxMargin() {
            this.checkBoxMargin = null;
        }

        public boolean hasCheckBoxImageSize() {
            return this.checkBoxImageSize != null;
        }

        public void invalidateCheckBoxImageSize() {
            this.checkBoxImageSize = null;
        }

        public void invalidateAll() {
            this.invalidateHeaderPadding();
            this.invalidateHeaderHeight();
            this.invalidateFooterHeight();
            this.invalidateItemHeight();
            this.invalidateCellSpacing();
            this.invalidateCellPadding();
            this.invalidateCheckBoxMargin();
            this.invalidateCheckBoxImageSize();
            this.invalidateIndentationWidth();
        }
    }

    private static class RowRange {
        public int startIndex;
        public int endIndex;
        public int rows;
        public int height;

        private RowRange() {
        }
    }
}

