/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.core.s.nls.TranslationValidator;
import org.eclipse.scout.sdk.s2e.ui.fields.text.TextField;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.AbstractTranslationDialog;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.TranslationInputValidator;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizardPage;
import org.eclipse.swt.widgets.Shell;

public class TranslationNewDialog
extends AbstractTranslationDialog {
    public TranslationNewDialog(Shell parentShell, TranslationStoreStack project, ITranslation row) {
        super(parentShell, "New Entry", row, project, true);
    }

    @Override
    protected void postCreate() {
        this.getKeyField().addModifyListener(e -> this.revalidate());
        TextField defaultField = this.getDefaultTranslationField();
        if (defaultField != null) {
            defaultField.addModifyListener(e -> this.revalidate());
        }
        this.revalidate();
    }

    @Override
    protected void revalidate() {
        MultiStatus status = new MultiStatus("org.eclipse.scout.sdk.s2e.ui", 0, "multi status", null);
        status.add(TranslationInputValidator.validateTranslationStore(this.getSelectedStore().orElse(null)));
        this.getSelectedStore().ifPresent(store -> status.add(TranslationInputValidator.validateNlsKey(this.getNlsProject(), store, this.getKeyField().getText())));
        TextField defaultLanguageField = this.getTranslationField(Language.LANGUAGE_DEFAULT);
        if (defaultLanguageField != null) {
            status.add(TranslationInputValidator.validateDefaultTranslation(defaultLanguageField.getText()));
        }
        IStatus worst = AbstractWizardPage.getHighestSeverityStatus((IStatus)status);
        if (status.isOK()) {
            this.setMessage("Create a new translation.");
        } else {
            this.setMessage(worst);
        }
        this.getButton(0).setEnabled(!TranslationValidator.isForbidden((int)worst.getCode()));
    }
}

