/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.action;

import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTable;
import org.eclipse.swt.widgets.MessageBox;

public class TranslationRefreshAction
extends Action {
    private final TranslationManager m_nlsProject;
    private final NlsTable m_table;

    public TranslationRefreshAction(TranslationManager project, NlsTable table) {
        super("Refresh Translations");
        this.m_nlsProject = project;
        this.m_table = table;
        this.setImageDescriptor(S2ESdkUiActivator.getImageDescriptor("refresh.gif"));
    }

    public void run() {
        if (this.m_nlsProject.isDirty()) {
            MessageBox msgBox = new MessageBox(this.m_table.getShell(), 448);
            msgBox.setMessage("There are unsaved changes. By refreshing all changes will be lost.\nDo you want to save your changes before refreshing?");
            msgBox.setText("Save changes before refreshing?");
            int result = msgBox.open();
            if (result == 256) {
                return;
            }
            if (result == 64) {
                EclipseEnvironment.runInEclipseEnvironment((arg_0, arg_1) -> ((TranslationManager)this.m_nlsProject).flush(arg_0, arg_1)).awaitDoneThrowingOnErrorOrCancel();
            }
        }
        EclipseEnvironment.runInEclipseEnvironment((env, progress) -> this.execute((IProgress)progress)).awaitDoneThrowingOnErrorOrCancel();
    }

    protected void execute(IProgress progress) {
        this.m_nlsProject.reload(progress.init(100, (CharSequence)"Refresh translations", new Object[0]));
    }
}

