/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.internal.tool.command.builders;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.AbsoluteBoundsFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Gate;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.LayoutConstants;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tools.api.ui.PostRefreshCommandFactory;
import org.eclipse.sirius.tools.api.ui.RefreshEditorsPrecommitListener;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class SequenceCreatedEventsFlaggingSiriusCommand
extends SiriusCommand {
    private Predicate<DDiagramElement> shouldFlag;
    private DDiagram parentDiagram;
    private Point lostNodesLocation;

    public SequenceCreatedEventsFlaggingSiriusCommand(TransactionalEditingDomain domain, String name, DDiagram diagram, Predicate<DDiagramElement> shouldFlag) {
        super(domain, name);
        this.parentDiagram = diagram;
        this.shouldFlag = this.completeShouldFlagPredicate(shouldFlag);
    }

    private Predicate<DDiagramElement> completeShouldFlagPredicate(Predicate<DDiagramElement> pred) {
        Predicate result = LostMessageEnd.viewpointElementPredicate();
        if (pred != null) {
            result = Predicates.or(pred, result);
        }
        return result;
    }

    protected void doExecute() {
        super.doExecute();
        this.flagNewElements();
    }

    private void flagNewElements() {
        Collection createdSemantics = this.getCreatedObjects();
        Collection<EObject> mainSemantics = this.flagAndRegisterMainCreatedElements();
        this.flagPostRefresh(mainSemantics, createdSemantics);
        this.flagPostPrecommitRefresh(mainSemantics, createdSemantics);
    }

    private void flagPostPrecommitRefresh(Collection<EObject> mainSemantics, Collection<EObject> createdObjects) {
        EObject semanticElement;
        Session session;
        if (this.parentDiagram instanceof DSemanticDecorator && ((DSemanticDecorator)this.parentDiagram).getTarget() != null && (session = SessionManager.INSTANCE.getSession(semanticElement = ((DSemanticDecorator)this.parentDiagram).getTarget())) != null) {
            RefreshEditorsPrecommitListener listener = session.getRefreshEditorsListener();
            SequencePostRefreshFactory factory = new SequencePostRefreshFactory(this.parentDiagram, session, mainSemantics, createdObjects);
            listener.addPostRefreshCommandFactory((PostRefreshCommandFactory)factory);
        }
    }

    private Collection<EObject> flagAndRegisterMainCreatedElements() {
        HashSet<EObject> mainSemantics = new HashSet<EObject>();
        ArrayList createdDDE = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.getCreatedRepresentationElements(), DDiagramElement.class));
        for (DDiagramElement dde : createdDDE) {
            if (this.shouldFlag != null && this.shouldFlag.apply((Object)dde)) {
                this.safeAddCreationFlag(dde, LayoutConstants.TOOL_CREATION_FLAG);
                mainSemantics.add(dde.getTarget());
                continue;
            }
            if (dde.getTarget() == null) continue;
            mainSemantics.add(dde.getTarget());
        }
        return mainSemantics;
    }

    private Collection<DDiagramElement> flagPostRefresh(Collection<EObject> mainSemantics, Collection<EObject> createdSemantics) {
        ArrayList<DDiagramElement> flags = new ArrayList<DDiagramElement>();
        if (this.parentDiagram != null && this.shouldFlag != null) {
            for (DDiagramElement dde : Iterables.filter((Iterable)this.parentDiagram.getDiagramElements(), this.shouldFlag)) {
                Option<DDiagramElement> flagged = Options.newNone();
                if (dde.getTarget() != null) {
                    if (mainSemantics.contains(dde.getTarget())) {
                        flagged = this.safeAddCreationFlag(dde, LayoutConstants.TOOL_CREATION_FLAG);
                    } else if (createdSemantics.contains(dde.getTarget())) {
                        flagged = this.safeAddCreationFlag(dde, LayoutConstants.TOOL_CREATION_FLAG_FROM_SEMANTIC);
                    }
                }
                if (!flagged.some()) continue;
                flags.add((DDiagramElement)flagged.get());
            }
        }
        return flags;
    }

    private Option<DDiagramElement> safeAddCreationFlag(DDiagramElement dde, Rectangle toolCreationFlag) {
        if (Iterables.isEmpty((Iterable)Iterables.filter((Iterable)dde.getGraphicalFilters(), AbsoluteBoundsFilter.class))) {
            AbsoluteBoundsFilter flag = this.getFlag(toolCreationFlag);
            if (this.lostNodesLocation != null) {
                if (LostMessageEnd.viewpointElementPredicate().apply((Object)dde)) {
                    flag.setY(Integer.valueOf(this.lostNodesLocation.y));
                } else if (Gate.viewpointElementPredicate().apply((Object)dde)) {
                    flag.setY(Integer.valueOf(this.lostNodesLocation.y));
                    flag.setWidth(flag.getX());
                    flag.setX(Integer.valueOf(this.lostNodesLocation.x));
                }
            }
            dde.getGraphicalFilters().add((Object)flag);
            return Options.newSome((Object)dde);
        }
        return Options.newNone();
    }

    private AbsoluteBoundsFilter getFlag(Rectangle toolCreationFlag) {
        AbsoluteBoundsFilter flag = DiagramFactory.eINSTANCE.createAbsoluteBoundsFilter();
        flag.setX(Integer.valueOf(toolCreationFlag.x));
        flag.setY(Integer.valueOf(toolCreationFlag.y));
        flag.setHeight(Integer.valueOf(toolCreationFlag.height));
        flag.setWidth(Integer.valueOf(toolCreationFlag.width));
        return flag;
    }

    public void setLostNodesLocation(Point location) {
        this.lostNodesLocation = location;
    }

    private final class SequenceFlagAndSyncCommand
    extends RecordingCommand {
        private final Collection<EObject> mainSemantics;
        private final Collection<EObject> createdObjects;
        private final Diagram gmfDiag;

        SequenceFlagAndSyncCommand(TransactionalEditingDomain domain, Diagram gmfDiag, Collection<EObject> mainSemantics, Collection<EObject> createdObjects) {
            super(domain, Messages.SequenceFlagAndSyncCommand_commandName);
            this.mainSemantics = new ArrayList<EObject>();
            this.createdObjects = new ArrayList<EObject>();
            this.gmfDiag = gmfDiag;
            this.mainSemantics.addAll(mainSemantics);
            this.createdObjects.addAll(createdObjects);
        }

        protected void doExecute() {
            Collection<DDiagramElement> flagPostRefresh = SequenceCreatedEventsFlaggingSiriusCommand.this.flagPostRefresh(this.mainSemantics, this.createdObjects);
            if (flagPostRefresh != null && Iterables.any(flagPostRefresh, LostMessageEnd.viewpointElementPredicate())) {
                CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(this.gmfDiag);
                canonicalSynchronizer.storeViewsToArrange(false);
                canonicalSynchronizer.synchronize();
            }
            if (this.mainSemantics != null) {
                this.mainSemantics.clear();
            }
            if (this.createdObjects != null) {
                this.createdObjects.clear();
            }
        }
    }

    private final class SequencePostRefreshFactory
    implements PostRefreshCommandFactory {
        private final Collection<EObject> mainSemantics = new ArrayList<EObject>();
        private final Collection<EObject> createdObjects = new ArrayList<EObject>();
        private final Session session;
        private final DDiagram diagram;

        SequencePostRefreshFactory(DDiagram parentDiagram, Session session, Collection<EObject> mainSemantics, Collection<EObject> createdObjects) {
            this.diagram = parentDiagram;
            this.session = session;
            this.mainSemantics.addAll(mainSemantics);
            this.createdObjects.addAll(createdObjects);
        }

        public Command getPostCommandToExecute(TransactionalEditingDomain domain, Collection<DRepresentation> refreshedRepresentations) {
            Collection gmfDiags;
            CompoundCommand result = null;
            if (this.session != null && this.diagram != null && refreshedRepresentations.contains(this.diagram) && !(gmfDiags = this.session.getServices().getCustomData("GMF_DIAGRAMS", (EObject)this.diagram)).isEmpty()) {
                CompoundCommand cc = new CompoundCommand();
                for (Diagram gmfDiag : Iterables.filter((Iterable)gmfDiags, Diagram.class)) {
                    cc.append((Command)new SequenceFlagAndSyncCommand(domain, gmfDiag, this.mainSemantics, this.createdObjects));
                }
                result = cc;
            }
            return result;
        }
    }
}

