/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.osgi.framework.Version;

public class DiagramRepresentationsFileMigrationParticipantV680 {
    public static final Version MIGRATION_VERSION = new Version("6.8.0.201307151200");

    public void migrateCompartmentsWithLayoutConstraints(List<Diagram> diagrams) {
        for (Diagram diagram : diagrams) {
            UnmodifiableIterator compartmentIterator = Iterators.filter((Iterator)diagram.eAllContents(), (Predicate)new IsCompartmentPredicate());
            while (compartmentIterator.hasNext()) {
                Node node = (Node)compartmentIterator.next();
                if (node.getLayoutConstraint() == null) continue;
                node.setLayoutConstraint(null);
            }
        }
    }

    public void migrateEdgeLabelLocationToBounds(List<Diagram> diagrams) {
        for (Diagram diagram : diagrams) {
            for (Edge edge : Iterables.filter((Iterable)diagram.getEdges(), Edge.class)) {
                for (Node edgeLabel : Iterables.filter((Iterable)edge.getChildren(), Node.class)) {
                    LayoutConstraint layoutConstraint = edgeLabel.getLayoutConstraint();
                    if (!new ViewQuery((View)edgeLabel).isForEdgeNameEditPart() || layoutConstraint instanceof Bounds || !(layoutConstraint instanceof Location)) continue;
                    Location location = (Location)layoutConstraint;
                    Bounds bounds = NotationFactory.eINSTANCE.createBounds();
                    bounds.setX(location.getX());
                    bounds.setY(location.getY());
                    edgeLabel.setLayoutConstraint((LayoutConstraint)bounds);
                }
            }
        }
    }

    private final class IsCompartmentPredicate
    implements Predicate<EObject> {
        private IsCompartmentPredicate() {
        }

        public boolean apply(EObject arg0) {
            if (arg0 instanceof Node) {
                int id = SiriusVisualIDRegistry.getVisualID(((Node)arg0).getType());
                return id == 7002 || id == 7001;
            }
            return false;
        }
    }
}

