/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.ui.interpreter.internal.InterpreterImages;
import org.eclipse.sirius.ui.interpreter.internal.InterpreterMessages;
import org.eclipse.sirius.ui.interpreter.internal.SWTUtil;
import org.eclipse.sirius.ui.interpreter.internal.interpreter.SiriusInterpreter;
import org.eclipse.sirius.ui.interpreter.internal.language.AbstractLanguageInterpreter;
import org.eclipse.sirius.ui.interpreter.internal.language.CompilationResult;
import org.eclipse.sirius.ui.interpreter.internal.language.EvaluationResult;
import org.eclipse.sirius.ui.interpreter.internal.language.IInterpreterSourceViewer;
import org.eclipse.sirius.ui.interpreter.internal.language.InterpreterContext;
import org.eclipse.sirius.ui.interpreter.internal.language.SplitExpression;
import org.eclipse.sirius.ui.interpreter.internal.optional.InterpreterDependencyChecks;
import org.eclipse.sirius.ui.interpreter.internal.optional.debug.DebugViewHelper;
import org.eclipse.sirius.ui.interpreter.internal.view.FormMessageManager;
import org.eclipse.sirius.ui.interpreter.internal.view.IFormMessageManager;
import org.eclipse.sirius.ui.interpreter.internal.view.Variable;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.ClearExpressionViewerAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.ClearResultViewerAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.ClearVariableViewerAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.DeleteVariableOrValueAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.EvaluateAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.LexicalSortAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.LinkWithEditorContextAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.NewVariableAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.RenameVariableAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.ToggleRealTimeAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.ToggleStepByStepVisibilityAction;
import org.eclipse.sirius.ui.interpreter.internal.view.actions.ToggleVariableVisibilityAction;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.ActivationListener;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.ExpressionMenuListener;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.InterpreterEditorPartListener;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.NotifierSelectionListener;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.ResultDoubleClickListener;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.ResultDragListener;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.ResultMenuListener;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.SubExpressionDoubleClickListener;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.SubExpressionListener;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.VariableContentProvider;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.VariableDropListener;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.VariableLabelProvider;
import org.eclipse.sirius.ui.interpreter.internal.view.listener.VariableMenuListener;
import org.eclipse.sirius.ui.interpreter.internal.view.providers.ResultContentProvider;
import org.eclipse.sirius.ui.interpreter.internal.view.providers.ResultLabelProvider;
import org.eclipse.sirius.ui.interpreter.internal.view.providers.StepByStepContentProvider;
import org.eclipse.sirius.ui.interpreter.internal.view.providers.StepLabelProvider;
import org.eclipse.sirius.ui.interpreter.internal.view.thread.CompilationThread;
import org.eclipse.sirius.ui.interpreter.internal.view.thread.EvaluationThread;
import org.eclipse.sirius.ui.interpreter.internal.view.thread.ExpressionSplittingThread;
import org.eclipse.sirius.ui.interpreter.internal.view.thread.RealTimeThread;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class InterpreterView
extends ViewPart
implements ISelectionProvider {
    public static final String COMPILATION_MESSAGE_PREFIX = "compilation.message";
    public static final String EVALUATION_MESSAGE_PREFIX = "evaluation.message";
    private static final String COMPILATION_INFO_MESSAGE_KEY = "interpreter.compilation.info.message";
    private static final String EVALUATION_INFO_MESSAGE_KEY = "interpreter.evaluation.info.message";
    private static final String INTERPRETER_VIEW_CONTEXT_ID = "org.eclipse.sirius.ui.interpreter.interpreterview";
    private static final String LANGUAGE_SPECIFIC_ACTION_GROUP = "LanguageSpecificActions";
    private static final String MEMENTO_EXPRESSION_KEY = "org.eclipse.sirius.ui.interpreter.memento.expression";
    private static final String MEMENTO_REAL_TIME_KEY = "org.eclipse.sirius.ui.interpreter.memento.realtime";
    private static final String MEMENTO_VARIABLES_VISIBLE_KEY = "org.eclipse.sirius.ui.interpreter.memento.variables.hide";
    private static final String MEMENTO_SUB_EXPRESSIONS_VISIBLE_KEY = "org.eclipse.sirius.ui.interpreter.memento.subexpressions.hide";
    private static final String MEMENTO_RESULT_SORTED_KEY = "org.eclipse.sirius.ui.interpreter.memento.result.sorted";
    private static final String MEMENTO_SUB_EXPRESSIONS_SORTED_KEY = "org.eclipse.sirius.ui.interpreter.memento.subexpressions.sorted";
    private static final String MENU_ID = "#PopupMenu";
    private static final String WORKBENCH_CONSTANT_EDIT_REDO = "org.eclipse.ui.edit.redo";
    private static final String WORKBENCH_CONSTANT_EDIT_UNDO = "org.eclipse.ui.edit.undo";
    private static final String NULL_RESULT_OBJECT = "null";
    protected CompilationResult compilationResult;
    protected CompilationThread compilationThread;
    protected LinkWithEditorContextAction linkWithEditorContextAction;
    ExecutorService evaluationPool = Executors.newSingleThreadExecutor();
    ExecutorService splittingPool = Executors.newSingleThreadExecutor();
    RealTimeThread realTimeThread;
    private IPartListener activationListener;
    private IHandlerActivation activationTokenContentAssist;
    private IHandlerActivation activationTokenRedo;
    private IHandlerActivation activationTokenUndo;
    private ExecutorService compilationPool = Executors.newSingleThreadExecutor();
    private IContextActivation contextActivationToken;
    private AbstractLanguageInterpreter currentLanguageInterpreter;
    private IPartListener2 editorPartListener;
    private ISelectionListener eobjectSelectionListener;
    private EvaluationThread evaluationThread;
    private ExpressionSplittingThread expressionSplittingThread;
    private Section expressionSection;
    private SourceViewer expressionViewer;
    private SashForm formBody;
    private SashForm bottomLeftColumn;
    private Composite subExpressionComposite;
    private FormToolkit formToolkit;
    private Form interpreterForm;
    private int messageCount;
    private IFormMessageManager messageManager;
    private IMemento partMemento;
    private boolean realTime;
    private Section resultSection;
    private Viewer resultViewer;
    private TreeViewer subExpressionViewer;
    @Deprecated
    private List<EObject> selectedEObjects;
    private List<Notifier> selectedNotifiers;
    private Composite variableColumn;
    private TreeViewer variableViewer;
    private boolean variableVisible;
    private boolean subExpressionsVisible;

    protected static final ToolBarManager createSectionToolBar(Section section) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800100);
        final ToolBar toolBar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolBar.setCursor(handCursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        section.setTextClient((Control)toolBar);
        toolBar.setData((Object)toolBarManager);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolBar.setData(null);
            }
        });
        return toolBarManager;
    }

    protected static final ToolBarManager getSectionToolBar(Section section) {
        ToolBar toolBar;
        Object data;
        Control textClient = section.getTextClient();
        if (textClient instanceof ToolBar && (data = (toolBar = (ToolBar)textClient).getData()) instanceof ToolBarManager) {
            return (ToolBarManager)data;
        }
        return null;
    }

    public void addVariables(Object variableValue) {
        NewVariableAction action = new NewVariableAction(this.variableViewer, variableValue);
        action.run();
    }

    private void compileExpression() {
        InterpreterContext context = this.getInterpreterContext();
        Callable<CompilationResult> compilationTask = this.getCurrentLanguageInterpreter().getCompilationTask(context);
        this.clearCompilationMessages();
        if (compilationTask != null) {
            Future<CompilationResult> compilationFuture = this.compilationPool.submit(compilationTask);
            this.compilationThread = new CompilationThread(compilationFuture, this);
            this.compilationThread.start();
        }
    }

    public void evaluateSubExpression(final Object expression) {
        if (this.expressionViewer == null || this.expressionViewer.getTextWidget() == null || this.expressionViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (this.compilationThread != null && !this.compilationThread.isInterrupted()) {
            this.compilationThread.interrupt();
        }
        if (this.evaluationThread != null && !this.evaluationThread.isInterrupted()) {
            this.evaluationThread.interrupt();
        }
        this.clearCompilationMessages();
        Future<CompilationResult> compilationFuture = this.compilationPool.submit(new Callable<CompilationResult>(){

            @Override
            public CompilationResult call() throws Exception {
                return new CompilationResult(expression);
            }
        });
        this.compilationThread = new CompilationThread(compilationFuture, this);
        this.compilationThread.start();
        InterpreterContext interpreterContext = this.getInterpreterContext();
        if (interpreterContext != null) {
            this.evaluationThread = new EvaluationThread(interpreterContext, this);
            this.evaluationThread.start();
        }
    }

    public void createPartControl(Composite parent) {
        SashForm rootContainer = new SashForm(parent, 256);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        rootContainer.setLayout((Layout)layout);
        this.formToolkit = new FormToolkit(rootContainer.getDisplay());
        this.createInterpreterForm(this.formToolkit, (Composite)rootContainer);
        this.partMemento = null;
    }

    public void dispose() {
        IWorkbenchWindow workbenchWindow;
        if (this.compilationThread != null && !this.compilationThread.isInterrupted()) {
            this.compilationThread.interrupt();
        }
        if (this.evaluationThread != null && !this.evaluationThread.isInterrupted()) {
            this.evaluationThread.interrupt();
        }
        if (this.contextActivationToken != null) {
            IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
            contextService.deactivateContext(this.contextActivationToken);
        }
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (this.activationTokenContentAssist != null) {
            handlerService.deactivateHandler(this.activationTokenContentAssist);
        }
        if (this.activationTokenRedo != null) {
            handlerService.deactivateHandler(this.activationTokenRedo);
        }
        if (this.activationTokenUndo != null) {
            handlerService.deactivateHandler(this.activationTokenUndo);
        }
        if ((workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && workbenchWindow.getActivePage() != null && this.eobjectSelectionListener != null) {
            workbenchWindow.getActivePage().removeSelectionListener(this.eobjectSelectionListener);
        }
        this.clearSelection();
        IWorkbenchPage currentPage = this.getSite().getPage();
        if (currentPage != null) {
            currentPage.removePartListener(this.editorPartListener);
        }
        this.getSite().getPage().removePartListener(this.activationListener);
        super.dispose();
    }

    public void compileAndEvaluate() {
        boolean cancelRequest = false;
        if (this.expressionViewer == null || this.expressionViewer.getTextWidget() == null || this.expressionViewer.getTextWidget().isDisposed()) {
            cancelRequest = true;
        } else {
            String text = this.expressionViewer.getTextWidget().getText();
            if (text == null || text.length() == 0) {
                cancelRequest = true;
            }
        }
        if (cancelRequest) {
            return;
        }
        if (this.compilationThread != null && !this.compilationThread.isInterrupted()) {
            this.compilationThread.interrupt();
        }
        if (this.evaluationThread != null && !this.evaluationThread.isInterrupted()) {
            this.evaluationThread.interrupt();
        }
        if (this.expressionSplittingThread != null && !this.expressionSplittingThread.isInterrupted()) {
            this.expressionSplittingThread.interrupt();
        }
        this.compileExpression();
        this.evaluate();
        this.splitExpression();
    }

    private void evaluate() {
        this.clearEvaluationMessages();
        InterpreterContext interpreterContext = this.getInterpreterContext();
        if (interpreterContext != null) {
            this.evaluationThread = new EvaluationThread(interpreterContext, this);
            this.evaluationThread.start();
        }
    }

    private void splitExpression() {
        InterpreterContext interpreterContext = this.getInterpreterContext();
        if (interpreterContext != null) {
            this.expressionSplittingThread = new ExpressionSplittingThread(interpreterContext, this);
            this.expressionSplittingThread.start();
        }
    }

    public final void setSubExpressions(SplitExpression splitExpression) {
        TreeViewer viewer = this.subExpressionViewer;
        if (splitExpression != null) {
            viewer.setInput(Collections.singleton(splitExpression));
        } else {
            viewer.setInput(null);
        }
    }

    public final AbstractLanguageInterpreter getCurrentLanguageInterpreter() {
        if (this.currentLanguageInterpreter == null) {
            this.currentLanguageInterpreter = new SiriusInterpreter();
        }
        return this.currentLanguageInterpreter;
    }

    public InterpreterContext getInterpreterContext() {
        Object variableViewerInput;
        if (this.expressionViewer == null || this.expressionViewer.getTextWidget() == null) {
            return null;
        }
        String fullExpression = this.expressionViewer.getTextWidget().getText();
        List<Object> targetNotifiers = this.selectedNotifiers;
        if (targetNotifiers == null) {
            targetNotifiers = Collections.emptyList();
        }
        List<Variable> variables = (variableViewerInput = this.variableViewer.getInput()) instanceof List ? new ArrayList((List)variableViewerInput) : Collections.emptyList();
        ISelection selection = this.expressionViewer.getSelection();
        if (selection == null || selection instanceof ITextSelection && ((ITextSelection)selection).getLength() == 0) {
            selection = new TextSelection(this.expressionViewer.getDocument(), 0, fullExpression.length());
        }
        if (InterpreterDependencyChecks.isDebugAccessible()) {
            List<Variable> debugVariables = DebugViewHelper.getCurrentDebugThreadVariables();
            for (Variable var : debugVariables) {
                boolean duplicate = false;
                int i = 0;
                while (i < variables.size() && !duplicate) {
                    duplicate = variables.get(i).getName().equals(var.getName());
                    ++i;
                }
                if (duplicate) continue;
                variables.addAll(debugVariables);
            }
        }
        return new InterpreterContext(fullExpression, selection, targetNotifiers, variables);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.partMemento = memento;
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        this.contextActivationToken = contextService.activateContext(INTERPRETER_VIEW_CONTEXT_ID);
        this.eobjectSelectionListener = new NotifierSelectionListener(this);
        this.activationListener = new ActivationListener(this);
        site.getPage().addPartListener(this.activationListener);
        site.getPage().addSelectionListener(this.eobjectSelectionListener);
        if (site.getPart() != null && site.getPage().getSelection() != null) {
            this.eobjectSelectionListener.selectionChanged(site.getPart(), site.getPage().getSelection());
        }
    }

    public boolean isVariableVisible() {
        return this.variableVisible;
    }

    public void linkWithEditorContext() {
        IWorkbenchPage page = this.getSite().getPage();
        if (!this.linkWithEditorContextAction.isEnabled() || page == null || page.getActiveEditor() == null) {
            return;
        }
        IEditorPart activeEditor = page.getActiveEditor();
        if (this.linkWithEditorContextAction.isChecked()) {
            this.getCurrentLanguageInterpreter().linkWithEditor(activeEditor);
            this.linkWithEditorContextAction.changeTooltip(activeEditor);
        } else {
            this.getCurrentLanguageInterpreter().linkWithEditor(null);
            this.linkWithEditorContextAction.changeTooltip(null);
            if (activeEditor == null) {
                this.linkWithEditorContextAction.setEnabled(false);
            } else {
                this.linkWithEditorContextAction.setEnabled(this.getCurrentLanguageInterpreter().canLinkWithEditor(activeEditor));
            }
        }
    }

    public void saveState(IMemento memento) {
        if (this.partMemento != null) {
            memento.putMemento(this.partMemento);
        } else {
            memento.putString(MEMENTO_EXPRESSION_KEY, this.expressionViewer.getTextWidget().getText());
            memento.putBoolean(MEMENTO_REAL_TIME_KEY, Boolean.valueOf(this.realTime).booleanValue());
            memento.putBoolean(MEMENTO_VARIABLES_VISIBLE_KEY, Boolean.valueOf(this.variableViewer.getControl().isVisible()).booleanValue());
            memento.putBoolean(MEMENTO_SUB_EXPRESSIONS_VISIBLE_KEY, Boolean.valueOf(this.subExpressionViewer.getControl().isVisible()).booleanValue());
            if (this.resultViewer instanceof StructuredViewer) {
                memento.putBoolean(MEMENTO_RESULT_SORTED_KEY, Boolean.valueOf(((StructuredViewer)this.resultViewer).getComparator() != null).booleanValue());
            }
            memento.putBoolean(MEMENTO_SUB_EXPRESSIONS_SORTED_KEY, Boolean.valueOf(this.subExpressionViewer.getComparator() != null).booleanValue());
        }
    }

    public void setFocus() {
        if (this.expressionViewer != null) {
            this.expressionViewer.getControl().setFocus();
        }
    }

    public synchronized void toggleRealTime() {
        boolean bl = this.realTime = !this.realTime;
        if (this.realTime) {
            this.realTimeThread = new RealTimeThread(this);
            this.compileAndEvaluate();
            this.realTimeThread.start();
        } else if (this.realTimeThread != null) {
            this.realTimeThread.interrupt();
            this.realTimeThread = null;
        }
    }

    public void toggleVariableVisibility() {
        if (this.variableColumn != null && !this.variableColumn.isDisposed()) {
            int[] newWeights;
            this.variableVisible = !this.variableVisible;
            this.variableColumn.setVisible(this.variableVisible);
            if (this.variableVisible) {
                newWeights = new int[]{3, 1};
            } else {
                int[] nArray = new int[2];
                nArray[0] = 1;
                newWeights = nArray;
            }
            this.formBody.setWeights(newWeights);
            this.getForm().layout();
        }
    }

    public void toggleStepByStepVisibility() {
        if (this.subExpressionComposite != null && !this.subExpressionComposite.isDisposed()) {
            int[] newWeights;
            this.subExpressionsVisible = !this.subExpressionsVisible;
            this.subExpressionComposite.setVisible(this.subExpressionsVisible);
            if (this.subExpressionsVisible) {
                newWeights = new int[]{1, 1};
            } else {
                int[] nArray = new int[2];
                nArray[1] = 1;
                newWeights = nArray;
            }
            this.bottomLeftColumn.setWeights(newWeights);
            this.getForm().layout();
        }
    }

    protected final void addMessage(String messageKey, String message, int messageType) {
        Section targetControl = null;
        if (messageType != 0 && messageKey.startsWith(COMPILATION_MESSAGE_PREFIX)) {
            targetControl = this.expressionSection;
        } else if (messageType != 0 && messageKey.startsWith(EVALUATION_MESSAGE_PREFIX)) {
            targetControl = this.resultSection;
        }
        if (!this.getForm().isDisposed()) {
            if (targetControl != null) {
                this.getMessageManager().addMessage(messageKey, message, messageType, (Control)targetControl);
            } else {
                this.getMessageManager().addMessage(messageKey, message, messageType);
            }
        }
    }

    public final void addStatusMessages(IStatus status, String keyPrefix) {
        if (status instanceof MultiStatus) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.addStatusMessages(child, keyPrefix);
                ++n2;
            }
        } else {
            Object messageKey = status.getSeverity() == 0 ? (keyPrefix.equals(COMPILATION_MESSAGE_PREFIX) ? COMPILATION_INFO_MESSAGE_KEY : EVALUATION_INFO_MESSAGE_KEY) : keyPrefix + "." + this.messageCount++;
            this.addMessage((String)messageKey, status.getMessage(), this.convertStatusToMessageSeverity(status.getSeverity()));
        }
    }

    @Deprecated
    protected void addToSelection(EObject object) {
        if (this.selectedNotifiers == null) {
            this.selectedNotifiers = new ArrayList<Notifier>(1);
            this.selectedEObjects = new ArrayList<EObject>(1);
        }
        this.selectedNotifiers.add((Notifier)object);
        this.selectedEObjects.add(object);
    }

    public void addToSelection(Notifier notifier) {
        if (this.selectedNotifiers == null) {
            this.selectedNotifiers = new ArrayList<Notifier>(1);
            this.selectedEObjects = new ArrayList<EObject>(1);
        }
        this.selectedNotifiers.add(notifier);
        if (notifier instanceof EObject) {
            this.selectedEObjects.add((EObject)notifier);
        }
    }

    public void clearCompilationMessages() {
        this.getMessageManager().addMessage("none", "", 3);
        this.getMessageManager().removeMessage(COMPILATION_MESSAGE_PREFIX);
        this.getMessageManager().removeMessages((Control)this.expressionSection);
        this.getMessageManager().addMessage("none", "", 0);
        this.getMessageManager().removeMessage("none");
    }

    public void clearEvaluationMessages() {
        this.getMessageManager().addMessage("none", "", 3);
        this.getMessageManager().removeMessage(EVALUATION_INFO_MESSAGE_KEY);
        this.getMessageManager().removeMessages((Control)this.resultSection);
        this.getMessageManager().addMessage("none", "", 0);
        this.getMessageManager().removeMessage("none");
    }

    public void clearSelection() {
        if (this.selectedNotifiers != null) {
            this.selectedNotifiers.clear();
            this.selectedNotifiers = null;
            this.selectedEObjects.clear();
            this.selectedEObjects = null;
        }
    }

    protected AdapterFactory createAdapterFactory() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return adapterFactory;
    }

    protected IMenuListener createExpressionMenuListener(SourceViewer viewer) {
        return new ExpressionMenuListener(viewer, this);
    }

    protected void createExpressionSection(FormToolkit toolkit, Composite leftColumn) {
        this.expressionSection = toolkit.createSection(leftColumn, 256);
        this.expressionSection.setText(InterpreterMessages.getString("interpreter.view.expression.section.name"));
        Composite expressionSectionBody = toolkit.createComposite((Composite)this.expressionSection);
        GridLayout expressionSectionLayout = new GridLayout();
        expressionSectionBody.setLayout((Layout)expressionSectionLayout);
        this.expressionViewer = this.createExpressionViewer(expressionSectionBody);
        GridData gridData = new GridData(1808);
        this.expressionViewer.getControl().setLayoutData((Object)gridData);
        InterpreterView.createSectionToolBar(this.expressionSection);
        this.populateExpressionSectionToolbar(this.expressionSection);
        this.expressionSection.setClient((Control)expressionSectionBody);
        expressionSectionBody.layout();
        this.expressionSection.layout();
    }

    protected SourceViewer createExpressionViewer(Composite parent) {
        String expression;
        SourceViewer viewer = this.getCurrentLanguageInterpreter().createSourceViewer(parent);
        if (viewer == null) {
            viewer = SWTUtil.createScrollableSourceViewer(parent, 2816);
            viewer.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration());
            viewer.setDocument((IDocument)new Document());
        }
        this.getCurrentLanguageInterpreter().configureSourceViewer(viewer);
        if (viewer instanceof IInterpreterSourceViewer) {
            this.setUpContentAssist((IInterpreterSourceViewer)viewer);
        }
        this.setUpRealTimeCompilation(viewer);
        this.setUpDefaultTextAction(viewer);
        this.createExpressionMenu(viewer);
        if (this.partMemento != null && (expression = this.partMemento.getString(MEMENTO_EXPRESSION_KEY)) != null) {
            viewer.getDocument().set(expression);
        }
        return viewer;
    }

    protected void createInterpreterForm(FormToolkit toolkit, Composite parent) {
        this.interpreterForm = toolkit.createForm(parent);
        this.messageManager = new FormMessageManager(this.interpreterForm);
        this.getMessageManager().setDecorationPosition(16512);
        toolkit.decorateFormHeading(this.getForm());
        String languageName = InterpreterMessages.getString("SiriusInterpreter_label");
        this.getForm().setText(InterpreterMessages.getString("interpreter.view.title", languageName));
        Image titleImage = InterpreterImages.getImageDescriptor("view_icon.gif").createImage();
        this.setTitleImage(titleImage);
        this.getForm().setImage(titleImage);
        Composite mainBody = this.getForm().getBody();
        mainBody.setLayout((Layout)new GridLayout());
        this.formBody = new SashForm(mainBody, 65792);
        toolkit.adapt((Composite)this.formBody);
        this.formBody.setLayoutData((Object)new GridData(1808));
        SashForm leftColumn = new SashForm((Composite)this.formBody, 66048);
        toolkit.adapt((Composite)leftColumn);
        this.createExpressionSection(toolkit, (Composite)leftColumn);
        this.bottomLeftColumn = new SashForm((Composite)leftColumn, 65792);
        toolkit.adapt((Composite)this.bottomLeftColumn);
        this.subExpressionComposite = toolkit.createComposite((Composite)this.bottomLeftColumn);
        this.subExpressionComposite.setLayout((Layout)new FillLayout());
        this.subExpressionComposite.setVisible(false);
        Composite resultComposite = toolkit.createComposite((Composite)this.bottomLeftColumn);
        resultComposite.setLayout((Layout)new FillLayout());
        this.createSubExpressionsSection(toolkit, this.subExpressionComposite);
        this.createResultSection(toolkit, resultComposite);
        this.bottomLeftColumn.setWeights(new int[]{1, 1});
        leftColumn.setWeights(new int[]{2, 3});
        this.variableColumn = toolkit.createComposite((Composite)this.formBody);
        this.variableColumn.setLayout((Layout)new FillLayout());
        this.variableColumn.setVisible(false);
        this.createVariableSection(toolkit, this.variableColumn);
        this.formBody.setWeights(new int[]{3, 1});
        this.createToolBar(this.getForm());
    }

    public void refreshExpressionSection() {
        if (!this.expressionSection.isDisposed()) {
            this.expressionSection.layout();
        }
    }

    protected IMenuListener createResultMenuListener(Viewer viewer) {
        return new ResultMenuListener(viewer);
    }

    protected void createResultSection(FormToolkit toolkit, Composite leftColumn) {
        this.resultSection = toolkit.createSection(leftColumn, 256);
        this.resultSection.setText(InterpreterMessages.getString("interpreter.view.result.section.name"));
        Composite resultSectionBody = toolkit.createComposite((Composite)this.resultSection);
        resultSectionBody.setLayout((Layout)new GridLayout());
        this.resultViewer = this.createResultViewer(resultSectionBody);
        GridData gridData = new GridData(1808);
        this.resultViewer.getControl().setLayoutData((Object)gridData);
        InterpreterView.createSectionToolBar(this.resultSection);
        this.populateResultSectionToolbar(this.resultSection);
        toolkit.paintBordersFor(resultSectionBody);
        this.resultSection.setClient((Control)resultSectionBody);
        this.getSite().setSelectionProvider((ISelectionProvider)this.resultViewer);
    }

    protected Viewer createResultViewer(Composite parent) {
        Viewer viewer = this.getCurrentLanguageInterpreter().createResultViewer(parent);
        if (viewer == null) {
            viewer = new TreeViewer(parent, 2818);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)((TreeViewer)viewer));
            AdapterFactory adapterFactory = this.createAdapterFactory();
            TreeViewer treeViewer = (TreeViewer)viewer;
            treeViewer.setContentProvider((IContentProvider)new ResultContentProvider(adapterFactory));
            treeViewer.setLabelProvider((IBaseLabelProvider)new ResultLabelProvider(adapterFactory));
        }
        if (viewer instanceof TreeViewer) {
            this.setUpResultDragSupport((TreeViewer)viewer);
            ((TreeViewer)viewer).addDoubleClickListener((IDoubleClickListener)new ResultDoubleClickListener());
        }
        this.createResultMenu(viewer);
        return viewer;
    }

    protected void createToolBar(Form form) {
        Boolean isSubExpressionsVisible;
        Boolean isVariableVisible;
        ToggleRealTimeAction realTimeAction = new ToggleRealTimeAction(this);
        if (this.partMemento != null) {
            Boolean isRealTime = this.partMemento.getBoolean(MEMENTO_REAL_TIME_KEY);
            if (isRealTime != null && isRealTime.booleanValue()) {
                this.toggleRealTime();
                realTimeAction.setChecked(this.realTime);
            }
        } else {
            this.toggleRealTime();
            realTimeAction.setChecked(this.realTime);
        }
        this.linkWithEditorContextAction = new LinkWithEditorContextAction(this);
        IWorkbenchPage currentPage = this.getSite().getPage();
        if (currentPage != null) {
            this.editorPartListener = new InterpreterEditorPartListener(this.linkWithEditorContextAction, this);
            this.getSite().getPage().addPartListener(this.editorPartListener);
            IEditorPart currentEditor = currentPage.getActiveEditor();
            if (currentEditor == null) {
                this.linkWithEditorContextAction.setEnabled(false);
            } else {
                this.linkWithEditorContextAction.setEnabled(this.getCurrentLanguageInterpreter().canLinkWithEditor(currentEditor));
            }
        } else {
            this.linkWithEditorContextAction.setEnabled(false);
        }
        ToggleVariableVisibilityAction variableVisibilityAction = new ToggleVariableVisibilityAction(this);
        if (this.partMemento != null && (isVariableVisible = this.partMemento.getBoolean(MEMENTO_VARIABLES_VISIBLE_KEY)) != null && isVariableVisible.booleanValue()) {
            this.toggleVariableVisibility();
            variableVisibilityAction.setChecked(this.variableVisible);
        }
        ToggleStepByStepVisibilityAction subExpressionsVisibilityAction = new ToggleStepByStepVisibilityAction(this);
        if (this.partMemento != null && (isSubExpressionsVisible = this.partMemento.getBoolean(MEMENTO_SUB_EXPRESSIONS_VISIBLE_KEY)) != null && isSubExpressionsVisible.booleanValue()) {
            this.toggleStepByStepVisibility();
            subExpressionsVisibilityAction.setChecked(this.subExpressionsVisible);
        }
        IToolBarManager toolBarManager = form.getToolBarManager();
        toolBarManager.add((IAction)this.linkWithEditorContextAction);
        toolBarManager.add((IAction)realTimeAction);
        toolBarManager.add((IAction)variableVisibilityAction);
        toolBarManager.add((IAction)subExpressionsVisibilityAction);
        toolBarManager.add((IContributionItem)new Separator(LANGUAGE_SPECIFIC_ACTION_GROUP));
        this.getCurrentLanguageInterpreter().addToolBarActions(this, toolBarManager);
        toolBarManager.update(true);
    }

    protected IMenuListener createVariableMenuListener(TreeViewer viewer) {
        return new VariableMenuListener(viewer);
    }

    protected void createVariableSection(FormToolkit toolkit, Composite rightColumn) {
        Section variableSection = toolkit.createSection(rightColumn, 256);
        variableSection.setText(InterpreterMessages.getString("interpreter.view.variable.section.name"));
        Composite variableSectionBody = toolkit.createComposite((Composite)variableSection);
        variableSectionBody.setLayout((Layout)new FillLayout());
        this.variableViewer = this.createVariableViewer(toolkit, variableSectionBody);
        ToolBarManager toolBarManager = InterpreterView.createSectionToolBar(variableSection);
        toolBarManager.add((IAction)new ClearVariableViewerAction((Viewer)this.variableViewer));
        toolBarManager.update(true);
        toolkit.paintBordersFor(variableSectionBody);
        variableSection.setClient((Control)variableSectionBody);
    }

    protected TreeViewer createVariableViewer(FormToolkit toolkit, Composite sectionBody) {
        Tree variableTree = toolkit.createTree(sectionBody, 770);
        TreeViewer viewer = new TreeViewer(variableTree);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        AdapterFactory adapterFactory = this.createAdapterFactory();
        viewer.setContentProvider((IContentProvider)new VariableContentProvider(adapterFactory));
        viewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider(adapterFactory));
        this.setUpVariableDropSupport(viewer);
        this.createVariableMenu(viewer);
        this.setUpVariableActions(viewer);
        viewer.setInput(new ArrayList());
        return viewer;
    }

    protected void createSubExpressionsSection(FormToolkit toolkit, Composite parentComposite) {
        Section subExpressionsSection = toolkit.createSection(parentComposite, 256);
        subExpressionsSection.setText(InterpreterMessages.getString("interpreter.view.subexpression.section.name"));
        Composite subExpressionsSectionBody = toolkit.createComposite((Composite)subExpressionsSection);
        subExpressionsSectionBody.setLayout((Layout)new GridLayout());
        this.subExpressionViewer = this.createSubExpressionsViewer(toolkit, subExpressionsSectionBody);
        GridData gridData = new GridData(1808);
        this.subExpressionViewer.getControl().setLayoutData((Object)gridData);
        InterpreterView.createSectionToolBar(subExpressionsSection);
        this.populateSubExpressionSectionToolbar(subExpressionsSection);
        toolkit.paintBordersFor(subExpressionsSectionBody);
        subExpressionsSection.setClient((Control)subExpressionsSectionBody);
    }

    protected TreeViewer createSubExpressionsViewer(FormToolkit toolkit, Composite sectionBody) {
        Tree subExpressionsTree = toolkit.createTree(sectionBody, 770);
        TreeViewer viewer = new TreeViewer(subExpressionsTree);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        AdapterFactory adapterFactory = this.createAdapterFactory();
        viewer.setContentProvider((IContentProvider)new StepByStepContentProvider(adapterFactory));
        viewer.setLabelProvider((IBaseLabelProvider)new StepLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)new SubExpressionListener(this));
        viewer.addDoubleClickListener((IDoubleClickListener)new SubExpressionDoubleClickListener());
        return viewer;
    }

    public Form getForm() {
        return this.interpreterForm;
    }

    protected IFormMessageManager getMessageManager() {
        return this.messageManager;
    }

    protected SourceViewer getSourceViewer() {
        return this.expressionViewer;
    }

    protected void populateExpressionSectionToolbar(Section section) {
        ToolBarManager toolBarManager = InterpreterView.getSectionToolBar(section);
        if (toolBarManager != null) {
            toolBarManager.removeAll();
            toolBarManager.add((IAction)new EvaluateAction(this));
            toolBarManager.add((IAction)new ClearExpressionViewerAction((Viewer)this.getSourceViewer()));
            toolBarManager.update(true);
        }
    }

    protected void populateResultSectionToolbar(Section section) {
        ToolBarManager toolBarManager = InterpreterView.getSectionToolBar(section);
        if (toolBarManager == null) {
            return;
        }
        toolBarManager.removeAll();
        if (this.resultViewer instanceof StructuredViewer) {
            LexicalSortAction sortAction = new LexicalSortAction((StructuredViewer)this.resultViewer);
            toolBarManager.add((IAction)sortAction);
            if (this.partMemento != null && this.partMemento.getBoolean(MEMENTO_RESULT_SORTED_KEY) != null) {
                boolean sortEnabled = this.partMemento.getBoolean(MEMENTO_RESULT_SORTED_KEY);
                sortAction.setChecked(sortEnabled);
                if (sortEnabled) {
                    sortAction.run();
                }
            }
        }
        toolBarManager.add((IAction)new ClearResultViewerAction(this.resultViewer));
        toolBarManager.update(true);
    }

    protected void populateSubExpressionSectionToolbar(Section section) {
        ToolBarManager toolBarManager = InterpreterView.getSectionToolBar(section);
        if (toolBarManager != null) {
            toolBarManager.removeAll();
            LexicalSortAction sortAction = new LexicalSortAction((StructuredViewer)this.subExpressionViewer);
            toolBarManager.add((IAction)sortAction);
            if (this.partMemento != null && this.partMemento.getBoolean(MEMENTO_SUB_EXPRESSIONS_SORTED_KEY) != null) {
                boolean sortEnabled = this.partMemento.getBoolean(MEMENTO_SUB_EXPRESSIONS_SORTED_KEY);
                sortAction.setChecked(sortEnabled);
                if (sortEnabled) {
                    sortAction.run();
                }
            }
            toolBarManager.add((IAction)new ClearResultViewerAction((Viewer)this.subExpressionViewer));
            toolBarManager.update(true);
        }
    }

    public final void setCompilationResult(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public final void setEvaluationResult(EvaluationResult result) {
        ArrayList<Object> input = new ArrayList<Object>();
        Object evaluationResult = result.getEvaluationResult();
        if (evaluationResult instanceof Collection) {
            for (Object child : (Collection)evaluationResult) {
                if (child != null) {
                    input.add(child);
                    continue;
                }
                input.add(NULL_RESULT_OBJECT);
            }
        } else if (evaluationResult != null) {
            input.add(evaluationResult);
        }
        if (!this.resultViewer.getControl().isDisposed()) {
            this.resultViewer.setInput(input);
        }
    }

    protected final void setUpContentAssist(final IInterpreterSourceViewer viewer) {
        IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (this.activationTokenContentAssist != null) {
            service.deactivateHandler(this.activationTokenContentAssist);
        }
        Action contentAssistAction = new Action(){

            public void run() {
                viewer.showContentAssist(InterpreterView.this.getInterpreterContext());
            }
        };
        ActionHandler contentAssistHandler = new ActionHandler((IAction)contentAssistAction);
        this.activationTokenContentAssist = service.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)contentAssistHandler);
    }

    protected void setUpRealTimeCompilation(final SourceViewer viewer) {
        viewer.addTextListener(new ITextListener(){
            private String lastText;

            public void textChanged(TextEvent event) {
                if (InterpreterView.this.realTimeThread != null) {
                    boolean ignore = false;
                    String currentText = viewer.getDocument().get();
                    if (this.lastText != null) {
                        ignore = this.lastText.equals(currentText);
                    }
                    if (!ignore) {
                        this.lastText = currentText;
                        InterpreterView.this.realTimeThread.reset();
                        InterpreterView.this.realTimeThread.setDirty();
                    }
                }
            }
        });
    }

    protected void setUpResultDragSupport(TreeViewer viewer) {
        int operations = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        viewer.addDragSupport(operations, transfers, (DragSourceListener)new ResultDragListener(viewer));
    }

    protected void setUpVariableActions(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        final RenameVariableAction renameAction = new RenameVariableAction(viewer);
        final DeleteVariableOrValueAction deleteAction = new DeleteVariableOrValueAction(viewer);
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 && event.stateMask == 0) {
                    if (deleteAction.isEnabled()) {
                        deleteAction.run();
                    }
                } else if (event.keyCode == 0x100000B && event.stateMask == 0 && renameAction.isEnabled()) {
                    renameAction.run();
                }
            }
        });
    }

    protected void setUpVariableDropSupport(TreeViewer viewer) {
        int operations = 23;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
        viewer.addDropSupport(operations, transfers, (DropTargetListener)new VariableDropListener(viewer));
    }

    private int convertStatusToMessageSeverity(int statusSeverity) {
        int severity = 0;
        switch (statusSeverity) {
            case 1: {
                severity = 1;
                break;
            }
            case 2: {
                severity = 2;
                break;
            }
            case 4: {
                severity = 3;
                break;
            }
            default: {
                severity = 0;
            }
        }
        return severity;
    }

    private void createExpressionMenu(SourceViewer viewer) {
        MenuManager manager;
        Menu menu = viewer.getTextWidget().getMenu();
        boolean createMenu = true;
        if (menu != null && (manager = (MenuManager)menu.getData("org.eclipse.jface.action.MenuManager.managerKey")) != null) {
            manager.addMenuListener(this.createExpressionMenuListener(viewer));
            createMenu = false;
        }
        if (createMenu) {
            MenuManager menuManager = new MenuManager(MENU_ID);
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(this.createExpressionMenuListener(viewer));
            menu = menuManager.createContextMenu((Control)viewer.getTextWidget());
            viewer.getTextWidget().setMenu(menu);
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)viewer);
        }
    }

    private void createResultMenu(Viewer viewer) {
        MenuManager menuManager = new MenuManager(MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.createResultMenuListener(viewer));
        Menu menu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)viewer);
    }

    private void createVariableMenu(TreeViewer viewer) {
        MenuManager menuManager = new MenuManager(MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.createVariableMenuListener(viewer));
        Menu menu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)viewer);
    }

    private void setUpDefaultTextAction(final SourceViewer viewer) {
        IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (this.activationTokenRedo != null) {
            service.deactivateHandler(this.activationTokenRedo);
        }
        if (this.activationTokenUndo != null) {
            service.deactivateHandler(this.activationTokenUndo);
        }
        Action redoAction = new Action(){

            public void run() {
                viewer.doOperation(2);
            }
        };
        ActionHandler redoHandler = new ActionHandler((IAction)redoAction);
        Action undoAction = new Action(){

            public void run() {
                viewer.doOperation(1);
            }
        };
        ActionHandler undoHandler = new ActionHandler((IAction)undoAction);
        this.activationTokenRedo = service.activateHandler(WORKBENCH_CONSTANT_EDIT_REDO, (IHandler)redoHandler);
        this.activationTokenUndo = service.activateHandler(WORKBENCH_CONSTANT_EDIT_UNDO, (IHandler)undoHandler);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.resultViewer != null) {
            this.resultViewer.addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        if (this.resultViewer != null) {
            return this.resultViewer.getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.resultViewer != null) {
            this.resultViewer.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.resultViewer != null) {
            this.resultViewer.setSelection(selection);
        }
    }

    public RealTimeThread getRealTimeThread() {
        return this.realTimeThread;
    }

    public CompilationThread getCompilationThread() {
        return this.compilationThread;
    }

    public ExecutorService getEvaluationPool() {
        return this.evaluationPool;
    }

    public CompilationResult getCompilationResult() {
        return this.compilationResult;
    }

    public ExecutorService getSplittingPool() {
        return this.splittingPool;
    }
}

