/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.representation;

import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.session.danalysis.DRepresentationLocationRule;
import org.eclipse.sirius.business.internal.representation.DRepresentationLocationRuleRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class DRepresentationLocationManager {
    public Resource getOrCreateRepresentationResource(DRepresentation representation, Resource airdResource) {
        ResourceSet resourceSet;
        Resource resource = null;
        ResourceSet resourceSet2 = resourceSet = airdResource != null ? airdResource.getResourceSet() : null;
        if (resourceSet != null) {
            resource = this.getRepresentationResourceURI(representation, airdResource).map(repResourceURI -> {
                Resource res = resourceSet.getResource(repResourceURI, false);
                if (res == null) {
                    res = resourceSet.getURIConverter().exists(repResourceURI, null) ? resourceSet.getResource(repResourceURI, true) : resourceSet.createResource(repResourceURI);
                }
                return res;
            }).orElse(null);
        }
        return resource;
    }

    public Optional<URI> getRepresentationResourceURI(DRepresentation representation, Resource airdResource) {
        Optional<DRepresentationLocationRule> representationLocationRule = DRepresentationLocationRuleRegistry.getInstance().getRepresentationLocationRule(representation, airdResource);
        return representationLocationRule.map(r -> r.getResourceURI(representation, airdResource));
    }
}

