/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.serialization.generators.xsd;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sphinx.emf.serialization.generators.util.JavaXSDPrimitiveTypeMapping;
import org.eclipse.sphinx.emf.serialization.generators.xsd.Ecore2XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class Ecore2XSDConverter {
    protected Ecore2XSDFactory xsdFactory;
    protected XSDSchema xsdSchema;
    protected ArrayList<EClass> referencedClass = new ArrayList();

    public Ecore2XSDConverter(Ecore2XSDFactory xsdFactory, XSDSchema xsdSchema) {
        this.xsdFactory = xsdFactory;
        this.xsdSchema = xsdSchema;
    }

    public XSDSchema doConvertRMFPackageSchema2(EPackage rootEPackageModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        progress.subTask("create XSD global element");
        this.xsdFactory.createGlobalElement3(rootEPackageModel, this.xsdSchema);
        progress.worked(5);
        SubMonitor classProgress = progress.newChild(70);
        classProgress.subTask("create XSD class type definitions");
        this.doConvertToRMFClassTypeDef5(rootEPackageModel, (IProgressMonitor)classProgress);
        SubMonitor enumProgress = progress.newChild(10);
        enumProgress.subTask("create XSD Enum schema");
        this.doConvertToRMFEnumSchema6(rootEPackageModel, (IProgressMonitor)enumProgress);
        SubMonitor dtProgress = progress.newChild(10);
        dtProgress.subTask("create XSD Data type schema");
        this.doConvertToRMFDataTypeSchema7(rootEPackageModel, (IProgressMonitor)dtProgress);
        SubMonitor rstProgress = progress.newChild(5);
        rstProgress.subTask("create referenced simple types");
        this.doConvertToReferencedSimpleType8(rootEPackageModel, (IProgressMonitor)rstProgress);
        return this.xsdSchema;
    }

    public void doConvertToRMFClassTypeDef5(EPackage rootEPackageModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        final SubMonitor classProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
        Functions.Function1<EClassifier, Boolean> _function = new Functions.Function1<EClassifier, Boolean>(){

            public Boolean apply(EClassifier it) {
                return it instanceof EClass;
            }
        };
        Consumer<EClassifier> _function_1 = new Consumer<EClassifier>(){

            @Override
            public void accept(EClassifier it) {
                Ecore2XSDConverter.this.xsdFactory.createClassTypeDefinition5((EClass)it, Ecore2XSDConverter.this.xsdSchema, Ecore2XSDConverter.this.referencedClass, (IProgressMonitor)classProgress);
            }
        };
        IterableExtensions.filter((Iterable)rootEPackageModel.getEClassifiers(), (Functions.Function1)_function).forEach(_function_1);
        final SubMonitor subProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getESubpackages().size());
        Consumer<EPackage> _function_2 = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage it) {
                Ecore2XSDConverter.this.doConvertToRMFClassTypeDef5(it, (IProgressMonitor)subProgress);
                subProgress.worked(1);
                boolean _isCanceled = subProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        rootEPackageModel.getESubpackages().forEach((Consumer)_function_2);
    }

    public void doConvertToRMFEnumSchema6(EPackage rootEPackageModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        final SubMonitor classProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
        Functions.Function1<EClassifier, Boolean> _function = new Functions.Function1<EClassifier, Boolean>(){

            public Boolean apply(EClassifier it) {
                return it instanceof EEnum;
            }
        };
        Consumer<EClassifier> _function_1 = new Consumer<EClassifier>(){

            @Override
            public void accept(EClassifier it) {
                Ecore2XSDConverter.this.xsdFactory.createEnumSchema6((EEnum)it, Ecore2XSDConverter.this.xsdSchema);
                classProgress.worked(1);
                boolean _isCanceled = classProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        IterableExtensions.filter((Iterable)rootEPackageModel.getEClassifiers(), (Functions.Function1)_function).forEach(_function_1);
        final SubMonitor subProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getESubpackages().size());
        Consumer<EPackage> _function_2 = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage it) {
                Ecore2XSDConverter.this.doConvertToRMFEnumSchema6(it, (IProgressMonitor)subProgress);
                subProgress.worked(1);
                boolean _isCanceled = subProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        rootEPackageModel.getESubpackages().forEach((Consumer)_function_2);
    }

    public void doConvertToRMFDataTypeSchema7(EPackage rootEPackageModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        final SubMonitor classProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
        Functions.Function1<EClassifier, Boolean> _function = new Functions.Function1<EClassifier, Boolean>(){

            public Boolean apply(EClassifier it) {
                return it instanceof EDataType && !(it instanceof EEnum);
            }
        };
        Consumer<EClassifier> _function_1 = new Consumer<EClassifier>(){

            @Override
            public void accept(EClassifier it) {
                Boolean _isGeneralPrimitiveType = Ecore2XSDConverter.this.isGeneralPrimitiveType((EDataType)it);
                if (_isGeneralPrimitiveType.booleanValue()) {
                    boolean _not;
                    Boolean _isXMLPrimitiveXsdType = Ecore2XSDConverter.this.xsdFactory.isXMLPrimitiveXsdType((EDataType)it);
                    boolean bl = _not = _isXMLPrimitiveXsdType == false;
                    if (_not) {
                        Ecore2XSDConverter.this.xsdFactory.createDataTypeSchema7b((EDataType)it, Ecore2XSDConverter.this.xsdSchema);
                    }
                } else {
                    Ecore2XSDConverter.this.xsdFactory.createDataTypeSchema7a((EDataType)it, Ecore2XSDConverter.this.xsdSchema);
                }
                classProgress.worked(1);
                boolean _isCanceled = classProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        IterableExtensions.filter((Iterable)rootEPackageModel.getEClassifiers(), (Functions.Function1)_function).forEach(_function_1);
        final SubMonitor subProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
        Consumer<EPackage> _function_2 = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage it) {
                Ecore2XSDConverter.this.doConvertToRMFDataTypeSchema7(it, (IProgressMonitor)subProgress);
                subProgress.worked(1);
                boolean _isCanceled = subProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        rootEPackageModel.getESubpackages().forEach((Consumer)_function_2);
    }

    public void doConvertToReferencedSimpleType8(EPackage rootEPackageModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        final SubMonitor classProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
        Functions.Function1<EClassifier, Boolean> _function = new Functions.Function1<EClassifier, Boolean>(){

            public Boolean apply(EClassifier it) {
                return it instanceof EClass;
            }
        };
        Consumer<EClassifier> _function_1 = new Consumer<EClassifier>(){

            @Override
            public void accept(EClassifier it) {
                Ecore2XSDConverter.this.xsdFactory.createSimpleType8((EClass)it, Ecore2XSDConverter.this.xsdSchema);
                classProgress.worked(1);
                boolean _isCanceled = classProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        IterableExtensions.filter((Iterable)rootEPackageModel.getEClassifiers(), (Functions.Function1)_function).forEach(_function_1);
        final SubMonitor subProgress = progress.newChild(50).setWorkRemaining(rootEPackageModel.getEClassifiers().size());
        Consumer<EPackage> _function_2 = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage it) {
                Ecore2XSDConverter.this.doConvertToReferencedSimpleType8(it, (IProgressMonitor)subProgress);
                subProgress.worked(1);
                boolean _isCanceled = subProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        rootEPackageModel.getESubpackages().forEach((Consumer)_function_2);
    }

    protected Boolean isGeneralPrimitiveType(EDataType dataType) {
        boolean _notEquals;
        Class instanceClass = dataType.getInstanceClass();
        String _get = JavaXSDPrimitiveTypeMapping.javaXsdPrimitiveTypeMapping.get(instanceClass);
        boolean bl = _notEquals = !Objects.equal((Object)_get, null);
        if (_notEquals) {
            return true;
        }
        return false;
    }
}

