/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.properties;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.Resources;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;
import org.eclipse.swtchart.extensions.properties.AbstractSelectorPage;
import org.eclipse.swtchart.extensions.properties.Messages;

public class AxisTickPage
extends AbstractSelectorPage {
    private IAxis[] axes;
    protected Button showTickButton;
    private Label fontSizeLabel;
    protected Spinner fontSizeSpinner;
    private Label foregroundLabel;
    protected ColorSelector foregroundButton;
    protected boolean[] visibilityStates;
    protected int[] fontSizes;
    protected RGB[] foregroundColors;

    public AxisTickPage(InteractiveChart chart, IAxis.Direction direction, String title) {
        super(chart, title, Messages.getString("AXES"));
        if (direction == IAxis.Direction.X) {
            this.axes = chart.getAxisSet().getXAxes();
        } else if (direction == IAxis.Direction.Y) {
            this.axes = chart.getAxisSet().getYAxes();
        }
        this.visibilityStates = new boolean[this.axes.length];
        this.fontSizes = new int[this.axes.length];
        this.foregroundColors = new RGB[this.axes.length];
    }

    @Override
    protected String[] getListItems() {
        String[] items = new String[this.axes.length];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(this.axes[i].getId());
            ++i;
        }
        return items;
    }

    @Override
    protected void selectInitialValues() {
        int i = 0;
        while (i < this.axes.length) {
            this.visibilityStates[i] = this.axes[i].getTick().isVisible();
            this.fontSizes[i] = this.axes[i].getTick().getFont().getFontData()[0].getHeight();
            this.foregroundColors[i] = this.axes[i].getTick().getForeground().getRGB();
            ++i;
        }
    }

    @Override
    protected void updateControlSelections() {
        this.showTickButton.setSelection(this.visibilityStates[this.selectedIndex]);
        this.setControlsEnable(this.visibilityStates[this.selectedIndex]);
        this.fontSizeSpinner.setSelection(this.fontSizes[this.selectedIndex]);
        this.foregroundButton.setColorValue(this.foregroundColors[this.selectedIndex]);
    }

    @Override
    protected void addRightPanelContents(Composite parent) {
        this.addTickPanel(parent);
    }

    private void addTickPanel(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(2, false));
        this.showTickButton = this.createCheckBoxControl(group, Messages.getString("SHOW_TICK"));
        this.showTickButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible;
                AxisTickPage.this.visibilityStates[AxisTickPage.this.selectedIndex] = visible = AxisTickPage.this.showTickButton.getSelection();
                AxisTickPage.this.setControlsEnable(visible);
            }
        });
        this.fontSizeLabel = this.createLabelControl(group, Messages.getString("FONT_SIZE"));
        this.fontSizeSpinner = this.createSpinnerControl(group, 8, 30);
        this.fontSizeSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AxisTickPage.this.fontSizes[AxisTickPage.this.selectedIndex] = AxisTickPage.this.fontSizeSpinner.getSelection();
            }
        });
        this.foregroundLabel = this.createLabelControl(group, Messages.getString("COLOR"));
        this.foregroundButton = this.createColorButtonControl(group);
        this.foregroundButton.addListener(event -> {
            RGB rGB = this.foregroundButton.getColorValue();
        });
    }

    protected void setControlsEnable(boolean enabled) {
        this.fontSizeLabel.setEnabled(enabled);
        this.fontSizeSpinner.setEnabled(enabled);
        this.foregroundLabel.setEnabled(enabled);
        this.foregroundButton.setEnabled(enabled);
    }

    @Override
    public void apply() {
        int i = 0;
        while (i < this.axes.length) {
            this.axes[i].getTick().setVisible(this.visibilityStates[i]);
            FontData fontData = this.axes[i].getTick().getFont().getFontData()[0];
            fontData.setHeight(this.fontSizes[i]);
            Font font = Resources.getFont((FontData)fontData);
            this.axes[i].getTick().setFont(font);
            Color color = Resources.getColor((RGB)this.foregroundColors[i]);
            this.axes[i].getTick().setForeground(color);
            ++i;
        }
    }

    protected void performDefaults() {
        this.visibilityStates[this.selectedIndex] = true;
        this.fontSizes[this.selectedIndex] = 9;
        this.foregroundColors[this.selectedIndex] = Display.getDefault().getSystemColor(9).getRGB();
        this.updateControlSelections();
        super.performDefaults();
    }
}

