/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.support;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;

public class RangeSupport {
    private static final int HORIZONTAL_SCROLL_LENGTH = 1000000;
    private static final int VERTICAL_SCROLL_LENGTH = 1000000;

    public static void applyHorizontalSlide(BaseChart baseChart, double factor, boolean slidePrevious) {
        IAxis xAxis = baseChart.getAxisSet().getXAxis(0);
        IAxis yAxis = baseChart.getAxisSet().getYAxis(0);
        if (xAxis != null && yAxis != null) {
            double upper;
            double lower;
            double minX = baseChart.getMinX();
            double maxX = baseChart.getMaxX();
            double delta = (xAxis.getRange().upper - xAxis.getRange().lower) * factor;
            if (slidePrevious) {
                lower = xAxis.getRange().lower - delta;
                upper = xAxis.getRange().upper - delta;
                lower = lower < minX ? minX : lower;
            } else {
                lower = xAxis.getRange().lower + delta;
                upper = xAxis.getRange().upper + delta;
                double d = upper = upper > maxX ? maxX : upper;
            }
            if (lower >= minX && upper <= maxX) {
                Range range = new Range(lower, upper);
                if (lower != upper) {
                    RangeSupport.applyHorizontalSlide(baseChart, xAxis, yAxis, range, new Event());
                }
            }
        }
    }

    public static void applyVerticalSlide(BaseChart baseChart, double factor, boolean slidePrevious) {
        IAxis xAxis = baseChart.getAxisSet().getXAxis(0);
        IAxis yAxis = baseChart.getAxisSet().getYAxis(0);
        if (xAxis != null && yAxis != null) {
            double upper;
            double lower;
            double minY = baseChart.getMinX();
            double maxY = baseChart.getMaxX();
            double delta = (yAxis.getRange().upper - yAxis.getRange().lower) * factor;
            if (slidePrevious) {
                lower = yAxis.getRange().lower + delta;
                upper = yAxis.getRange().upper + delta;
                upper = upper > maxY ? maxY : upper;
            } else {
                lower = yAxis.getRange().lower - delta;
                upper = yAxis.getRange().upper - delta;
                double d = lower = lower < minY ? minY : lower;
            }
            if (lower >= minY && upper <= maxY) {
                Range range = new Range(lower, upper);
                if (lower != upper) {
                    RangeSupport.applyVerticalSlide(baseChart, xAxis, yAxis, range, new Event());
                }
            }
        }
    }

    public static Range calculateShiftedRange(BaseChart baseChart, Range range, double selection, int sliderOrientation) {
        int maxX = 1000000;
        int maxY = 1000000;
        double deltaX = baseChart.getMaxX() - baseChart.getMinX();
        double deltaY = baseChart.getMaxY() - baseChart.getMinY();
        if (deltaX > 0.0 && deltaY > 0.0) {
            double coeffX = (double)maxX / deltaX;
            double coeffY = (double)maxY / deltaY;
            double shiftX = -coeffX * baseChart.getMinX();
            double shiftY = coeffY * baseChart.getMaxY();
            if (coeffX != 0.0 && !Double.isNaN(shiftX) && coeffY != 0.0 && !Double.isNaN(shiftY)) {
                double max;
                double min;
                boolean isChartHorizontal = RangeSupport.isOrientationHorizontal(baseChart);
                if (sliderOrientation == 256) {
                    min = isChartHorizontal ? (selection - shiftX) / coeffX : (shiftY - selection) / coeffY;
                    max = isChartHorizontal ? min + (range.upper - range.lower) : min - (range.upper - range.lower);
                } else {
                    max = !isChartHorizontal ? (selection - shiftX) / coeffX : (shiftY - selection) / coeffY;
                    double d = min = !isChartHorizontal ? max + (range.upper - range.lower) : max - (range.upper - range.lower);
                }
                if (!Double.isNaN(min) && !Double.isNaN(max)) {
                    return new Range(min, max);
                }
            }
        }
        return null;
    }

    public static boolean isOrientationHorizontal(BaseChart baseChart) {
        return baseChart.getOrientation() == 256;
    }

    public static boolean applyHorizontalSlide(BaseChart baseChart, IAxis xAxis, IAxis yAxis, Range range, Event event) {
        if (xAxis != null && yAxis != null && range != null) {
            if (RangeSupport.isOrientationHorizontal(baseChart)) {
                if (baseChart.isRangeValid(range)) {
                    xAxis.setRange(range);
                    baseChart.adjustMinMaxRange(xAxis);
                    RangeSupport.adjustSecondaryXAxes(baseChart);
                }
            } else if (baseChart.isRangeValid(range)) {
                yAxis.setRange(range);
                baseChart.adjustMinMaxRange(yAxis);
                RangeSupport.adjustSecondaryYAxes(baseChart);
            }
            baseChart.update();
            return true;
        }
        return false;
    }

    public static boolean applyVerticalSlide(BaseChart baseChart, IAxis xAxis, IAxis yAxis, Range range, Event event) {
        if (range != null) {
            if (RangeSupport.isOrientationHorizontal(baseChart)) {
                if (baseChart.isRangeValid(range)) {
                    yAxis.setRange(range);
                    baseChart.adjustMinMaxRange(yAxis);
                    RangeSupport.adjustSecondaryYAxes(baseChart);
                }
            } else if (baseChart.isRangeValid(range)) {
                xAxis.setRange(range);
                baseChart.adjustMinMaxRange(xAxis);
                RangeSupport.adjustSecondaryXAxes(baseChart);
            }
            baseChart.redraw();
            return true;
        }
        return false;
    }

    private static void adjustSecondaryXAxes(BaseChart baseChart) {
        baseChart.adjustSecondaryXAxes();
    }

    private static void adjustSecondaryYAxes(BaseChart baseChart) {
        baseChart.adjustSecondaryYAxes();
    }
}

