/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks.p2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.internal.p2.updatesite.CategoryPublisherApplication;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAndBundlesPublisherApplication;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.model.PlatformTriple;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.model.WorkspaceData;
import org.eclipse.tea.library.build.p2.UpdateSite;
import org.eclipse.tea.library.build.p2.UpdateSiteCategory;
import org.eclipse.tea.library.build.tasks.jar.TaskRunFeaturePluginJarExport;
import org.eclipse.tea.library.build.util.FileUtils;

public class TaskPublishFeatureUpdateSite {
    private final String siteName;
    private final File distDirectory;
    private final List<String> includedFeatures;
    private File siteZip;

    public TaskPublishFeatureUpdateSite(String featureID) {
        this(featureID, Collections.singletonList(featureID));
    }

    public TaskPublishFeatureUpdateSite(String siteName, List<String> includedFeatures) {
        this(siteName, new File(BuildDirectories.get().getSiteDirectory(), siteName), includedFeatures);
    }

    public TaskPublishFeatureUpdateSite(String featureID, File distDir) {
        this(featureID, distDir, Collections.singletonList(featureID));
    }

    public TaskPublishFeatureUpdateSite(String siteName, File distDir, List<String> includedFeatures) {
        this.siteName = siteName;
        this.distDirectory = distDir;
        this.includedFeatures = includedFeatures;
    }

    public String toString() {
        return "Publish Update Site (" + this.siteName + ")";
    }

    @Execute
    public void run(TaskingLog log, WorkspaceBuild wb, JarManager jarManager, BuildDirectories dirs) throws Exception {
        log.info("generate update site for platform:" + PlatformTriple.getAllTargetsCommandLineStyle());
        File featureDir = new File(BuildDirectories.get().getOutputDirectory(), TaskRunFeaturePluginJarExport.getFeatureJarDirectory());
        File pluginDir = new File(BuildDirectories.get().getOutputDirectory(), TaskRunFeaturePluginJarExport.getPluginJarDirectory());
        FileUtils.mkdirs(this.distDirectory);
        log.info("update site destination directory: " + String.valueOf(this.distDirectory));
        if (!IApplication.EXIT_OK.equals(TaskPublishFeatureUpdateSite.runUpdateSitePublisher(this.distDirectory, featureDir, pluginDir))) {
            throw new RuntimeException("exit status of application not ok!");
        }
        this.createCategory(log, jarManager, wb, this.distDirectory);
        this.createSiteZip(log, jarManager, wb, dirs);
    }

    public File getSiteZip() {
        return this.siteZip;
    }

    public static Object runUpdateSitePublisher(File targetDirectory, File featureDir, File pluginDir) throws Exception {
        ArrayList<Object> cmdArgs = new ArrayList<Object>();
        cmdArgs.add("-metadataRepository");
        cmdArgs.add("file:" + targetDirectory.getAbsolutePath());
        cmdArgs.add("-artifactRepository");
        cmdArgs.add("file:" + targetDirectory.getAbsolutePath());
        cmdArgs.add("-bundles");
        cmdArgs.add(pluginDir.getAbsolutePath());
        cmdArgs.add("-features");
        cmdArgs.add(featureDir.getAbsolutePath());
        cmdArgs.add("-configs");
        cmdArgs.add(PlatformTriple.getAllTargetsCommandLineStyle());
        cmdArgs.add("-compress");
        cmdArgs.add("-publishArtifacts");
        FeaturesAndBundlesPublisherApplication updateSiteGenerator = new FeaturesAndBundlesPublisherApplication();
        return updateSiteGenerator.run(cmdArgs.toArray(new String[cmdArgs.size()]));
    }

    public static Object runCategoryPublisher(File targetDirectory, File categoryFile) throws Exception {
        ArrayList<Object> cmdArgs = new ArrayList<Object>();
        cmdArgs.add("-metadataRepository");
        cmdArgs.add("file:" + targetDirectory.getAbsolutePath());
        cmdArgs.add("-categoryDefinition");
        cmdArgs.add("file:" + String.valueOf(categoryFile));
        cmdArgs.add("-compress");
        CategoryPublisherApplication categoryPublisher = new CategoryPublisherApplication();
        return categoryPublisher.run(cmdArgs.toArray(new String[cmdArgs.size()]));
    }

    private void createCategory(TaskingLog log, JarManager jarManager, WorkspaceBuild wb, File distDirectory) {
        TreeMap<String, String> featureToCategory = new TreeMap<String, String>();
        for (String feature : this.includedFeatures) {
            IProject featureProject = WorkspaceData.getProject(feature);
            if (featureProject == null) {
                throw new IllegalStateException("cannot find " + feature);
            }
            File featureDir = featureProject.getLocation().toFile();
            String categoryName = "Default";
            Properties props = new Properties();
            File propFile = new File(featureDir, "content.properties");
            if (propFile.exists()) {
                try {
                    FileInputStream inStream = new FileInputStream(propFile);
                    props.load(inStream);
                    inStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                categoryName = props.getProperty("category", "Default");
            }
            featureToCategory.put(feature, categoryName);
        }
        File dirName = BuildDirectories.get().getOutputDirectory();
        File categoryFile = new File(dirName, "category.xml");
        try {
            UpdateSiteCategory.generateCategoryXml(categoryFile, featureToCategory, wb, jarManager);
            log.info("read category information from " + categoryFile.getAbsolutePath());
            if (!IApplication.EXIT_OK.equals(TaskPublishFeatureUpdateSite.runCategoryPublisher(distDirectory, categoryFile))) {
                throw new RuntimeException("exit status of category publisher not ok!");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        FileUtils.delete(categoryFile);
    }

    private IStatus createSiteZip(TaskingLog log, JarManager jarManager, WorkspaceBuild wb, BuildDirectories dirs) {
        try {
            File dir = new File(dirs.getSiteDirectory(), this.siteName);
            String buildVersion = jarManager.getBuildVersion();
            this.siteZip = new File(dirs.getSiteDirectory(), this.siteName + "-" + buildVersion + ".zip");
            UpdateSite.createUpdateSiteZip(dir, this.siteZip, jarManager.getZipExecFactory(), log);
        }
        catch (Exception e) {
            return new Status(4, this.getClass().getName(), "failed to zip update site", (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

