/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.transformer;

import java.util.function.Supplier;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class TransformInput<MODEL extends IJavaElement, GENERATOR>
implements IWorkingCopyTransformer.ITransformInput<MODEL, GENERATOR> {
    private final MODEL m_model;
    private final Supplier<GENERATOR> m_defaultGeneratorSupplier;
    private final FinalValue<GENERATOR> m_defaultGenerator;

    public TransformInput(MODEL model, Supplier<GENERATOR> defaultGeneratorSupplier) {
        this.m_model = (IJavaElement)Ensure.notNull(model);
        this.m_defaultGeneratorSupplier = (Supplier)Ensure.notNull(defaultGeneratorSupplier);
        this.m_defaultGenerator = new FinalValue();
    }

    @Override
    public MODEL model() {
        return this.m_model;
    }

    @Override
    public GENERATOR requestDefaultWorkingCopy() {
        return (GENERATOR)this.m_defaultGenerator.computeIfAbsentAndGet(this.m_defaultGeneratorSupplier);
    }
}

