/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.internal;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.typescript.model.api.AbstractNodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.IConstantValue;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.typescript.model.api.JsonPointer;
import org.eclipse.scout.sdk.core.typescript.model.api.internal.ConstantValuePointerElement;
import org.eclipse.scout.sdk.core.typescript.model.spi.ObjectLiteralSpi;
import org.eclipse.scout.sdk.core.util.Ensure;

public class ObjectLiteralImplementor
extends AbstractNodeElement<ObjectLiteralSpi>
implements IObjectLiteral {
    public ObjectLiteralImplementor(ObjectLiteralSpi spi) {
        super(spi);
    }

    @Override
    public String name() {
        return ((ObjectLiteralSpi)this.spi()).name();
    }

    @Override
    public Optional<IConstantValue> find(CharSequence jsonPointer) {
        return this.find(JsonPointer.compile(jsonPointer));
    }

    @Override
    public Optional<IConstantValue> find(JsonPointer pointer) {
        ConstantValuePointerElement adapter = new ConstantValuePointerElement(new P_ConstantValueAdapter(this));
        return Optional.ofNullable(pointer.find(adapter)).map(r -> (ConstantValuePointerElement)r).map(ConstantValuePointerElement::getValue);
    }

    @Override
    public Map<String, IConstantValue> properties() {
        return ((ObjectLiteralSpi)this.spi()).properties();
    }

    @Override
    public Optional<IConstantValue> property(String name) {
        return Optional.ofNullable(this.properties().get(name));
    }

    @Override
    public Optional<IObjectLiteral> propertyAsObjectLiteral(String name) {
        return this.propertyAs(name, IObjectLiteral.class);
    }

    @Override
    public Optional<IES6Class> propertyAsES6Class(String name) {
        return this.propertyAs(name, IES6Class.class);
    }

    @Override
    public Optional<String> propertyAsString(String name) {
        return this.propertyAs(name, String.class);
    }

    @Override
    public <T> Optional<T> propertyAs(String name, Class<T> type) {
        return this.property(name).flatMap(v -> v.convertTo(type));
    }

    @Override
    public Stream<IObjectLiteral> childObjectLiterals() {
        return this.properties().values().stream().flatMap(constantValue -> {
            if (constantValue.type() == IConstantValue.ConstantValueType.ObjectLiteral) {
                return constantValue.asObjectLiteral().stream();
            }
            if (constantValue.type() == IConstantValue.ConstantValueType.Array) {
                return constantValue.asArray().stream().flatMap(Stream::of).filter(cv -> cv.type() == IConstantValue.ConstantValueType.ObjectLiteral).flatMap(cv -> cv.asObjectLiteral().stream());
            }
            return Stream.empty();
        });
    }

    private static final class P_ConstantValueAdapter
    implements IConstantValue {
        private final IObjectLiteral m_literal;

        public P_ConstantValueAdapter(IObjectLiteral literal) {
            this.m_literal = (IObjectLiteral)Ensure.notNull((Object)literal);
        }

        @Override
        public <T> Optional<T> convertTo(Class<T> expectedType) {
            if (expectedType == IObjectLiteral.class) {
                return this.asObjectLiteral();
            }
            return Optional.empty();
        }

        @Override
        public Optional<Path> containingFile() {
            return this.m_literal.containingFile();
        }

        @Override
        public Optional<IObjectLiteral> asObjectLiteral() {
            return Optional.of(this.m_literal);
        }

        @Override
        public IConstantValue.ConstantValueType type() {
            return IConstantValue.ConstantValueType.ObjectLiteral;
        }

        @Override
        public Optional<IDataType> dataType() {
            return Optional.empty();
        }
    }
}

