/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.pyocd.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.core.SystemJob;
import org.eclipse.embedcdt.debug.gdbjtag.pyocd.core.Configuration;
import org.eclipse.embedcdt.internal.debug.gdbjtag.pyocd.core.Activator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PyOCD {
    public static final long FORMAT_MAJOR_VERSION = 1L;
    public static final String VERSION_KEY = "version";
    public static final String VERSION_MAJOR_KEY = "major";
    public static final String VERSION_MINOR_KEY = "minor";
    public static final String STATUS_KEY = "status";
    public static final String ERROR_KEY = "error";
    public static final String PROBES_KEY = "boards";
    public static final String TARGETS_KEY = "targets";
    public static final String PROBE_INFO_KEY = "info";
    public static final String PROBE_BOARD_NAME_KEY = "board_name";
    public static final String PROBE_VENDOR_NAME_KEY = "vendor_name";
    public static final String PROBE_PRODUCT_NAME_KEY = "product_name";
    public static final String PROBE_TARGET_KEY = "target";
    public static final String PROBE_UNIQUE_ID_KEY = "unique_id";
    public static final String TARGET_NAME_KEY = "name";
    public static final String TARGET_VENDOR_KEY = "vendor";
    public static final String TARGET_FAMILIES_KEY = "part_families";
    public static final String TARGET_PART_NUMBER_KEY = "part_number";
    public static final String TARGET_SVD_PATH_KEY = "svd_path";
    public static final long PYOCD_TIMEOUT_MS = 60000L;
    private static PyOCD fInstance = new PyOCD();
    private DefaultDsfExecutor fExecutor = new DefaultDsfExecutor();

    public static PyOCD getInstance() {
        return fInstance;
    }

    public void getProbes(ILaunchConfiguration configuration, DataRequestMonitor<List<Probe>> rm) {
        String pyOCDPath = Configuration.getGdbServerCommand(configuration, null);
        if (pyOCDPath == null) {
            rm.setStatus((IStatus)new Status(4, PyOCD.class, 10004, "no pyocd path", null));
            rm.done();
        } else {
            this.getProbes(pyOCDPath, rm);
        }
    }

    public void getTargets(ILaunchConfiguration configuration, DataRequestMonitor<List<Target>> rm) {
        String pyOCDPath = Configuration.getGdbServerCommand(configuration, null);
        if (pyOCDPath == null) {
            rm.setStatus((IStatus)new Status(4, PyOCD.class, 10004, "no pyocd path", null));
            rm.done();
        } else {
            this.getTargets(pyOCDPath, rm);
        }
    }

    private boolean checkOutput(JSONObject output) {
        if (output == null) {
            return false;
        }
        if (!output.containsKey((Object)VERSION_KEY)) {
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("No data format version from pyOCD\n", new Object[0]);
            }
            return false;
        }
        JSONObject version = (JSONObject)output.get((Object)VERSION_KEY);
        if (!version.containsKey((Object)VERSION_MAJOR_KEY)) {
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("No data format major version from pyOCD\n", new Object[0]);
            }
            return false;
        }
        if (!version.get((Object)VERSION_MAJOR_KEY).equals(1L)) {
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("Unsupported version %d of data from pyOCD\n", version.get((Object)VERSION_MAJOR_KEY));
            }
            return false;
        }
        if (!output.containsKey((Object)STATUS_KEY) || !output.get((Object)STATUS_KEY).equals(0L)) {
            if (Activator.getInstance().isDebugging()) {
                String msg = "unknown error";
                if (output.containsKey((Object)ERROR_KEY)) {
                    msg = (String)output.get((Object)ERROR_KEY);
                }
                System.out.printf("Error %d reading from pyOCD: %s\n", output.get((Object)STATUS_KEY), msg);
            }
            return false;
        }
        return true;
    }

    public void getProbes(String pyOCDPath, final DataRequestMonitor<List<Probe>> rm) {
        this.getJsonOutput(pyOCDPath, "--probes", new DataRequestMonitor<JSONObject>((Executor)this.fExecutor, rm){

            protected void handleSuccess() {
                JSONObject output = (JSONObject)this.getData();
                if (!PyOCD.this.checkOutput(output) || !output.containsKey((Object)PyOCD.PROBES_KEY)) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.pyocd.core", 4, "invalid output", null));
                    rm.done();
                    return;
                }
                Object probesObj = output.get((Object)PyOCD.PROBES_KEY);
                if (!(probesObj instanceof JSONArray)) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.pyocd.core", 4, "invalid probes key type", null));
                    rm.done();
                    return;
                }
                JSONArray probes = (JSONArray)probesObj;
                ArrayList<Probe> result = new ArrayList<Probe>();
                for (Object b : probes) {
                    try {
                        JSONObject bobj = (JSONObject)b;
                        Probe probeInfo = new Probe((String)bobj.get((Object)PyOCD.PROBE_BOARD_NAME_KEY), (String)bobj.get((Object)PyOCD.PROBE_VENDOR_NAME_KEY), (String)bobj.get((Object)PyOCD.PROBE_PRODUCT_NAME_KEY), (String)bobj.get((Object)PyOCD.PROBE_TARGET_KEY), (String)bobj.get((Object)PyOCD.PROBE_UNIQUE_ID_KEY));
                        result.add(probeInfo);
                    }
                    catch (Exception e) {
                        if (!Activator.getInstance().isDebugging()) continue;
                        System.out.printf("Exception extracting probe info: %s\n", e);
                    }
                }
                rm.done(result);
            }
        });
    }

    public void getTargets(String pyOCDPath, final DataRequestMonitor<List<Target>> rm) {
        this.getJsonOutput(pyOCDPath, "--targets", new DataRequestMonitor<JSONObject>((Executor)this.fExecutor, rm){

            protected void handleSuccess() {
                JSONObject output = (JSONObject)this.getData();
                if (!PyOCD.this.checkOutput(output) || !output.containsKey((Object)PyOCD.TARGETS_KEY)) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.pyocd.core", 4, "invalid output", null));
                    rm.done();
                    return;
                }
                Object targetsObj = output.get((Object)PyOCD.TARGETS_KEY);
                if (!(targetsObj instanceof JSONArray)) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.pyocd.core", 4, "invalid targets key type", null));
                    rm.done();
                    return;
                }
                JSONArray targets = (JSONArray)targetsObj;
                ArrayList<Target> result = new ArrayList<Target>();
                for (Object t : targets) {
                    try {
                        String[] families;
                        JSONObject tobj = (JSONObject)t;
                        if (tobj.containsKey((Object)PyOCD.TARGET_FAMILIES_KEY)) {
                            JSONArray familiesJsonArray = (JSONArray)tobj.get((Object)PyOCD.TARGET_FAMILIES_KEY);
                            ArrayList<String> familiesArrayList = new ArrayList<String>();
                            for (Object f : familiesJsonArray) {
                                familiesArrayList.add((String)f);
                            }
                            families = familiesArrayList.toArray(new String[familiesJsonArray.size()]);
                        } else {
                            families = new String[]{};
                        }
                        Target targetInfo = new Target((String)tobj.get((Object)PyOCD.TARGET_NAME_KEY), (String)tobj.get((Object)PyOCD.TARGET_VENDOR_KEY), (String)tobj.get((Object)PyOCD.TARGET_PART_NUMBER_KEY), families);
                        result.add(targetInfo);
                    }
                    catch (Exception e) {
                        if (!Activator.getInstance().isDebugging()) continue;
                        System.out.printf("Exception extracting target info: %s\n", e);
                    }
                }
                rm.done(result);
            }
        });
    }

    private void getJsonOutput(final String pyOCDPath, final String listArg, final DataRequestMonitor<JSONObject> rm) {
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                try {
                    String[] cmdArray = new String[]{pyOCDPath, "json", listArg};
                    String result = PyOCD.this.getOutput(cmdArray);
                    JSONParser parser = new JSONParser();
                    JSONObject obj = (JSONObject)parser.parse(result);
                    rm.done((Object)obj);
                }
                catch (ParseException e) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.printf("Parse exception: %s\n", new Object[]{e});
                    }
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.pyocd.core", 1, "error parsing pyocd JSON output", (Throwable)e));
                    rm.done();
                }
                catch (CoreException e) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.printf("Core exception: %s\n", new Object[]{e});
                    }
                    rm.setStatus(e.getStatus());
                    rm.done();
                }
            }
        });
    }

    public Version getVersion(String pyOCDPath) {
        try {
            String[] args = new String[]{pyOCDPath, "--version"};
            String output = this.getOutput(args).trim();
            return Version.fromString(output);
        }
        catch (CoreException e) {
            if (Activator.getInstance().isDebugging()) {
                System.out.printf("Core exception while reading pyocd version: %s\n", new Object[]{e});
            }
            return null;
        }
    }

    public String getOutput(String[] args) throws CoreException {
        Process process;
        try {
            process = ProcessFactory.getFactory().exec(args);
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.pyocd.core", 2, "Error while launching pyOCD: " + StringUtils.join((String[])args, (String)" "), e.getCause()));
        }
        final class PyOCDTimeoutJob
        extends SystemJob {
            private boolean f_didTimeout;
            private final /* synthetic */ Process val$process;

            public PyOCDTimeoutJob(Process process) {
                this.val$process = process;
                super("pyOCD output timeout job");
                this.f_didTimeout = false;
            }

            public boolean didTimeout() {
                return this.f_didTimeout;
            }

            protected IStatus run(IProgressMonitor arg) {
                this.val$process.destroy();
                this.f_didTimeout = true;
                return Status.OK_STATUS;
            }
        }
        PyOCDTimeoutJob timeoutJob = new PyOCDTimeoutJob(process);
        timeoutJob.schedule(60000L);
        String cmdOutput = null;
        try {
            try {
                cmdOutput = this.readStream(process.getInputStream());
            }
            catch (IOException e) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.pyocd.core", 2, "Error reading pyOCD stdout: " + StringUtils.join((String[])args, (String)" "), e.getCause()));
            }
        }
        catch (Throwable throwable) {
            if (timeoutJob.didTimeout()) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.pyocd.core", 3, "pyOCD timed out: " + StringUtils.join((String[])args, (String)" "), null));
            }
            timeoutJob.cancel();
            process.destroy();
            if (process.exitValue() != 0) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.pyocd.core", 2, String.format("pyOCD returned exit value (%d): %s", process.exitValue(), StringUtils.join((String[])args, (String)" ")), null));
            }
            throw throwable;
        }
        if (timeoutJob.didTimeout()) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.pyocd.core", 3, "pyOCD timed out: " + StringUtils.join((String[])args, (String)" "), null));
        }
        timeoutJob.cancel();
        process.destroy();
        if (process.exitValue() != 0) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.pyocd.core", 2, String.format("pyOCD returned exit value (%d): %s", process.exitValue(), StringUtils.join((String[])args, (String)" ")), null));
        }
        return cmdOutput;
    }

    public String readStream(InputStream stream) throws IOException {
        StringBuilder cmdOutput = new StringBuilder(200);
        try {
            String line;
            InputStreamReader r = new InputStreamReader(stream);
            BufferedReader reader = new BufferedReader(r);
            while ((line = reader.readLine()) != null) {
                cmdOutput.append(line);
                cmdOutput.append('\n');
            }
            String string = cmdOutput.toString();
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static final class Errors {
        public static final int ERROR_PARSING_OUTPUT = 1;
        public static final int ERROR_RUNNING_PYOCD = 2;
        public static final int ERROR_TIMEOUT = 3;
        public static final int ERROR_INVALID_JSON_FORMAT = 4;
    }

    public static class Probe {
        public final String fBoardName;
        public final String fVendorName;
        public final String fProductName;
        public final String fTargetName;
        public final String fUniqueId;
        public static final String GENERIC_BOARD_NAME = "generic";
        public static final String UNKNOWN_BOARD_NAME = "Unknown Board";
        public static final Comparator DESCRIPTION_COMPARATOR = new Comparator();

        Probe(String board, String vendor, String product, String target, String uid) {
            this.fBoardName = board;
            this.fVendorName = vendor;
            this.fProductName = product;
            this.fTargetName = target;
            this.fUniqueId = uid;
        }

        public String getName() {
            if (this.fProductName.startsWith(this.fVendorName)) {
                return this.fProductName;
            }
            return String.valueOf(this.fVendorName) + " " + this.fProductName;
        }

        public String getDescription() {
            if (this.fBoardName.equalsIgnoreCase(GENERIC_BOARD_NAME) || this.fBoardName.equalsIgnoreCase(UNKNOWN_BOARD_NAME)) {
                return String.format("%s (%s)", this.getName(), this.fUniqueId);
            }
            return String.format("%s \u2013 %s (%s)", this.fBoardName, this.getName(), this.fUniqueId);
        }

        public String toString() {
            return String.format("<Probe: %s [%s] %s>", this.getDescription(), this.fTargetName, this.fUniqueId);
        }

        private static class Comparator
        implements java.util.Comparator<Probe> {
            private Comparator() {
            }

            @Override
            public int compare(Probe o1, Probe o2) {
                return o1.getDescription().compareTo(o2.getDescription());
            }
        }
    }

    public static class Target {
        public final String fName;
        public final String fVendor;
        public final String fPartNumber;
        public final String[] fFamilies;
        public static final NameComparator NAME_COMPARATOR = new NameComparator();
        public static final PartNumberComparator PART_NUMBER_COMPARATOR = new PartNumberComparator();

        Target(String name, String vendor, String part, String[] families) {
            this.fName = name;
            this.fVendor = vendor;
            this.fPartNumber = part;
            this.fFamilies = families;
        }

        public String getFullPartName() {
            if (this.fVendor != null) {
                return String.valueOf(this.fVendor) + " " + this.fPartNumber;
            }
            return this.fPartNumber;
        }

        public String toString() {
            return String.format("<Target: %s %s [%s]>", this.fVendor, this.fPartNumber, this.fName);
        }

        public static class NameComparator
        implements Comparator<Target> {
            @Override
            public int compare(Target o1, Target o2) {
                return o1.fName.compareTo(o2.fName);
            }
        }

        public static class PartNumberComparator
        implements Comparator<Target> {
            @Override
            public int compare(Target o1, Target o2) {
                return o1.getFullPartName().compareTo(o2.getFullPartName());
            }
        }
    }

    public static class Version {
        public final int fMajor;
        public final int fMinor;
        public final int fMicro;

        Version(int major, int minor, int micro) {
            this.fMajor = major;
            this.fMinor = minor;
            this.fMicro = micro;
        }

        public static Version fromString(String versionString) {
            int micro;
            int minor;
            int major;
            block11: {
                CharSequence[] pieces;
                block10: {
                    block9: {
                        if (versionString.isEmpty()) {
                            return null;
                        }
                        if (versionString.startsWith("v")) {
                            versionString = versionString.substring(1);
                        }
                        if ((pieces = versionString.split("\\.", 4)).length == 0) {
                            return null;
                        }
                        major = 0;
                        minor = 0;
                        micro = 0;
                        try {
                            major = Integer.parseUnsignedInt(pieces[0]);
                        }
                        catch (NumberFormatException e) {
                            if (!Activator.getInstance().isDebugging()) break block9;
                            System.out.printf("failed to parse pyocd major version:" + String.join((CharSequence)".", pieces) + "\n", new Object[0]);
                        }
                    }
                    try {
                        minor = Integer.parseUnsignedInt(pieces[1]);
                    }
                    catch (NumberFormatException e) {
                        if (!Activator.getInstance().isDebugging()) break block10;
                        System.out.printf("failed to parse pyocd minor version:" + String.join((CharSequence)".", pieces) + "\n", new Object[0]);
                    }
                }
                try {
                    micro = Integer.parseUnsignedInt((String)pieces[2]);
                }
                catch (NumberFormatException e) {
                    if (!Activator.getInstance().isDebugging()) break block11;
                    System.out.printf("failed to parse pyocd micro version:" + String.join((CharSequence)".", pieces) + "\n", new Object[0]);
                }
            }
            return new Version(major, minor, micro);
        }

        public String toString() {
            return String.format("<Version: %d.%d.%d>", this.fMajor, this.fMinor, this.fMicro);
        }
    }
}

