/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.spi.cdo.CDOMergingConflictResolver;
import org.eclipse.net4j.util.ui.actions.SafeAction;

public class MergeConflictsAction
extends SafeAction {
    private static final String TITLE = Messages.getString("MergeConflictsAction.0");
    private static final String TOOL_TIP = Messages.getString("MergeConflictsAction.1");
    private final CDOTransaction transaction;

    public MergeConflictsAction(CDOTransaction transaction) {
        super(TITLE, 2);
        this.setToolTipText(TOOL_TIP);
        this.transaction = transaction;
        CDOConflictResolver[] cDOConflictResolverArray = transaction.options().getConflictResolvers();
        int n = cDOConflictResolverArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOConflictResolver conflictResolver = cDOConflictResolverArray[n2];
            this.setEnabled(false);
            if (conflictResolver instanceof CDOMergingConflictResolver) {
                this.setEnabled(true);
                this.setChecked(true);
                return;
            }
            ++n2;
        }
    }

    protected void safeRun() throws Exception {
        CDOMergingConflictResolver conflictResolver;
        CDOConflictResolver[] cDOConflictResolverArray = this.transaction.options().getConflictResolvers();
        int n = cDOConflictResolverArray.length;
        int n2 = 0;
        while (n2 < n) {
            conflictResolver = cDOConflictResolverArray[n2];
            if (conflictResolver instanceof CDOMergingConflictResolver) {
                this.transaction.options().removeConflictResolver((CDOConflictResolver)conflictResolver);
                return;
            }
            ++n2;
        }
        conflictResolver = new CDOMergingConflictResolver();
        this.transaction.options().addConflictResolver((CDOConflictResolver)conflictResolver);
    }
}

