/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.agreements;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.agreements.AgreementAcceptanceService;
import org.eclipse.passage.lic.api.agreements.AgreementState;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.io.Hashes;
import org.eclipse.passage.lic.api.io.HashesRegistry;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.base.agreements.Assessment;
import org.eclipse.passage.lic.base.diagnostic.code.NoServicesOfType;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.base.io.UserHomeProductResidence;

public final class BaseAgreementAcceptanceService
implements AgreementAcceptanceService {
    private final HashesRegistry hashes;
    private final LicensedProduct product;

    public BaseAgreementAcceptanceService(HashesRegistry hashes, Supplier<LicensedProduct> product) {
        this.hashes = hashes;
        this.product = product.get();
    }

    public void accept(Supplier<byte[]> agreement) throws Exception {
        byte[] content = agreement.get();
        Optional<Hashes> hashes = this.hashingService();
        if (!hashes.isPresent()) {
            throw new LicensingException(new NoServicesOfType("hash calculator").toString());
        }
        this.write(this.acceptedContentFile(content, hashes.get()), content);
    }

    public AgreementState accepted(byte[] content, String name) {
        Path accepted;
        Optional<Hashes> hashes = this.hashingService();
        if (!hashes.isPresent()) {
            return new Assessment(name, this.noHashingService());
        }
        try {
            accepted = this.acceptedContentFile(content, hashes.get());
        }
        catch (Exception e) {
            return new Assessment(name, this.faliledToLocateContent(e, name));
        }
        return new Assessment(name, content, Files.exists(accepted, new LinkOption[0]) && Files.isRegularFile(accepted, new LinkOption[0]));
    }

    private Path acceptedContentFile(byte[] content, Hashes hashes) throws Exception {
        String bame = this.toFileName(content, hashes);
        String name = this.chop(bame) + ".txt";
        return new UserHomeProductResidence(this.product).get().resolve(name);
    }

    private Optional<Hashes> hashingService() {
        Registry registry = (Registry)this.hashes.get();
        if (registry.services().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Hashes)registry.services().iterator().next());
    }

    private String toFileName(byte[] content, Hashes hashes) throws Exception {
        return this.chop(this.onlyLegal(this.base64(hashes.get(content))));
    }

    private String onlyLegal(String string) {
        return IntStream.range(0, string.length()).map(string::charAt).filter(c -> Character.isLetter(c) || Character.isDigit(c)).mapToObj(c -> Character.toString((char)c)).collect(Collectors.joining());
    }

    private String base64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private String chop(String file) {
        int allowed = 251;
        return file.length() <= allowed ? file : file.substring(0, allowed);
    }

    private void write(Path target, byte[] content) throws IOException {
        Files.write(target, content, new OpenOption[0]);
    }

    private Trouble faliledToLocateContent(Exception e, String name) {
        return new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format("Failed to locate content for agreement [%s]", name), e);
    }

    private Trouble noHashingService() {
        return new Trouble((TroubleCode)new NoServicesOfType("hash calculator"), "Any agreement assessment is impossible.");
    }

    public static final class Smart
    implements AgreementAcceptanceService {
        private final AgreementAcceptanceService delegate;

        public Smart(AgreementAcceptanceService delegate) {
            this.delegate = delegate;
        }

        public void accept(Supplier<byte[]> agreement) throws Exception {
            this.delegate.accept(agreement);
        }

        public AgreementState accepted(byte[] content, String name) {
            return this.delegate.accepted(content, name);
        }

        public AgreementState accepted(InputStream stream, String name) {
            byte[] content;
            try {
                content = this.content(stream);
            }
            catch (IOException e) {
                return new Assessment(name, this.faliledToReadContentFromStream(e, name));
            }
            return this.delegate.accepted(content, name);
        }

        private byte[] content(InputStream content) throws IOException {
            int read;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((read = content.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, read);
            }
            buffer.flush();
            byte[] result = buffer.toByteArray();
            buffer.close();
            return result;
        }

        private Trouble faliledToReadContentFromStream(IOException e, String name) {
            return new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format("Failed to read content of agreement [%s]", name), (Exception)e);
        }
    }
}

