/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointWorkingSetCache;
import org.eclipse.debug.internal.ui.views.breakpoints.WorkingSetCategory;
import org.eclipse.debug.ui.AbstractBreakpointOrganizerDelegate;
import org.eclipse.debug.ui.IBreakpointOrganizerDelegateExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class BreakpointSetOrganizer
extends AbstractBreakpointOrganizerDelegate
implements IBreakpointOrganizerDelegateExtension,
IPropertyChangeListener,
IBreakpointsListener {
    private IWorkingSetManager fWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
    private BreakpointWorkingSetCache fCache = null;
    private static IWorkingSet fDefaultWorkingSet = null;

    public BreakpointSetOrganizer() {
        this.fWorkingSetManager.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fCache = new BreakpointWorkingSetCache();
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        fDefaultWorkingSet = BreakpointSetOrganizer.getDefaultWorkingSet();
    }

    @Override
    public IAdaptable[] getCategories(IBreakpoint breakpoint) {
        IWorkingSet[] workingSets;
        ArrayList<WorkingSetCategory> result = new ArrayList<WorkingSetCategory>();
        IWorkingSet[] iWorkingSetArray = workingSets = this.fWorkingSetManager.getWorkingSets();
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet set = iWorkingSetArray[n2];
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
                IAdaptable[] elements;
                IAdaptable[] iAdaptableArray = elements = set.getElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable adaptable = iAdaptableArray[n4];
                    if (adaptable.equals(breakpoint)) {
                        result.add(new WorkingSetCategory(set));
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return result.toArray(new IAdaptable[result.size()]);
    }

    @Override
    public void dispose() {
        this.fWorkingSetManager.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fWorkingSetManager = null;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(IInternalDebugUIConstants.MEMENTO_BREAKPOINT_WORKING_SET_NAME)) {
            IWorkingSet defaultWorkingSet = BreakpointSetOrganizer.getDefaultWorkingSet();
            if (defaultWorkingSet != null) {
                this.fireCategoryChanged((IAdaptable)new WorkingSetCategory(defaultWorkingSet));
            } else {
                this.fireCategoryChanged(null);
            }
        }
        IWorkingSet set = null;
        Object newValue = event.getNewValue();
        if (newValue instanceof IWorkingSet) {
            set = (IWorkingSet)newValue;
        } else if (event.getOldValue() instanceof IWorkingSet) {
            set = (IWorkingSet)event.getOldValue();
        }
        if (set == null) {
            return;
        }
        if (property.equals("workingSetNameChange") && newValue.equals(fDefaultWorkingSet)) {
            BreakpointSetOrganizer.setDefaultWorkingSet((IWorkingSet)newValue);
        }
        if (property.equals("workingSetRemove") && event.getOldValue().equals(fDefaultWorkingSet)) {
            BreakpointSetOrganizer.setDefaultWorkingSet(null);
        }
        if (property.equals("workingSetAdd")) {
            IAdaptable[] breakpoints;
            IAdaptable[] iAdaptableArray = breakpoints = set.getElements();
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable breakpoint = iAdaptableArray[n2];
                if (breakpoint instanceof IBreakpoint) {
                    IMarker marker = ((IBreakpoint)breakpoint).getMarker();
                    this.fCache.addEntry(marker, set.getName());
                    this.fCache.flushMarkerCache(marker);
                }
                ++n2;
            }
        }
        if (set != null && "org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
            this.fireCategoryChanged((IAdaptable)new WorkingSetCategory(set));
        }
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        HashMap<IWorkingSet, List<IBreakpoint>> setToBreakpoints = new HashMap<IWorkingSet, List<IBreakpoint>>();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            IMarker marker = breakpoint.getMarker();
            String[] names = this.getWorkingsetAttributeFromMarker(marker, "workingset_name");
            if (names.length == 0) {
                this.queueToSet(breakpoint, BreakpointSetOrganizer.getDefaultWorkingSet(), setToBreakpoints);
            } else {
                int j = 1;
                while (j < names.length) {
                    IWorkingSet set = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(names[j]);
                    if (set == null) {
                        set = BreakpointSetOrganizer.getDefaultWorkingSet();
                    }
                    this.queueToSet(breakpoint, set, setToBreakpoints);
                    ++j;
                }
            }
            ++n2;
        }
        for (Map.Entry entry : setToBreakpoints.entrySet()) {
            IWorkingSet set = (IWorkingSet)entry.getKey();
            List list = (List)entry.getValue();
            this.addBreakpointsToSet(list.toArray(new IBreakpoint[list.size()]), set);
        }
    }

    private void queueToSet(IBreakpoint breakpoint, IWorkingSet set, Map<IWorkingSet, List<IBreakpoint>> queue) {
        List<IBreakpoint> list = queue.get(set);
        if (list == null) {
            list = new ArrayList<IBreakpoint>();
            queue.put(set, list);
        }
        list.add(breakpoint);
    }

    private void addBreakpointsToSet(IBreakpoint[] breakpoints, IWorkingSet set) {
        if (set != null) {
            IAdaptable[] elements = set.getElements();
            HashSet<IAdaptable> collection = new HashSet<IAdaptable>(elements.length);
            ArrayList<IAdaptable> list = new ArrayList<IAdaptable>(elements.length + breakpoints.length);
            IAdaptable[] iAdaptableArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable element = iAdaptableArray[n2];
                collection.add(element);
                list.add(element);
                ++n2;
            }
            iAdaptableArray = breakpoints;
            n = breakpoints.length;
            n2 = 0;
            while (n2 < n) {
                IAdaptable breakpoint = iAdaptableArray[n2];
                if (!collection.contains(breakpoint)) {
                    list.add(breakpoint);
                    this.fCache.addEntry(breakpoint.getMarker(), set.getName());
                    this.fCache.flushMarkerCache(breakpoint.getMarker());
                }
                ++n2;
            }
            set.setElements(list.toArray(new IAdaptable[list.size()]));
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        IWorkingSet[] workingSets = this.fWorkingSetManager.getWorkingSets();
        IWorkingSet set = null;
        IWorkingSet[] iWorkingSetArray = workingSets;
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            set = workingSet;
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
                this.clean(set);
            }
            ++n2;
        }
    }

    private void clean(IWorkingSet workingSet) {
        IAdaptable adaptable;
        IAdaptable[] elements = workingSet.getElements();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        boolean update = false;
        int i = 0;
        while (i < elements.length) {
            IBreakpoint breakpoint;
            adaptable = elements[i];
            if (adaptable instanceof IBreakpoint && !manager.isRegistered(breakpoint = (IBreakpoint)adaptable)) {
                update = true;
                elements[i] = null;
            }
            ++i;
        }
        if (update) {
            ArrayList<IAdaptable> newElements = new ArrayList<IAdaptable>(elements.length);
            IAdaptable[] iAdaptableArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                adaptable = iAdaptableArray[n2];
                if (adaptable != null) {
                    newElements.add(adaptable);
                }
                ++n2;
            }
            workingSet.setElements(newElements.toArray(new IAdaptable[newElements.size()]));
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public static IWorkingSet getDefaultWorkingSet() {
        IPreferenceStore preferenceStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String name = preferenceStore.getString(IInternalDebugUIConstants.MEMENTO_BREAKPOINT_WORKING_SET_NAME);
        if (name != null) {
            return PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name);
        }
        return null;
    }

    public static void setDefaultWorkingSet(IWorkingSet set) {
        String name = "";
        if (set != null && "org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
            name = set.getName();
        }
        fDefaultWorkingSet = set;
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(DebugUIPlugin.getUniqueIdentifier());
        if (node != null) {
            try {
                node.put(IInternalDebugUIConstants.MEMENTO_BREAKPOINT_WORKING_SET_NAME, name);
                node.flush();
            }
            catch (BackingStoreException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    @Override
    public boolean canRemove(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            WorkingSetCategory wsc = (WorkingSetCategory)category;
            return "org.eclipse.debug.ui.breakpointWorkingSet".equals(wsc.getWorkingSet().getId());
        }
        return super.canRemove(breakpoint, category);
    }

    @Override
    public boolean canAdd(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            WorkingSetCategory wsc = (WorkingSetCategory)category;
            return "org.eclipse.debug.ui.breakpointWorkingSet".equals(wsc.getWorkingSet().getId());
        }
        return super.canAdd(breakpoint, category);
    }

    @Override
    public void addBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
        this.addBreakpoints(new IBreakpoint[]{breakpoint}, category);
    }

    private String[] getWorkingsetAttributeFromMarker(IMarker marker, String type) {
        try {
            String name = (String)marker.getAttribute(type);
            if (name != null) {
                return name.split("\\<;#>");
            }
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
        }
        return new String[0];
    }

    @Override
    public void removeBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            IWorkingSet set = ((WorkingSetCategory)category).getWorkingSet();
            IAdaptable[] elements = set.getElements();
            ArrayList<IAdaptable> list = new ArrayList<IAdaptable>();
            IAdaptable[] iAdaptableArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable adaptable = iAdaptableArray[n2];
                if (!adaptable.equals(breakpoint)) {
                    list.add(adaptable);
                }
                ++n2;
            }
            this.fCache.removeMappedEntry(breakpoint.getMarker(), set.getName());
            this.fCache.flushMarkerCache(breakpoint.getMarker());
            set.setElements(list.toArray(new IAdaptable[list.size()]));
        }
    }

    @Override
    public IAdaptable[] getCategories() {
        IWorkingSet[] workingSets = this.fWorkingSetManager.getWorkingSets();
        ArrayList<WorkingSetCategory> all = new ArrayList<WorkingSetCategory>();
        IWorkingSet[] iWorkingSetArray = workingSets;
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet set = iWorkingSetArray[n2];
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
                all.add(new WorkingSetCategory(set));
            }
            ++n2;
        }
        return all.toArray(new IAdaptable[all.size()]);
    }

    @Override
    public void addBreakpoints(IBreakpoint[] breakpoints, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            IWorkingSet set = ((WorkingSetCategory)category).getWorkingSet();
            this.addBreakpointsToSet(breakpoints, set);
        }
    }

    @Override
    public void removeBreakpoints(IBreakpoint[] breakpoints, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            IWorkingSet set = ((WorkingSetCategory)category).getWorkingSet();
            IAdaptable[] elements = set.getElements();
            ArrayList list = new ArrayList(elements.length);
            Collections.addAll(list, elements);
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                this.fCache.removeMappedEntry(breakpoint.getMarker(), set.getName());
                this.fCache.flushMarkerCache(breakpoint.getMarker());
                list.remove(breakpoint);
                ++n2;
            }
            set.setElements(list.toArray(new IAdaptable[list.size()]));
        }
    }
}

