/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import java.util.Collection;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class GitDiffTreeViewer
extends DiffTreeViewer {
    private final ICompareContainer container;
    private IAction collapseAction;
    private IAction expandAction;
    private Collection<IAction> extraActions;

    public GitDiffTreeViewer(Composite parent, ICompareContainer container, CompareConfiguration configuration) {
        super(parent, configuration);
        this.container = container;
    }

    public void fireOpen(OpenEvent event) {
        super.fireOpen(event);
    }

    public void setActions(Collection<IAction> actions) {
        this.extraActions = actions;
    }

    protected void fillContextMenu(IMenuManager manager) {
        IWorkbenchPart part;
        super.fillContextMenu(manager);
        if (!manager.isEmpty() && (part = this.container.getWorkbenchPart()) != null) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)UIUtils.createShowInMenu(part.getSite().getWorkbenchWindow()));
        }
        if (this.extraActions != null && !this.extraActions.isEmpty()) {
            manager.add((IContributionItem)new Separator());
            this.extraActions.forEach(arg_0 -> ((IMenuManager)manager).add(arg_0));
        }
    }

    protected void createToolItems(ToolBarManager toolbarManager) {
        super.createToolItems(toolbarManager);
        this.collapseAction = new Action(UIText.UIUtils_CollapseAll, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL")){

            public void run() {
                UIUtils.collapseAll((AbstractTreeViewer)GitDiffTreeViewer.this);
            }
        };
        toolbarManager.add(this.collapseAction);
        this.expandAction = new Action(UIText.UIUtils_ExpandAll, UIIcons.EXPAND_ALL){

            public void run() {
                UIUtils.expandAll((AbstractTreeViewer)GitDiffTreeViewer.this);
            }
        };
        toolbarManager.add(this.expandAction);
    }

    protected void inputChanged(Object in, Object oldInput) {
        super.inputChanged(in, oldInput);
        if (in != oldInput) {
            this.updateActions(in);
        }
    }

    private void updateActions(Object input) {
        boolean enabled = false;
        if (input instanceof IDiffContainer) {
            IDiffElement[] children;
            IDiffElement[] iDiffElementArray = children = ((IDiffContainer)input).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement child = iDiffElementArray[n2];
                if (child instanceof IDiffContainer && ((IDiffContainer)child).hasChildren()) {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        this.collapseAction.setEnabled(enabled);
        this.expandAction.setEnabled(enabled);
    }
}

