/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.ProfileRule;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.ui.Messages;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class CPPropetyPage
extends PropertyPage
implements IContextProvider {
    private static Map sProfileToProfileRuleMap = new HashMap();
    private Text txtProfileName;
    private Text txtProfileDesc;
    private Button btnAutoConnect;
    private ISchedulingRule profileRule;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());

    public CPPropetyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        content.setLayout((Layout)layout);
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.cp_name"));
        this.txtProfileName = new Text(content, 2048);
        this.txtProfileName.setLayoutData((Object)new GridData(768));
        this.txtProfileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CPPropetyPage.this.validate();
            }
        });
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.cp_desc"));
        this.txtProfileDesc = new Text(content, 2048);
        this.txtProfileDesc.setLayoutData((Object)new GridData(768));
        this.btnAutoConnect = new Button(content, 32);
        this.btnAutoConnect.setText(Messages.ConnectionProfileDetailsPage_Autoconnect_startup);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.btnAutoConnect.setLayoutData((Object)gd);
        this.initControls();
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_CP_PROPERTY_PAGE", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        return content;
    }

    public boolean performOk() {
        IConnectionProfile profile = this.getConnectionProfile();
        boolean autoConnectChanged = this.btnAutoConnect.getSelection() ^ profile.isAutoConnect();
        if (autoConnectChanged || !this.txtProfileName.getText().equals(profile.getName()) || !this.txtProfileDesc.getText().equals(profile.getDescription())) {
            if (autoConnectChanged && this.profileRule == null) {
                this.profileRule = CPPropetyPage.getProfileRule(profile);
                Job.getJobManager().beginRule(this.profileRule, null);
            }
            try {
                ProfileManager.getInstance().modifyProfile(profile, this.txtProfileName.getText(), this.txtProfileDesc.getText(), Boolean.valueOf(this.btnAutoConnect.getSelection()));
            }
            catch (ConnectionProfileException e) {
                ExceptionHandler.showException(this.getShell(), ConnectivityUIPlugin.getDefault().getResourceString("dialog.exception.title"), ConnectivityUIPlugin.getDefault().getResourceString("dialog.exception.message", new Object[]{e.getMessage()}), e);
            }
        }
        return true;
    }

    private void initControls() {
        IConnectionProfile profile = this.getConnectionProfile();
        this.txtProfileName.setText(profile.getName());
        this.txtProfileDesc.setText(profile.getDescription());
        boolean showAutoConnect = profile.getProvider().needsMaintainConnection();
        if (!showAutoConnect) {
            this.btnAutoConnect.setSelection(true);
            this.btnAutoConnect.setEnabled(false);
            this.btnAutoConnect.setVisible(false);
        } else {
            this.btnAutoConnect.setSelection(profile.isAutoConnect());
        }
        this.setErrorMessage(null);
    }

    private IConnectionProfile getConnectionProfile() {
        IAdaptable element = this.getElement();
        IConnectionProfile profile = (IConnectionProfile)element.getAdapter(IConnectionProfile.class);
        return profile;
    }

    private void validate() {
        String errorMessage = null;
        if (this.txtProfileName.getText().trim().length() == 0) {
            errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.NoName");
        } else if (!this.getConnectionProfile().getName().equals(this.txtProfileName.getText())) {
            IConnectionProfile foundProfile = null;
            String path = ProfileManager.getInstance().getProfilePath(this.getConnectionProfile());
            if (path != null) {
                String[] parsedPath = ProfileManager.getInstance().tokenize(path, InternalProfileManager.PROFILE_PATH_SEPARATOR);
                parsedPath[parsedPath.length - 1] = this.txtProfileName.getText();
                String updatedPath = ProfileManager.getInstance().unTokenize(parsedPath);
                foundProfile = ProfileManager.getInstance().getProfileByFullPath(updatedPath);
            }
            if (foundProfile != null) {
                errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.DuplicateName");
            }
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    public void dispose() {
        if (this.profileRule != null) {
            Job.getJobManager().endRule(this.profileRule);
            this.profileRule = null;
        }
        super.dispose();
    }

    public static ISchedulingRule getProfileRule(IConnectionProfile profile) {
        ISchedulingRule rule = (ISchedulingRule)sProfileToProfileRuleMap.get(profile);
        if (rule == null) {
            rule = new ProfileRule(profile);
            sProfileToProfileRuleMap.put(profile, rule);
        }
        return rule;
    }
}

