/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ui.internal.InternalWSDLMultiPageEditor;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Description;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IDescription;

public class WSDLEditorResourceChangeHandler {
    protected InternalWSDLMultiPageEditor wsdlEditor;
    protected boolean isUpdateRequired;
    protected InternalResourceChangeListener resourceChangeListener;
    protected InternalPartListener partListener;

    public WSDLEditorResourceChangeHandler(InternalWSDLMultiPageEditor wsdlEditor) {
        this.wsdlEditor = wsdlEditor;
        this.resourceChangeListener = new InternalResourceChangeListener();
        this.partListener = new InternalPartListener();
    }

    public void attach() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        this.wsdlEditor.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.partListener);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        this.wsdlEditor.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.partListener);
    }

    protected Map computeDependencyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        IDescription description = this.wsdlEditor.getModel();
        Definition definition = (Definition)((W11Description)description).getTarget();
        ResourceSet resourceSet = definition.eResource().getResourceSet();
        for (Resource resource : resourceSet.getResources()) {
            String uri;
            if (resource == definition.eResource() || map.get(uri = resource.getURI().toString()) != null) continue;
            map.put(uri, uri);
        }
        return map;
    }

    public void performReload() {
        boolean doReload = false;
        int policy = WSDLEditorPlugin.getInstance().getDependenciesChangedPolicy();
        if (policy == WSDLEditorPlugin.DEPENDECIES_CHANGED_POLICY_PROMPT) {
            doReload = MessageDialog.openQuestion((Shell)this.wsdlEditor.getSite().getShell(), (String)Messages._UI_DEPENDENCIES_CHANGED, (String)Messages._UI_DEPENDENCIES_CHANGED_REFRESH);
        } else if (policy == WSDLEditorPlugin.DEPENDECIES_CHANGED_POLICY_RELOAD) {
            doReload = true;
        }
        if (doReload) {
            this.wsdlEditor.reloadDependencies();
        }
    }

    public boolean isListeningToResourceChanges() {
        int policy = WSDLEditorPlugin.getInstance().getDependenciesChangedPolicy();
        return policy == WSDLEditorPlugin.DEPENDECIES_CHANGED_POLICY_PROMPT || policy == WSDLEditorPlugin.DEPENDECIES_CHANGED_POLICY_RELOAD;
    }

    class InternalPartListener
    implements IPartListener {
        InternalPartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == WSDLEditorResourceChangeHandler.this.wsdlEditor && WSDLEditorResourceChangeHandler.this.isUpdateRequired) {
                WSDLEditorResourceChangeHandler.this.isUpdateRequired = false;
                WSDLEditorResourceChangeHandler.this.performReload();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    class InternalResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        protected List list = new ArrayList();
        protected boolean isPending = false;
        protected int count = 0;

        InternalResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (WSDLEditorResourceChangeHandler.this.isListeningToResourceChanges() && !WSDLEditorResourceChangeHandler.this.isUpdateRequired) {
                if (event.getType() == 1) {
                    IResourceDelta[] deltas = event.getDelta().getAffectedChildren();
                    int i = 0;
                    while (i < deltas.length) {
                        try {
                            deltas[i].accept((IResourceDeltaVisitor)this);
                        }
                        catch (Exception exception) {}
                        ++i;
                    }
                }
                if (this.list.size() > 0 && !this.isPending) {
                    this.isPending = true;
                    new ReloadDependenciesJob().schedule(2000L);
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1 && !this.list.contains(resource)) {
                this.list.add(resource);
            }
            return true;
        }

        class ReloadDependenciesJob
        extends Job {
            public ReloadDependenciesJob() {
                super("Reload WSDL dependencies");
                this.setSystem(true);
                this.setPriority(20);
            }

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Map dependencyMap = WSDLEditorResourceChangeHandler.this.computeDependencyMap();
                        for (IResource resource : ((ReloadDependenciesJob)ReloadDependenciesJob.this).InternalResourceChangeListener.this.list) {
                            String platformPath = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)false).toString();
                            if (dependencyMap.get(platformPath) == null) continue;
                            ((InternalResourceChangeListener)((ReloadDependenciesJob)ReloadDependenciesJob.this).InternalResourceChangeListener.this).WSDLEditorResourceChangeHandler.this.isUpdateRequired = true;
                            if (((InternalResourceChangeListener)((ReloadDependenciesJob)ReloadDependenciesJob.this).InternalResourceChangeListener.this).WSDLEditorResourceChangeHandler.this.wsdlEditor.getSite().getWorkbenchWindow().getPartService().getActivePart() != ((InternalResourceChangeListener)((ReloadDependenciesJob)ReloadDependenciesJob.this).InternalResourceChangeListener.this).WSDLEditorResourceChangeHandler.this.wsdlEditor) continue;
                            ((InternalResourceChangeListener)((ReloadDependenciesJob)ReloadDependenciesJob.this).InternalResourceChangeListener.this).WSDLEditorResourceChangeHandler.this.isUpdateRequired = false;
                            WSDLEditorResourceChangeHandler.this.performReload();
                        }
                        ((ReloadDependenciesJob)ReloadDependenciesJob.this).InternalResourceChangeListener.this.isPending = false;
                        ((ReloadDependenciesJob)ReloadDependenciesJob.this).InternalResourceChangeListener.this.list = new ArrayList();
                    }
                });
                return Status.OK_STATUS;
            }
        }
    }
}

