/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.wst.jsdt.core.CompletionContext;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.codeassist.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.codeassist.impl.Keywords;

public class DOMCompletionEngine {
    private final CompletionRequestor requestor;
    private final IJavaScriptProject project;
    private ScopedCodeAssistVisitor visitor;

    public DOMCompletionEngine(CompletionRequestor aRequestor, IJavaScriptProject aProject) {
        this.requestor = aRequestor;
        this.project = aProject;
    }

    public void complete(JavaScriptUnit unit, int position, int offset) {
        this.visitor = new ScopedCodeAssistVisitor(position);
        CompletionContext context = new CompletionContext();
        context.setOffset(position - offset);
        context.setTokenKind(0);
        this.requestor.acceptContext(context);
        unit.accept(this.visitor);
    }

    private CompletionProposal createKeywordProposal(char[] keyword) {
        return this.createProposal(3, keyword, keyword);
    }

    private CompletionProposal createProposal(int kind, char[] name, char[] completion) {
        CompletionProposal proposal = CompletionProposal.create(kind, this.visitor.fPosition);
        proposal.setName(name);
        proposal.setCompletion(completion);
        ((Scope)((ScopedCodeAssistVisitor)this.visitor).scopes.peek()).proposals.add(proposal);
        return proposal;
    }

    private CompletionProposal createProposal(int kind, String name, String completion) {
        if (name == null || completion == null) {
            throw new IllegalArgumentException("Completion or Name is missing");
        }
        return this.createProposal(kind, name.toCharArray(), completion.toCharArray());
    }

    private class Scope {
        ArrayList<CompletionProposal> proposals = new ArrayList();

        private Scope() {
        }
    }

    protected class ScopedCodeAssistVisitor
    extends HierarchicalASTVisitor {
        private int fPosition;
        private Stack<Scope> scopes = new Stack();

        public ScopedCodeAssistVisitor(int position) {
            this.fPosition = position;
        }

        private boolean isInside(ASTNode node) {
            int start = node.getStartPosition();
            int end = start + node.getLength();
            return start <= this.fPosition && this.fPosition < end;
        }

        @Override
        public boolean visit(JavaScriptUnit node) {
            this.scopes.push(new Scope());
            return true;
        }

        @Override
        public void endVisit(JavaScriptUnit node) {
            for (Scope scope : this.scopes) {
                for (CompletionProposal proposal : scope.proposals) {
                    DOMCompletionEngine.this.requestor.accept(proposal);
                }
            }
            super.endVisit(node);
        }

        @Override
        public boolean visit(FunctionDeclaration node) {
            boolean inside = this.isInside(node);
            if (node.getStartPosition() < this.fPosition && node.getName() != null) {
                String nodeName = node.getName().toString();
                CompletionProposal proposal = DOMCompletionEngine.this.createProposal(6, nodeName, String.valueOf(nodeName) + "()");
                List parameters = node.parameters();
                if (parameters != null) {
                    char[][] parameterNames = new char[parameters.size()][];
                    int i = 0;
                    while (i < parameters.size()) {
                        SingleVariableDeclaration decl = (SingleVariableDeclaration)parameters.get(i);
                        parameterNames[i] = decl.getName().toString().toCharArray();
                        ++i;
                    }
                    proposal.setParameterNames(parameterNames);
                }
                this.scopes.peek().proposals.add(proposal);
            }
            if (inside) {
                Block body = node.getBody();
                if (body != null) {
                    this.scopes.push(new Scope());
                    body.accept(this);
                }
                this.visitBackwards(node.parameters());
            }
            return false;
        }

        @Override
        public boolean visit(Initializer node) {
            return this.isInside(node);
        }

        @Override
        public boolean visit(Statement node) {
            return this.isInside(node);
        }

        @Override
        public boolean visit(Block node) {
            if (this.isInside(node)) {
                this.visitBackwards(node.statements());
                DOMCompletionEngine.this.createKeywordProposal(Keywords.DO);
                DOMCompletionEngine.this.createKeywordProposal(Keywords.FOR);
                DOMCompletionEngine.this.createKeywordProposal(Keywords.IF);
                DOMCompletionEngine.this.createKeywordProposal(Keywords.RETURN);
                DOMCompletionEngine.this.createKeywordProposal(Keywords.SWITCH);
                DOMCompletionEngine.this.createKeywordProposal(Keywords.THROW);
                DOMCompletionEngine.this.createKeywordProposal(Keywords.TRY);
                DOMCompletionEngine.this.createKeywordProposal(Keywords.WHILE);
                DOMCompletionEngine.this.createKeywordProposal(Keywords.VAR);
                DOMCompletionEngine.this.createKeywordProposal(Keywords.FUNCTION);
                DOMCompletionEngine.this.createKeywordProposal(Keywords.DELETE);
                DOMCompletionEngine.this.createKeywordProposal(Keywords.TYPEOF);
                DOMCompletionEngine.this.createProposal(3, Keywords.IF, Keywords.IF);
            }
            return false;
        }

        @Override
        public boolean visit(VariableDeclaration node) {
            if (node.getStartPosition() < this.fPosition && node.getName() != null) {
                String nodeName = node.getName().toString();
                CompletionProposal proposal = DOMCompletionEngine.this.createProposal(5, nodeName, nodeName);
                this.scopes.peek().proposals.add(proposal);
            }
            return true;
        }

        @Override
        public boolean visit(VariableDeclarationStatement node) {
            this.visitBackwards(node.fragments());
            return false;
        }

        @Override
        public boolean visit(VariableDeclarationExpression node) {
            this.visitBackwards(node.fragments());
            return false;
        }

        @Override
        public boolean visit(CatchClause node) {
            if (this.isInside(node)) {
                node.getBody().accept(this);
                node.getException().accept(this);
            }
            return false;
        }

        @Override
        public boolean visit(ForStatement node) {
            if (this.isInside(node)) {
                node.getBody().accept(this);
                this.visitBackwards(node.initializers());
            }
            return false;
        }

        @Override
        public boolean visit(ForInStatement node) {
            if (this.isInside(node)) {
                node.getBody().accept(this);
                node.getIterationVariable().accept(this);
            }
            return false;
        }

        @Override
        public boolean visit(TypeDeclarationStatement node) {
            if (node.getStartPosition() + node.getLength() < this.fPosition) {
                IBinding binding = node.getDeclaration().getName().resolveBinding();
                if (binding != null) {
                    CompletionProposal proposal = CompletionProposal.create(5, this.fPosition);
                    proposal.setCompletion(binding.getName().toCharArray());
                    DOMCompletionEngine.this.requestor.accept(proposal);
                }
                return false;
            }
            return this.isInside(node);
        }

        private void visitBackwards(List<ASTNode> list) {
            int i = list.size() - 1;
            while (i >= 0) {
                ASTNode curr = list.get(i);
                if (curr.getStartPosition() < this.fPosition) {
                    curr.accept(this);
                }
                --i;
            }
        }
    }
}

