/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.elementedit.jsfhtml;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.pagedesigner.editpolicies.ColumnHelper;
import org.eclipse.jst.pagedesigner.editpolicies.ColumnResizableEditPolicy;
import org.eclipse.jst.pagedesigner.jsf.ui.elementedit.jsfhtml.DefaultJSFHTMLElementEdit;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.viewer.CaretPositionResolver;
import org.eclipse.jst.pagedesigner.viewer.DefaultDropLocationStrategy;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.IDropLocationStrategy;
import org.w3c.dom.Element;

public class ColumnElementEdit
extends DefaultJSFHTMLElementEdit {
    public boolean handleModelChange(Element ele, ElementEditPart part, boolean recursive) {
        EditPart parent = part.getParent();
        if (parent instanceof ElementEditPart) {
            ((ElementEditPart)parent).refreshModelChange(recursive);
            return true;
        }
        return false;
    }

    public void createEditPolicies(ElementEditPart part) {
        part.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new ColumnResizableEditPolicy());
    }

    public IDropLocationStrategy getDropRequestorLocationStrategy(TagIdentifier tag, EditPartViewer viewer) {
        return new MyDropLocationStrategy(viewer);
    }

    private static class MyDropLocationStrategy
    extends DefaultDropLocationStrategy {
        public MyDropLocationStrategy(EditPartViewer viewer) {
            super(viewer);
        }

        public DesignPosition calculateDesignPosition(EditPart target, Point p, IPositionMediator validator) {
            if ((target = validator.getEditableContainer(new Target(target))) instanceof ElementEditPart) {
                TagIdentifier tagId = ((ElementEditPart)target).getTagIdentifier();
                if (IJSFConstants.TAG_IDENTIFIER_DATA_TABLE.isSameTagType(tagId)) {
                    for (NodeEditPart nodeEditPart : target.getChildren()) {
                        Rectangle columnBounds;
                        TagIdentifier tagId2 = nodeEditPart.getTagIdentifier();
                        if (!IJSFConstants.TAG_IDENTIFIER_COLUMN.isSameTagType(tagId2) || !(columnBounds = ColumnHelper.getAdjustedColumnBoundingRectangle((GraphicalEditPart)nodeEditPart)).contains(p)) continue;
                        target = nodeEditPart;
                        break;
                    }
                }
                if (IJSFConstants.TAG_IDENTIFIER_COLUMN.isSameTagType(tagId = ((ElementEditPart)target).getTagIdentifier())) {
                    DesignPosition position = null;
                    Rectangle columnBounds = ColumnHelper.getAdjustedColumnBoundingRectangle((GraphicalEditPart)((GraphicalEditPart)target));
                    position = CaretPositionResolver.toXMiddle((Rectangle)columnBounds, (Point)p) < 0 ? DesignPosition.createPositionBeforePart((EditPart)target) : DesignPosition.createPositionAfterPart((EditPart)target);
                    if (validator.isValidPosition(position)) {
                        return position;
                    }
                }
            }
            return null;
        }

        protected Rectangle createCaretBounds(DesignPosition position) {
            Rectangle bounds = super.createCaretBounds(position);
            GraphicalEditPart parent = (GraphicalEditPart)position.getContainerPart();
            Rectangle containerBounds = parent.getFigure().getBounds().getCopy();
            parent.getFigure().translateToAbsolute((Translatable)containerBounds);
            bounds.height = containerBounds.height;
            bounds.y = containerBounds.y;
            return bounds;
        }
    }
}

