/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.swing;

import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.swing.FilteringListPanel;
import org.eclipse.jpt.common.utility.internal.swing.ListChooser;

public class FilteringListBrowser<T>
implements ListChooser.ListBrowser {
    private FilteringListPanel<T> panel = this.buildPanel();

    protected FilteringListPanel<T> buildPanel() {
        return new LocalFilteringListPanel();
    }

    @Override
    public void browse(ListChooser chooser) {
        this.initializeCellRenderer(chooser);
        int option = JOptionPane.showOptionDialog(chooser, this.buildMessage(chooser), this.buildTitle(chooser), this.buildOptionType(chooser), this.buildMessageType(chooser), this.buildIcon(chooser), this.buildSelectionValues(chooser), this.buildInitialSelectionValue(chooser));
        if (option == 0) {
            chooser.getModel().setSelectedItem(this.panel.getSelection());
        }
        this.panel.getTextField().setText("");
    }

    protected void initializeCellRenderer(JComboBox comboBox) {
        this.panel.getListBox().setCellRenderer(comboBox.getRenderer());
    }

    protected Object buildMessage(JComboBox comboBox) {
        this.panel.setCompleteList(this.convertListModelToArray(comboBox.getModel()));
        this.panel.setSelection(comboBox.getModel().getSelectedItem());
        return this.panel;
    }

    protected T[] convertListModelToArray(ListModel model) {
        int size = model.getSize();
        Object[] result = new Object[size];
        int i = 0;
        while (i < size) {
            result[i] = model.getElementAt(i);
            ++i;
        }
        return result;
    }

    protected String buildTitle(JComboBox comboBox) {
        return null;
    }

    protected int buildOptionType(JComboBox comboBox) {
        return 2;
    }

    protected int buildMessageType(JComboBox comboBox) {
        return 3;
    }

    protected Icon buildIcon(JComboBox comboBox) {
        return null;
    }

    protected Object[] buildSelectionValues(JComboBox comboBox) {
        return null;
    }

    protected Object buildInitialSelectionValue(JComboBox comboBox) {
        return null;
    }

    protected static class LocalFilteringListPanel<S>
    extends FilteringListPanel<S> {
        private static final long serialVersionUID = 1L;

        protected LocalFilteringListPanel() {
            super(ObjectTools.EMPTY_OBJECT_ARRAY, null);
        }

        @Override
        protected String getPrototypeCellValue() {
            return null;
        }
    }
}

