/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.osgi.util.NLS;

public class VerifyResourceSpec {
    private String spec;
    private String[] paths;
    private String otherNames;
    private int lastSuccess = -1;
    private IStatus errorStatus;

    public VerifyResourceSpec(String spec) {
        this.spec = spec;
        int altIndex = spec.indexOf(124);
        if (altIndex < 0) {
            this.paths = new String[1];
            this.paths[0] = spec.trim();
        } else {
            String file1 = spec.substring(0, altIndex).trim();
            String altSpec = spec.substring(altIndex + 1);
            if (altSpec.length() > 0) {
                int index = file1.lastIndexOf(File.separatorChar);
                String dir = index >= 0 ? file1.substring(0, index + 1) : "";
                String[] altNames = altSpec.split("\\|");
                this.paths = new String[altNames.length + 1];
                this.paths[0] = file1;
                int i = 0;
                while (i < altNames.length) {
                    this.paths[i + 1] = dir + altNames[i].trim();
                    ++i;
                }
                this.otherNames = altSpec.replace('|', ',');
            } else {
                this.paths = new String[1];
                this.paths[0] = file1;
            }
        }
    }

    public String[] getPaths() {
        return this.paths;
    }

    public IStatus checkResource(String installDir) {
        File file;
        if (this.lastSuccess >= 0 && (file = new File(installDir, this.paths[this.lastSuccess])).exists()) {
            return Status.OK_STATUS;
        }
        int i = 0;
        while (i < this.paths.length) {
            File file2;
            if (i != this.lastSuccess && (file2 = new File(installDir, this.paths[i])).exists()) {
                this.lastSuccess = i;
                return Status.OK_STATUS;
            }
            ++i;
        }
        if (this.errorStatus == null) {
            this.errorStatus = this.paths.length == 1 || this.otherNames == null ? new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorInstallDirMissingFile, (Object)this.paths[0]), null) : (this.paths.length == 2 ? new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorInstallDirMissingFile2, (Object)this.paths[0], (Object)this.otherNames), null) : new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorInstallDirMissingFile3, (Object)this.paths[0], (Object)this.otherNames), null));
        }
        return this.errorStatus;
    }

    public String toString() {
        return this.spec;
    }
}

