/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;

public abstract class BuildPathWizard
extends NewElementWizard {
    private boolean fDoFlushChange;
    private final CPListElement fEntryToEdit;
    private IPackageFragmentRoot fPackageFragmentRoot;
    private final ArrayList fExistingEntries;

    public BuildPathWizard(CPListElement[] existingEntries, CPListElement newEntry, String titel, ImageDescriptor image) {
        if (image != null) {
            this.setDefaultPageImageDescriptor(image);
        }
        this.setDialogSettings(JavaScriptPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(titel);
        this.fEntryToEdit = newEntry;
        this.fExistingEntries = new ArrayList<CPListElement>(Arrays.asList(existingEntries));
        this.fDoFlushChange = true;
    }

    @Override
    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.fDoFlushChange) {
            IJavaScriptProject javaProject = this.getEntryToEdit().getJavaProject();
            BuildPathsBlock.flush(this.getExistingEntries(), javaProject, this.getSuperType(), monitor);
            IProject project = javaProject.getProject();
            IPath path = this.getEntryToEdit().getPath();
            IResource folder = project.getWorkspace().getRoot().findMember(path);
            this.fPackageFragmentRoot = javaProject.getPackageFragmentRoot(folder);
        }
    }

    public LibrarySuperType getSuperType() {
        return null;
    }

    @Override
    public IJavaScriptElement getCreatedElement() {
        return this.fPackageFragmentRoot;
    }

    public void setDoFlushChange(boolean b) {
        this.fDoFlushChange = b;
    }

    public ArrayList getExistingEntries() {
        return this.fExistingEntries;
    }

    protected CPListElement getEntryToEdit() {
        return this.fEntryToEdit;
    }

    public List getInsertedElements() {
        return new ArrayList();
    }

    public List getRemovedElements() {
        return new ArrayList();
    }

    public List getModifiedElements() {
        ArrayList<CPListElement> result = new ArrayList<CPListElement>(1);
        result.add(this.fEntryToEdit);
        return result;
    }

    public abstract void cancel();
}

