/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.ui.wizards.ClasspathAttributeConfiguration;

public class CPListElementAttribute {
    private CPListElement fParent;
    private String fKey;
    private Object fValue;
    private final boolean fBuiltIn;
    private IStatus fStatus;
    private ClasspathAttributeConfiguration.ClasspathAttributeAccess fCachedAccess;

    public CPListElementAttribute(CPListElement parent, String key, Object value, boolean builtIn) {
        this.fKey = key;
        this.fValue = value;
        this.fParent = parent;
        this.fBuiltIn = builtIn;
        if (!builtIn) {
            Assert.isTrue((value instanceof String || value == null ? 1 : 0) != 0);
        }
        this.fStatus = this.getContainerChildStatus();
    }

    private CPListElementAttribute(boolean buildIn) {
        this.fBuiltIn = buildIn;
    }

    public IIncludePathAttribute getClasspathAttribute() {
        Assert.isTrue((!this.fBuiltIn ? 1 : 0) != 0);
        return JavaScriptCore.newIncludepathAttribute((String)this.fKey, (String)((String)this.fValue));
    }

    public CPListElement getParent() {
        return this.fParent;
    }

    public boolean isBuiltIn() {
        return this.fBuiltIn;
    }

    public boolean isNonModifiable() {
        return this.fStatus != null && !this.fStatus.isOK();
    }

    public boolean isNotSupported() {
        return this.fStatus != null && this.fStatus.getCode() == 1;
    }

    private IStatus getContainerChildStatus() {
        return this.fParent.getContainerChildStatus(this);
    }

    public String getKey() {
        return this.fKey;
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(Object value) {
        this.fValue = value;
        this.fCachedAccess = null;
        this.getParent().attributeChanged(this.fKey);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CPListElementAttribute)) {
            return false;
        }
        CPListElementAttribute attrib = (CPListElementAttribute)obj;
        return attrib.fKey == this.fKey && attrib.getParent().getPath().equals((Object)this.fParent.getPath());
    }

    public CPListElementAttribute copy() {
        CPListElementAttribute result = new CPListElementAttribute(this.fBuiltIn);
        result.fParent = this.fParent;
        result.fKey = this.fKey;
        result.fValue = this.fValue;
        result.fStatus = this.fStatus;
        return result;
    }

    public ClasspathAttributeConfiguration.ClasspathAttributeAccess getClasspathAttributeAccess() {
        if (this.fCachedAccess == null) {
            this.fCachedAccess = new ClasspathAttributeConfiguration.ClasspathAttributeAccess(){

                @Override
                public IIncludePathAttribute getClasspathAttribute() {
                    return CPListElementAttribute.this.getClasspathAttribute();
                }

                @Override
                public IJavaScriptProject getJavaProject() {
                    return CPListElementAttribute.this.getParent().getJavaProject();
                }

                @Override
                public IIncludePathEntry getParentClasspassEntry() {
                    return CPListElementAttribute.this.getParent().getClasspathEntry();
                }
            };
        }
        return this.fCachedAccess;
    }
}

