/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.xml;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.eclipse.wst.wsdl.validation.internal.xml.IXMLCatalog;
import org.eclipse.wst.wsdl.validation.internal.xml.XMLCatalogEntityHolder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLCatalog
implements IXMLCatalog {
    private static final String _APACHE_FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private static final String _APACHE_FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String FILE_PROTOCOL = "file:///";
    private static IXMLCatalog instance = null;
    private static String extxmlcatalogclass = null;
    private static ClassLoader extclassLoader = null;
    private static IXMLCatalog extXMLCatalogInstance = null;
    private static List schemadirs = new ArrayList();
    private static List entities = new ArrayList();
    protected Map catalog = new Hashtable();

    public static IXMLCatalog getInstance() {
        if (instance == null) {
            instance = new XMLCatalog();
            for (XMLCatalogEntityHolder entity : entities) {
                instance.addEntryToCatalog(entity.getPublicId(), entity.getSystemId());
            }
            if (schemadirs.size() > 0) {
                SAXParser saxParser = null;
                try {
                    SAXParserFactoryImpl parserfactory = new SAXParserFactoryImpl();
                    parserfactory.setFeature(_APACHE_FEATURE_NAMESPACE_PREFIXES, true);
                    parserfactory.setFeature(_APACHE_FEATURE_NAMESPACES, true);
                    saxParser = parserfactory.newSAXParser();
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                }
                catch (ParserConfigurationException parserConfigurationException) {
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXException sAXException) {}
                Iterator schemadirIter = schemadirs.iterator();
                SchemaNamespaceHandler handler = (XMLCatalog)instance.new SchemaNamespaceHandler();
                while (schemadirIter.hasNext()) {
                    String schemadir = (String)schemadirIter.next();
                    XMLCatalog.registerSchemasForDir(instance, schemadir, saxParser, handler);
                }
            }
        }
        return instance;
    }

    private static void registerSchemasForDir(IXMLCatalog catalog, String schemadir, SAXParser parser, SchemaNamespaceHandler handler) {
        if (schemadir.startsWith("file:")) {
            schemadir = schemadir.substring(5);
        }
        while (schemadir.startsWith("//")) {
            schemadir = schemadir.substring(1);
        }
        File dir = new File(schemadir);
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            int numfiles = files.length;
            int i = 0;
            while (i < numfiles) {
                File tempfile = files[i];
                Object tempfilepath = tempfile.getAbsolutePath();
                tempfilepath = ((String)tempfilepath).replace('\\', '/');
                while (((String)tempfilepath).startsWith("/")) {
                    tempfilepath = ((String)tempfilepath).substring(1);
                }
                tempfilepath = FILE_PROTOCOL + (String)tempfilepath;
                if (tempfile.isDirectory()) {
                    XMLCatalog.registerSchemasForDir(catalog, (String)tempfilepath, parser, handler);
                } else {
                    handler.reset();
                    try {
                        parser.parse((String)tempfilepath, (DefaultHandler)handler);
                    }
                    catch (Exception exception) {}
                    String targetNamespace = handler.getTargetNamespace();
                    if (targetNamespace != null) {
                        catalog.addEntryToCatalog(targetNamespace, (String)tempfilepath);
                    }
                }
                ++i;
            }
        }
    }

    public static IXMLCatalog getExtensionCatalogInstance() {
        if (extXMLCatalogInstance == null && extxmlcatalogclass != null && extclassLoader != null) {
            try {
                Class<?> catalogClass = extclassLoader != null ? extclassLoader.loadClass(extxmlcatalogclass) : Class.forName(extxmlcatalogclass);
                extXMLCatalogInstance = (IXMLCatalog)catalogClass.newInstance();
            }
            catch (Exception exception) {}
        }
        return extXMLCatalogInstance;
    }

    public static void setExtensionXMLCatalog(String xmlcatalog, ClassLoader classloader) {
        extxmlcatalogclass = xmlcatalog;
        extclassLoader = classloader;
    }

    public static void reset() {
        instance = null;
        extxmlcatalogclass = null;
        extclassLoader = null;
        extXMLCatalogInstance = null;
        entities = new ArrayList();
        schemadirs = new ArrayList();
    }

    public static void addSchemaDir(String schemadir) {
        schemadirs.add(schemadir);
    }

    public static void addEntity(XMLCatalogEntityHolder entity) {
        entities.add(entity);
    }

    @Override
    public void addEntryToCatalog(String publicId, String systemId) {
        this.catalog.put(publicId, systemId);
    }

    @Override
    public String resolveEntityLocation(String publicId, String systemId) {
        String resolvedlocation = null;
        IXMLCatalog extcatalog = XMLCatalog.getExtensionCatalogInstance();
        if (extcatalog != null) {
            resolvedlocation = extcatalog.resolveEntityLocation(publicId, systemId);
        }
        if (resolvedlocation == null) {
            if (systemId == null || systemId.equals("")) {
                systemId = publicId;
            }
            resolvedlocation = (String)this.catalog.get(systemId);
        }
        return resolvedlocation;
    }

    protected class SchemaNamespaceHandler
    extends DefaultHandler {
        private final String TARGET_NAMESPACE = "targetNamespace";
        private final String SCHEMA = "schema";
        private String targetNamespace = null;

        protected SchemaNamespaceHandler() {
        }

        @Override
        public void startElement(String uri, String localname, String arg2, Attributes attributes) throws SAXException {
            if (localname.equals("schema")) {
                int numAtts = attributes.getLength();
                int i = 0;
                while (i < numAtts) {
                    String attname = attributes.getQName(i);
                    if (attname.equals("targetNamespace")) {
                        this.targetNamespace = attributes.getValue(i);
                    }
                    ++i;
                }
            }
            super.startElement(uri, localname, arg2, attributes);
        }

        public String getTargetNamespace() {
            return this.targetNamespace;
        }

        public void reset() {
            this.targetNamespace = null;
        }
    }
}

