/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.net4j.util.collection.AbstractFilteredIterator;
import org.eclipse.net4j.util.collection.ComposedIterator;

public class UnionSet<E>
extends AbstractSet<E> {
    private final Set<E> set1;
    private final Set<E> set2;

    public UnionSet(Collection<? extends E> c1, Collection<? extends E> c2) {
        this.set1 = this.getSet(c1);
        this.set2 = this.getSet(c2);
    }

    @Override
    public Iterator<E> iterator() {
        return new ComposedIterator(this.set1.iterator(), new AbstractFilteredIterator<E>(this.set2.iterator()){

            @Override
            protected boolean isValid(E element2) {
                return !UnionSet.this.set1.contains(element2);
            }
        });
    }

    @Override
    public int size() {
        int size = this.set1.size();
        for (E element2 : this.set2) {
            if (this.set1.contains(element2)) continue;
            ++size;
        }
        return size;
    }

    private Set<E> getSet(Collection<? extends E> c) {
        if (c instanceof Set) {
            return (Set)c;
        }
        return new HashSet<E>(c);
    }
}

