/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.Date;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.eclipse.net4j.util.WrappedException;

public interface CriticalSection {
    public static final CriticalSection UNSYNCHRONIZED = new UnsynchronizedCriticalSection();

    default public void run(Runnable runnable) {
        try {
            this.call(() -> {
                runnable.run();
                return null;
            });
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    default public <V> V supply(Supplier<V> supplier) {
        try {
            return (V)this.call(() -> supplier.get());
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    default public boolean supply(BooleanSupplier supplier) {
        try {
            return this.call(() -> supplier.getAsBoolean());
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    default public int supply(IntSupplier supplier) {
        try {
            return this.call(() -> supplier.getAsInt());
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    default public long supply(LongSupplier supplier) {
        try {
            return this.call(() -> supplier.getAsLong());
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    default public double supply(DoubleSupplier supplier) {
        try {
            return this.call(() -> supplier.getAsDouble());
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    default public <V, E extends Throwable> V call(Class<E> exceptionType, Callable<V> callable) throws E {
        try {
            return this.call(callable);
        }
        catch (Exception ex) {
            if (exceptionType.isInstance(ex)) {
                throw (Throwable)exceptionType.cast(ex);
            }
            throw WrappedException.wrap(ex);
        }
    }

    public <V> V call(Callable<V> var1) throws Exception;

    public Condition newCondition();

    public static class LockedCriticalSection
    implements CriticalSection {
        private final Lock lock;

        public LockedCriticalSection(Lock lock) {
            this.lock = Objects.requireNonNull(lock);
        }

        public final Lock getLock() {
            return this.lock;
        }

        @Override
        public <V> V call(Callable<V> callable) throws Exception {
            this.lock.lock();
            try {
                V v = callable.call();
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void run(Runnable runnable) {
            this.lock.lock();
            try {
                runnable.run();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public <V> V supply(Supplier<V> supplier) {
            this.lock.lock();
            try {
                V v = supplier.get();
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean supply(BooleanSupplier supplier) {
            this.lock.lock();
            try {
                boolean bl = supplier.getAsBoolean();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public int supply(IntSupplier supplier) {
            this.lock.lock();
            try {
                int n = supplier.getAsInt();
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public long supply(LongSupplier supplier) {
            this.lock.lock();
            try {
                long l = supplier.getAsLong();
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public double supply(DoubleSupplier supplier) {
            this.lock.lock();
            try {
                double d = supplier.getAsDouble();
                return d;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public Condition newCondition() {
            return this.lock.newCondition();
        }
    }

    public static class SynchronizedCriticalSection
    implements CriticalSection {
        private final Object mutex;

        public SynchronizedCriticalSection(Object mutex) {
            this.mutex = Objects.requireNonNull(mutex);
        }

        public final Object getMutex() {
            return this.mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V call(Callable<V> callable) throws Exception {
            Object object = this.mutex;
            synchronized (object) {
                return callable.call();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Runnable runnable) {
            Object object = this.mutex;
            synchronized (object) {
                runnable.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V supply(Supplier<V> supplier) {
            Object object = this.mutex;
            synchronized (object) {
                return supplier.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean supply(BooleanSupplier supplier) {
            Object object = this.mutex;
            synchronized (object) {
                return supplier.getAsBoolean();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int supply(IntSupplier supplier) {
            Object object = this.mutex;
            synchronized (object) {
                return supplier.getAsInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long supply(LongSupplier supplier) {
            Object object = this.mutex;
            synchronized (object) {
                return supplier.getAsLong();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double supply(DoubleSupplier supplier) {
            Object object = this.mutex;
            synchronized (object) {
                return supplier.getAsDouble();
            }
        }

        @Override
        public Condition newCondition() {
            return new Condition(){

                @Override
                public void await() throws InterruptedException {
                    mutex.wait();
                }

                @Override
                public void awaitUninterruptibly() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public long awaitNanos(long nanosTimeout) throws InterruptedException {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean await(long time, TimeUnit unit) throws InterruptedException {
                    mutex.wait(unit.toMillis(time));
                    return false;
                }

                @Override
                public boolean awaitUntil(Date deadline) throws InterruptedException {
                    mutex.wait(deadline.getTime() - System.currentTimeMillis());
                    return false;
                }

                @Override
                public void signal() {
                    mutex.notify();
                }

                @Override
                public void signalAll() {
                    mutex.notifyAll();
                }
            };
        }
    }

    public static class UnsynchronizedCriticalSection
    implements CriticalSection {
        @Override
        public <V> V call(Callable<V> callable) throws Exception {
            return callable.call();
        }

        @Override
        public void run(Runnable runnable) {
            runnable.run();
        }

        @Override
        public <V> V supply(Supplier<V> supplier) {
            return supplier.get();
        }

        @Override
        public boolean supply(BooleanSupplier supplier) {
            return supplier.getAsBoolean();
        }

        @Override
        public int supply(IntSupplier supplier) {
            return supplier.getAsInt();
        }

        @Override
        public long supply(LongSupplier supplier) {
            return supplier.getAsLong();
        }

        @Override
        public double supply(DoubleSupplier supplier) {
            return supplier.getAsDouble();
        }

        @Override
        public Condition newCondition() {
            return new Condition(){

                @Override
                public void await() throws InterruptedException {
                }

                @Override
                public void awaitUninterruptibly() {
                }

                @Override
                public long awaitNanos(long nanosTimeout) throws InterruptedException {
                    return 0L;
                }

                @Override
                public boolean await(long time, TimeUnit unit) throws InterruptedException {
                    return false;
                }

                @Override
                public boolean awaitUntil(Date deadline) throws InterruptedException {
                    return false;
                }

                @Override
                public void signal() {
                }

                @Override
                public void signalAll() {
                }
            };
        }
    }
}

