/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.lock;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;

public class CDOLockAreaImpl
implements IDurableLockingManager.LockArea {
    public static final int DEFAULT_DURABLE_LOCKING_ID_BYTES = 32;
    private final String durableLockingID;
    private final String userID;
    private final CDOBranchPoint branchPoint;
    private final boolean readOnly;
    private final Map<CDOID, IDurableLockingManager.LockGrade> locks;
    private final boolean missing;

    public CDOLockAreaImpl(String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        this.durableLockingID = durableLockingID;
        this.userID = userID;
        this.branchPoint = branchPoint;
        this.readOnly = readOnly;
        this.locks = locks;
        this.missing = false;
    }

    public CDOLockAreaImpl(String durableLockingID) {
        this.durableLockingID = durableLockingID;
        this.userID = null;
        this.branchPoint = null;
        this.readOnly = false;
        this.locks = null;
        this.missing = true;
    }

    @Override
    public String getDurableLockingID() {
        return this.durableLockingID;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public CDOBranch getBranch() {
        return this.branchPoint.getBranch();
    }

    @Override
    public long getTimeStamp() {
        return this.branchPoint.getTimeStamp();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public Map<CDOID, IDurableLockingManager.LockGrade> getLocks() {
        return this.locks;
    }

    public String toString() {
        return MessageFormat.format("DurableLockArea\nid={0}\nuser={1}\nbranchPoint={2}\nreadOnly={3}\nlocks={4}", this.durableLockingID, this.userID, this.branchPoint, this.readOnly, this.locks);
    }

    @Override
    public boolean isMissing() {
        return this.missing;
    }
}

