/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.impl;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.operations.CollectionTypeOperations;
import org.eclipse.ocl.uml.CollectionType;
import org.eclipse.ocl.uml.UMLPackage;
import org.eclipse.ocl.uml.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedASTNode;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.internal.impl.DataTypeImpl;

public class CollectionTypeImpl
extends DataTypeImpl
implements CollectionType {
    protected static final int START_POSITION_EDEFAULT = -1;
    protected int startPosition = -1;
    protected static final int END_POSITION_EDEFAULT = -1;
    protected int endPosition = -1;
    protected static final int TYPE_START_POSITION_EDEFAULT = -1;
    protected int typeStartPosition = -1;
    protected static final int TYPE_END_POSITION_EDEFAULT = -1;
    protected int typeEndPosition = -1;
    protected Classifier elementType;
    protected static final CollectionKind KIND_EDEFAULT = CollectionKind.SET_LITERAL;
    private EList<Operation> operations;
    private EList<Operation> iterators;

    protected CollectionTypeImpl() {
    }

    protected CollectionTypeImpl(Classifier elementType) {
        this();
        this.elementType = elementType;
    }

    protected EClass eStaticClass() {
        return UMLPackage.Literals.COLLECTION_TYPE;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int newStartPosition) {
        int oldStartPosition = this.startPosition;
        this.startPosition = newStartPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 40, oldStartPosition, this.startPosition));
        }
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(int newEndPosition) {
        int oldEndPosition = this.endPosition;
        this.endPosition = newEndPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 41, oldEndPosition, this.endPosition));
        }
    }

    public int getTypeStartPosition() {
        return this.typeStartPosition;
    }

    public void setTypeStartPosition(int newTypeStartPosition) {
        int oldTypeStartPosition = this.typeStartPosition;
        this.typeStartPosition = newTypeStartPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 42, oldTypeStartPosition, this.typeStartPosition));
        }
    }

    public int getTypeEndPosition() {
        return this.typeEndPosition;
    }

    public void setTypeEndPosition(int newTypeEndPosition) {
        int oldTypeEndPosition = this.typeEndPosition;
        this.typeEndPosition = newTypeEndPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 43, oldTypeEndPosition, this.typeEndPosition));
        }
    }

    public Classifier getElementType() {
        if (this.elementType != null && this.elementType.eIsProxy()) {
            InternalEObject oldElementType = (InternalEObject)this.elementType;
            this.elementType = (Classifier)this.eResolveProxy(oldElementType);
            if (this.elementType != oldElementType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 44, (Object)oldElementType, (Object)this.elementType));
            }
        }
        return this.elementType;
    }

    public Classifier basicGetElementType() {
        return this.elementType;
    }

    public void setElementType(Classifier newElementType) {
        Classifier oldElementType = this.elementType;
        this.elementType = newElementType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 44, (Object)oldElementType, (Object)this.elementType));
        }
    }

    public CollectionKind getKind() {
        return CollectionKind.COLLECTION_LITERAL;
    }

    public String getName() {
        if (this.name == null) {
            StringBuffer myName = new StringBuffer();
            switch (this.getKind()) {
                case SET_LITERAL: {
                    myName.append("Set");
                    break;
                }
                case ORDERED_SET_LITERAL: {
                    myName.append("OrderedSet");
                    break;
                }
                case BAG_LITERAL: {
                    myName.append("Bag");
                    break;
                }
                case SEQUENCE_LITERAL: {
                    myName.append("Sequence");
                    break;
                }
                default: {
                    myName.append("Collection");
                }
            }
            myName.append('(');
            Classifier elementType = this.getElementType();
            String elementTypeName = elementType != null ? elementType.getName() : "";
            myName.append(elementTypeName);
            myName.append(')');
            this.name = myName.toString();
        }
        return this.name;
    }

    private void maybeInitializeOwnedOperations() {
        if (this.getOwnedOperations().isEmpty()) {
            Environment env = Environment.Registry.INSTANCE.getEnvironmentFor((Object)this);
            this.getOwnedOperations().addAll(OCLStandardLibraryImpl.createCollectionTypeOperations(env, this.getKind()));
        }
    }

    public EList<Operation> oclIterators() {
        if (this.iterators == null) {
            this.maybeInitializeOwnedOperations();
            this.iterators = new BasicEList.FastCompare((Collection)this.getOwnedOperations());
            this.iterators = OCLStandardLibraryImpl.selectIterators(this.iterators);
        }
        return this.iterators;
    }

    public EList<Operation> oclOperations() {
        if (this.operations == null) {
            this.maybeInitializeOwnedOperations();
            this.operations = new BasicEList.FastCompare((Collection)this.getOwnedOperations());
            this.operations.removeAll(this.oclIterators());
        }
        return this.operations;
    }

    public boolean checkCollectionTypeName(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return CollectionTypeOperations.checkCollectionTypeName((org.eclipse.ocl.types.CollectionType)this, (DiagnosticChain)diagnostics, context);
    }

    public boolean checkNoInvalidValues(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return CollectionTypeOperations.checkNoInvalidValues((org.eclipse.ocl.types.CollectionType)this, (DiagnosticChain)diagnostics, context);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 40: {
                return this.getStartPosition();
            }
            case 41: {
                return this.getEndPosition();
            }
            case 42: {
                return this.getTypeStartPosition();
            }
            case 43: {
                return this.getTypeEndPosition();
            }
            case 44: {
                if (resolve) {
                    return this.getElementType();
                }
                return this.basicGetElementType();
            }
            case 45: {
                return this.getKind();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 40: {
                this.setStartPosition((Integer)newValue);
                return;
            }
            case 41: {
                this.setEndPosition((Integer)newValue);
                return;
            }
            case 42: {
                this.setTypeStartPosition((Integer)newValue);
                return;
            }
            case 43: {
                this.setTypeEndPosition((Integer)newValue);
                return;
            }
            case 44: {
                this.setElementType((Classifier)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 40: {
                this.setStartPosition(-1);
                return;
            }
            case 41: {
                this.setEndPosition(-1);
                return;
            }
            case 42: {
                this.setTypeStartPosition(-1);
                return;
            }
            case 43: {
                this.setTypeEndPosition(-1);
                return;
            }
            case 44: {
                this.setElementType(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 40: {
                return this.startPosition != -1;
            }
            case 41: {
                return this.endPosition != -1;
            }
            case 42: {
                return this.typeStartPosition != -1;
            }
            case 43: {
                return this.typeEndPosition != -1;
            }
            case 44: {
                return this.elementType != null;
            }
            case 45: {
                return this.getKind() != KIND_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == PredefinedType.class) {
            return -1;
        }
        if (baseClass == ASTNode.class) {
            switch (derivedFeatureID) {
                case 40: {
                    return 0;
                }
                case 41: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == TypedASTNode.class) {
            switch (derivedFeatureID) {
                case 42: {
                    return 2;
                }
                case 43: {
                    return 3;
                }
            }
            return -1;
        }
        if (baseClass == org.eclipse.ocl.types.CollectionType.class) {
            switch (derivedFeatureID) {
                case 44: {
                    return 4;
                }
                case 45: {
                    return 5;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == PredefinedType.class) {
            return -1;
        }
        if (baseClass == ASTNode.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 40;
                }
                case 1: {
                    return 41;
                }
            }
            return -1;
        }
        if (baseClass == TypedASTNode.class) {
            switch (baseFeatureID) {
                case 2: {
                    return 42;
                }
                case 3: {
                    return 43;
                }
            }
            return -1;
        }
        if (baseClass == org.eclipse.ocl.types.CollectionType.class) {
            switch (baseFeatureID) {
                case 4: {
                    return 44;
                }
                case 5: {
                    return 45;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (startPosition: ");
        result.append(this.startPosition);
        result.append(", endPosition: ");
        result.append(this.endPosition);
        result.append(", typeStartPosition: ");
        result.append(this.typeStartPosition);
        result.append(", typeEndPosition: ");
        result.append(this.typeEndPosition);
        result.append(')');
        return result.toString();
    }
}

