/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalComputerDescriptor;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposalComputerRegistry;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposoalCatigoriesConfigurationRegistry;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationReader;
import org.osgi.framework.Bundle;

public final class CompletionProposalCategory {
    private static final String ICON = "icon";
    private static final String ID = "id";
    private static final String NAME = "name";
    private final String fId;
    private final String fName;
    private final ImageDescriptor fImage;
    private String fLastError = null;

    CompletionProposalCategory(IConfigurationElement element) throws CoreException {
        Bundle bundle;
        Assert.isLegal((element != null ? 1 : 0) != 0);
        this.fId = element.getAttribute(ID);
        ContentAssistUtils.checkExtensionAttributeNotNull(this.fId, ID, element);
        String name = element.getAttribute(NAME);
        this.fName = name == null ? this.fId : name;
        String icon = element.getAttribute(ICON);
        ImageDescriptor img = null;
        if (icon != null && (bundle = ContentAssistUtils.getBundle(element)) != null) {
            img = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundle.getSymbolicName(), (String)icon);
        }
        this.fImage = img;
    }

    CompletionProposalCategory(String id, String name) {
        this.fId = id;
        this.fName = name;
        this.fImage = null;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public String getDisplayName() {
        return LegacyActionTools.removeMnemonics((String)this.fName);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fImage;
    }

    public boolean isDisplayedOnOwnPage(String contentTypeID) {
        boolean displayOnOwnPage = true;
        ICompletionProposalCategoriesConfigurationReader properties = CompletionProposoalCatigoriesConfigurationRegistry.getDefault().getReadableConfiguration(contentTypeID);
        if (properties != null) {
            displayOnOwnPage = properties.shouldDisplayOnOwnPage(this.fId);
        }
        return displayOnOwnPage;
    }

    public boolean isIncludedOnDefaultPage(String contentTypeID) {
        boolean includeOnDefaultPage = true;
        ICompletionProposalCategoriesConfigurationReader properties = CompletionProposoalCatigoriesConfigurationRegistry.getDefault().getReadableConfiguration(contentTypeID);
        if (properties != null) {
            includeOnDefaultPage = properties.shouldDisplayOnDefaultPage(this.fId);
        }
        return includeOnDefaultPage;
    }

    public int getPageSortRank(String contentTypeID) {
        int sortOrder = Integer.MAX_VALUE;
        ICompletionProposalCategoriesConfigurationReader properties = CompletionProposoalCatigoriesConfigurationRegistry.getDefault().getReadableConfiguration(contentTypeID);
        if (properties != null) {
            sortOrder = properties.getPageSortOrder(this.fId);
        }
        return sortOrder;
    }

    public int getDefaultPageSortRank(String contentTypeID) {
        int sortOrder = Integer.MAX_VALUE;
        ICompletionProposalCategoriesConfigurationReader properties = CompletionProposoalCatigoriesConfigurationRegistry.getDefault().getReadableConfiguration(contentTypeID);
        if (properties != null) {
            sortOrder = properties.getDefaultPageSortOrder(this.fId);
        }
        return sortOrder;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean hasComputers() {
        List descriptors = CompletionProposalComputerRegistry.getDefault().getProposalComputerDescriptors();
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() != this) continue;
            return true;
        }
        return false;
    }

    public boolean hasComputers(String contentTypeID, String partitionTypeID) {
        List descriptors = CompletionProposalComputerRegistry.getDefault().getProposalComputerDescriptors(contentTypeID, partitionTypeID);
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() != this) continue;
            return true;
        }
        return false;
    }

    public boolean hasComputers(String contentTypeID) {
        List descriptors = CompletionProposalComputerRegistry.getDefault().getProposalComputerDescriptors(contentTypeID);
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() != this) continue;
            return true;
        }
        return false;
    }

    public List computeCompletionProposals(CompletionProposalInvocationContext context, String contentTypeID, String partitionTypeID, SubProgressMonitor monitor) {
        this.fLastError = null;
        ArrayList result = new ArrayList();
        ArrayList descriptors = new ArrayList(CompletionProposalComputerRegistry.getDefault().getProposalComputerDescriptors(contentTypeID, partitionTypeID));
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() == this) {
                result.addAll(desc.computeCompletionProposals(context, (IProgressMonitor)monitor));
            }
            if (this.fLastError != null || desc.getErrorMessage() == null) continue;
            this.fLastError = desc.getErrorMessage();
        }
        return result;
    }

    public List computeContextInformation(CompletionProposalInvocationContext context, String contentTypeID, String partitionTypeID, SubProgressMonitor monitor) {
        this.fLastError = null;
        ArrayList result = new ArrayList();
        ArrayList descriptors = new ArrayList(CompletionProposalComputerRegistry.getDefault().getProposalComputerDescriptors(contentTypeID, partitionTypeID));
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() == this && (this.isIncludedOnDefaultPage(contentTypeID) || this.isDisplayedOnOwnPage(contentTypeID))) {
                result.addAll(desc.computeContextInformation(context, (IProgressMonitor)monitor));
            }
            if (this.fLastError != null) continue;
            this.fLastError = desc.getErrorMessage();
        }
        return result;
    }

    public String getErrorMessage() {
        return this.fLastError;
    }

    public void sessionStarted() {
        ArrayList descriptors = new ArrayList(CompletionProposalComputerRegistry.getDefault().getProposalComputerDescriptors());
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() == this) {
                desc.sessionStarted();
            }
            if (this.fLastError != null) continue;
            this.fLastError = desc.getErrorMessage();
        }
    }

    public void sessionEnded() {
        ArrayList descriptors = new ArrayList(CompletionProposalComputerRegistry.getDefault().getProposalComputerDescriptors());
        for (CompletionProposalComputerDescriptor desc : descriptors) {
            if (desc.getCategory() == this) {
                desc.sessionEnded();
            }
            if (this.fLastError != null) continue;
            this.fLastError = desc.getErrorMessage();
        }
    }

    public String toString() {
        return String.valueOf(this.fId) + ": " + this.fName;
    }
}

