/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.phar.CRCableOutputStream;
import org.eclipse.php.internal.core.phar.IAchiveOutputEntry;
import org.eclipse.php.internal.core.phar.IAchiveOutputStream;
import org.eclipse.php.internal.core.phar.IStub;
import org.eclipse.php.internal.core.phar.NumberedBufferedOutputStream;
import org.eclipse.php.internal.core.phar.PharAchiveOutputEntry;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.core.phar.PharUtil;
import org.eclipse.php.internal.core.phar.SignatureBufferedOutputStream;
import org.eclipse.php.internal.core.tar.CBZip2OutputStreamForPhar;
import org.eclipse.php.internal.core.tar.CRCable;
import org.eclipse.php.internal.core.tar.GZIPOutputStreamForPhar;

public class PharBufferedOutputStream
implements IAchiveOutputStream {
    List<PharAchiveOutputEntry> entries = new ArrayList<PharAchiveOutputEntry>();
    PharAchiveOutputEntry currentEntry;
    boolean currentStart;
    SignatureBufferedOutputStream os;
    OutputStream currentOutputStream;
    OutputStream manifestOutputStream;
    OutputStream fileDescriptionOutputStream;
    NumberedBufferedOutputStream fileContentStream;
    int currentIndex = 0;
    private File fileContent;
    private File manifest;
    private File fileDescription;
    PharPackage pharPackage;
    int fileNumber = 0;

    public PharBufferedOutputStream(SignatureBufferedOutputStream fileContentStream2, PharPackage pharPackage) throws IOException {
        this.os = fileContentStream2;
        this.manifest = File.createTempFile("temp1", ".tmp");
        this.manifestOutputStream = new BufferedOutputStream(new FileOutputStream(this.manifest));
        this.fileDescription = File.createTempFile("temp2", ".tmp");
        this.fileDescriptionOutputStream = new BufferedOutputStream(new FileOutputStream(this.fileDescription));
        this.fileContent = File.createTempFile("temp3", ".tmp");
        this.fileContentStream = new NumberedBufferedOutputStream(new FileOutputStream(this.fileContent));
        this.pharPackage = pharPackage;
    }

    public void writeStub(IStub stub) throws IOException, CoreException {
        stub.write(this.os);
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    private void mergeFiles() throws IOException {
        this.fileDescriptionOutputStream.close();
        this.writeManifest();
        this.manifestOutputStream.close();
        this.fileContentStream.getInnerOutputStream().close();
        this.writeTempFileToStream(this.manifest);
        this.writeTempFileToStream(this.fileDescription);
        this.writeTempFileToStream(this.fileContent);
        this.manifest.delete();
        this.fileDescription.delete();
        this.fileContent.delete();
    }

    private void writeManifest() throws IOException {
        int aliasLength = 0;
        if (this.pharPackage.getAlias() != null) {
            aliasLength = this.pharPackage.getAlias().length();
        }
        int manifestLength = (int)((long)(18 + aliasLength) + this.fileDescription.length());
        this.writeInt(this.manifestOutputStream, manifestLength);
        this.writeInt(this.manifestOutputStream, this.fileNumber);
        this.manifestOutputStream.write(PharUtil.getStubVersionBytes(this.pharPackage.getStubVersion()));
        this.manifestOutputStream.write(PharUtil.getGlobalBitmap(this.pharPackage));
        this.writeInt(this.manifestOutputStream, aliasLength);
        if (aliasLength != 0) {
            this.writeString(this.manifestOutputStream, this.pharPackage.getAlias());
        }
        this.writeInt(this.manifestOutputStream, 0);
    }

    private void writeTempFileToStream(File file) throws IOException {
        try (BufferedInputStream contentStream = new BufferedInputStream(new FileInputStream(file));){
            int n;
            byte[] readBuffer = new byte[4096];
            while ((n = ((InputStream)contentStream).read(readBuffer)) > 0) {
                this.os.write(readBuffer, 0, n);
            }
        }
    }

    @Override
    public void putNextEntry(IAchiveOutputEntry output) throws IOException {
        assert (output instanceof PharAchiveOutputEntry);
        ++this.fileNumber;
        this.currentEntry = (PharAchiveOutputEntry)output;
        this.entries.add(this.currentEntry);
        this.currentStart = true;
    }

    private void setEntryInfo() throws IOException {
        this.currentEntry.setCompressedSize(this.fileContentStream.getCurrent() - this.currentIndex);
        this.currentEntry.setCrc(this.getCrc(this.currentOutputStream));
        this.currentIndex = this.fileContentStream.getCurrent();
    }

    private long getCrc(OutputStream currentOutputStream2) {
        return ((CRCable)((Object)currentOutputStream2)).getCrc();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.currentStart) {
            this.currentStart = false;
            if (this.currentEntry.getMethod() == 0) {
                this.currentOutputStream = this.fileContentStream;
            } else if (this.currentEntry.getMethod() == 2) {
                this.currentOutputStream = new CBZip2OutputStreamForPhar(this.fileContentStream);
            } else if (this.currentEntry.getMethod() == 1) {
                this.currentOutputStream = new GZIPOutputStreamForPhar(this.fileContentStream);
            }
            this.currentOutputStream = new CRCableOutputStream(this.currentOutputStream);
        }
        this.currentOutputStream.write(b, off, len);
    }

    public void closeEntry() throws IOException {
        this.currentOutputStream.close();
        this.setEntryInfo();
        this.writeCurrentEntry();
    }

    private void writeCurrentEntry() throws IOException {
        this.writeInt(this.fileDescriptionOutputStream, this.currentEntry.getName().length());
        this.writeString(this.fileDescriptionOutputStream, this.currentEntry.getName());
        this.writeInt(this.fileDescriptionOutputStream, (int)this.currentEntry.getSize());
        this.writeInt(this.fileDescriptionOutputStream, (int)this.currentEntry.getTime());
        this.writeInt(this.fileDescriptionOutputStream, (int)this.currentEntry.getCompressedSize());
        this.writeInt(this.fileDescriptionOutputStream, (int)this.currentEntry.getCrc());
        this.fileDescriptionOutputStream.write(PharUtil.getBitmapBytes(this.currentEntry));
        this.writeInt(this.fileDescriptionOutputStream, 0);
    }

    private void writeString(OutputStream os, String name) throws IOException {
        os.write(name.getBytes());
    }

    private void writeInt(OutputStream os, int i) throws IOException {
        this.writeShort(os, i & 0xFFFF);
        this.writeShort(os, i >> 16 & 0xFFFF);
    }

    private void writeShort(OutputStream os, int s) throws IOException {
        os.write((byte)(s & 0xFF));
        os.write((byte)(s >> 8 & 0xFF));
    }

    public void writeSignature() throws IOException {
        this.mergeFiles();
        this.os.flush();
        byte[] signature = this.os.getSignature();
        if (signature != null) {
            this.os.write(PharUtil.getWholeSignature(signature, this.pharPackage));
        }
    }
}

