/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.List;
import org.eclipse.draw2d.IFigure;

public class FocusTraverseManager {
    IFigure currentFocusOwner;

    private static IFigure findDeepestRightmostChildOf(IFigure fig) {
        while (!fig.getChildren().isEmpty()) {
            fig = fig.getChildren().get(fig.getChildren().size() - 1);
        }
        return fig;
    }

    public IFigure getNextFocusableFigure(IFigure root, IFigure prevFocus) {
        boolean found = false;
        IFigure nextFocus = prevFocus;
        if (prevFocus == null) {
            if (root.getChildren().isEmpty()) {
                return null;
            }
            nextFocus = root.getChildren().get(0);
            if (FocusTraverseManager.isFocusEligible(nextFocus)) {
                return nextFocus;
            }
        }
        int siblingPos = nextFocus.getParent().getChildren().indexOf(nextFocus);
        while (!found) {
            IFigure parent = nextFocus.getParent();
            List<? extends IFigure> siblings = parent.getChildren();
            if (!nextFocus.getChildren().isEmpty()) {
                nextFocus = nextFocus.getChildren().get(0);
                siblingPos = 0;
                if (!FocusTraverseManager.isFocusEligible(nextFocus)) continue;
                found = true;
                continue;
            }
            if (siblingPos < siblings.size() - 1) {
                if (!FocusTraverseManager.isFocusEligible(nextFocus = siblings.get(++siblingPos))) continue;
                found = true;
                continue;
            }
            boolean untraversedSiblingFound = false;
            while (!untraversedSiblingFound) {
                IFigure p = nextFocus.getParent();
                IFigure gp = p.getParent();
                if (gp != null) {
                    int parentSiblingCount = gp.getChildren().size();
                    int parentIndex = gp.getChildren().indexOf(p);
                    if (parentIndex < parentSiblingCount - 1) {
                        nextFocus = p.getParent().getChildren().get(parentIndex + 1);
                        siblingPos = parentIndex + 1;
                        untraversedSiblingFound = true;
                        if (!FocusTraverseManager.isFocusEligible(nextFocus)) continue;
                        found = true;
                        continue;
                    }
                    nextFocus = p;
                    continue;
                }
                nextFocus = null;
                untraversedSiblingFound = true;
                found = true;
            }
        }
        return nextFocus;
    }

    public IFigure getPreviousFocusableFigure(IFigure root, IFigure prevFocus) {
        if (prevFocus == null) {
            return null;
        }
        boolean found = false;
        IFigure nextFocus = prevFocus;
        while (!found) {
            IFigure parent = nextFocus.getParent();
            if (parent == null) {
                return null;
            }
            List<? extends IFigure> siblings = parent.getChildren();
            int siblingPos = siblings.indexOf(nextFocus);
            if (siblingPos != 0) {
                IFigure child = FocusTraverseManager.findDeepestRightmostChildOf(siblings.get(siblingPos - 1));
                if (FocusTraverseManager.isFocusEligible(child)) {
                    found = true;
                    nextFocus = child;
                    continue;
                }
                if (child.equals(nextFocus)) {
                    if (!FocusTraverseManager.isFocusEligible(nextFocus)) continue;
                    found = true;
                    continue;
                }
                nextFocus = child;
                continue;
            }
            nextFocus = parent;
            if (!FocusTraverseManager.isFocusEligible(nextFocus)) continue;
            found = true;
        }
        return nextFocus;
    }

    public IFigure getCurrentFocusOwner() {
        return this.currentFocusOwner;
    }

    private static boolean isFocusEligible(IFigure fig) {
        return fig != null && fig.isFocusTraversable() && fig.isShowing();
    }

    public void setCurrentFocusOwner(IFigure fig) {
        this.currentFocusOwner = fig;
    }
}

