/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.generics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.CollectionElementVariable2;

public class InferTypeArgumentsUpdate {
    private HashMap<ICompilationUnit, CuUpdate> fUpdates = new HashMap();

    public HashMap<ICompilationUnit, CuUpdate> getUpdates() {
        return this.fUpdates;
    }

    public void addDeclaration(CollectionElementVariable2 elementCv) {
        ICompilationUnit cu = elementCv.getCompilationUnit();
        if (cu == null) {
            return;
        }
        CuUpdate update = this.getUpdate(cu);
        update.fDeclarations.add(elementCv);
    }

    public void addCastToRemove(CastVariable2 castCv) {
        ICompilationUnit cu = castCv.getCompilationUnit();
        CuUpdate update = this.getUpdate(cu);
        update.fCastsToRemove.add(castCv);
    }

    private CuUpdate getUpdate(ICompilationUnit cu) {
        CuUpdate update;
        Assert.isNotNull((Object)cu);
        CuUpdate obj = this.fUpdates.get(cu);
        if (obj == null) {
            update = new CuUpdate();
            this.fUpdates.put(cu, update);
        } else {
            update = obj;
        }
        return update;
    }

    public static class CuUpdate {
        private List<CollectionElementVariable2> fDeclarations = new ArrayList<CollectionElementVariable2>();
        private List<CastVariable2> fCastsToRemove = new ArrayList<CastVariable2>();

        public List<CollectionElementVariable2> getDeclarations() {
            return this.fDeclarations;
        }

        public List<CastVariable2> getCastsToRemove() {
            return this.fCastsToRemove;
        }
    }
}

