/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.update.configurator;

import java.net.URL;
import org.eclipse.pde.internal.core.update.configurator.IConfigurationConstants;
import org.eclipse.pde.internal.core.update.configurator.SiteEntry;

class FeatureEntry
implements IConfigurationConstants {
    private final String id;
    private final String version;
    private final String pluginVersion;
    private final String application;
    private final URL[] root;
    private final boolean primary;
    private final String pluginIdentifier;
    private String url;
    private SiteEntry site;

    public FeatureEntry(String id, String version, String pluginIdentifier, String pluginVersion, boolean primary, String application, URL[] root) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.version = version;
        this.pluginVersion = pluginVersion;
        this.pluginIdentifier = pluginIdentifier;
        this.primary = primary;
        this.application = application;
        this.root = root == null ? new URL[]{} : root;
    }

    public FeatureEntry(String id, String version, String pluginVersion, boolean primary, String application, URL[] root) {
        this(id, version, id, pluginVersion, primary, application, root);
    }

    public void setSite(SiteEntry site) {
        this.site = site;
    }

    public SiteEntry getSite() {
        return this.site;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public String getFeatureIdentifier() {
        return this.id;
    }

    public String getFeatureVersion() {
        return this.version;
    }

    public String getFeaturePluginVersion() {
        return this.pluginVersion != null && this.pluginVersion.length() > 0 ? this.pluginVersion : null;
    }

    public String getFeaturePluginIdentifier() {
        return this.pluginIdentifier != null && this.pluginIdentifier.length() > 0 ? this.pluginIdentifier : this.id;
    }

    public String getFeatureApplication() {
        return this.application;
    }

    public URL[] getFeatureRootURLs() {
        return this.root;
    }

    public boolean canBePrimary() {
        return this.primary;
    }

    public String getApplication() {
        return this.application;
    }

    public String getId() {
        return this.id;
    }
}

