/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;

public class ThreadEventHandler
extends DebugEventHandler {
    private final Set<IThread> fThreadQueue = new LinkedHashSet<IThread>();
    private final Map<IThread, IStackFrame> fLastTopFrame = new HashMap<IThread, IStackFrame>();

    public ThreadEventHandler(AbstractModelProxy proxy) {
        super(proxy);
    }

    @Override
    public synchronized void dispose() {
        this.fLastTopFrame.clear();
        this.fThreadQueue.clear();
        super.dispose();
    }

    @Override
    protected void handleSuspend(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        if (event.isEvaluation()) {
            ModelDelta delta = this.buildRootDelta();
            ModelDelta node = this.addPathToThread(delta, thread);
            node = node.addNode(thread, 2048);
            try {
                IStackFrame frame = thread.getTopStackFrame();
                if (frame != null) {
                    int flag = 0;
                    if (event.getDetail() == 64) {
                        flag |= 0x400;
                    } else if (event.getDetail() == 128) {
                        flag |= 0x800;
                    }
                    node.addNode(frame, flag);
                    this.fireDelta(delta);
                }
            }
            catch (DebugException debugException) {}
        } else {
            this.queueSuspendedThread(event);
            int extras = 2048;
            switch (event.getDetail()) {
                case 16: {
                    extras = 0x1100000;
                    break;
                }
                case 32: {
                    extras = 0x100000;
                    break;
                }
            }
            this.waitForProxyInitialization();
            this.fireDeltaUpdatingSelectedFrame(thread, extras, event);
        }
    }

    private void waitForProxyInitialization() {
        AbstractModelProxy modelProxy = this.getModelProxy();
        if (modelProxy == null) {
            return;
        }
        Job[] proxyInitJobs = Job.getJobManager().find((Object)modelProxy);
        while (proxyInitJobs.length > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                break;
            }
            proxyInitJobs = Job.getJobManager().find((Object)modelProxy);
        }
    }

    private boolean isEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    protected void handleResume(DebugEvent event) {
        IThread thread = this.removeSuspendedThread(event);
        this.fireDeltaAndClearTopFrame(thread, 0x200C00);
        thread = this.getNextSuspendedThread();
        if (thread != null) {
            this.fireDeltaUpdatingSelectedFrame(thread, 0x1000000, event);
        }
    }

    @Override
    protected void handleCreate(DebugEvent event) {
        this.fireDeltaAndClearTopFrame((IThread)event.getSource(), 2049);
    }

    @Override
    protected void handleTerminate(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        IDebugTarget target = thread.getDebugTarget();
        if (!target.isTerminated() && !target.isDisconnected()) {
            this.fireDeltaAndClearTopFrame(thread, 2);
        }
    }

    @Override
    protected void handleChange(DebugEvent event) {
        if (event.getDetail() == 256) {
            this.fireDeltaUpdatingThread((IThread)event.getSource(), 2048);
        } else {
            this.fireDeltaUpdatingThread((IThread)event.getSource(), 1024);
        }
    }

    @Override
    protected void handleLateSuspend(DebugEvent suspend, DebugEvent resume) {
        IThread thread = this.queueSuspendedThread(suspend);
        if (suspend.isEvaluation() && suspend.getDetail() == 128) {
            ModelDelta delta = this.buildRootDelta();
            ModelDelta node = this.addPathToThread(delta, thread);
            node = node.addNode(thread, 2048);
            try {
                IStackFrame frame = thread.getTopStackFrame();
                if (frame != null) {
                    node.addNode(frame, 2048);
                    this.fireDelta(delta);
                }
            }
            catch (DebugException debugException) {}
        } else {
            this.fireDeltaUpdatingSelectedFrame(thread, 0x100800, suspend);
        }
    }

    @Override
    protected void handleSuspendTimeout(DebugEvent event) {
        IThread thread = this.removeSuspendedThread(event);
        this.fireDeltaUpdatingThread(thread, 2048);
    }

    protected ModelDelta buildRootDelta() {
        return new ModelDelta(this.getLaunchManager(), 0);
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ModelDelta addPathToThread(ModelDelta delta, IThread thread) {
        ILaunch launch = thread.getLaunch();
        Object[] children = launch.getChildren();
        delta = delta.addNode(launch, this.indexOf(this.getLaunchManager().getLaunches(), launch), 0, children.length);
        IDebugTarget debugTarget = thread.getDebugTarget();
        int numThreads = -1;
        try {
            numThreads = debugTarget.getThreads().length;
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return delta.addNode(debugTarget, this.indexOf(children, debugTarget), 0, numThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeltaAndClearTopFrame(IThread thread, int flags) {
        ModelDelta delta = this.buildRootDelta();
        ModelDelta node = this.addPathToThread(delta, thread);
        node.addNode((Object)thread, this.indexOf(thread), flags);
        ThreadEventHandler threadEventHandler = this;
        synchronized (threadEventHandler) {
            this.fLastTopFrame.remove(thread);
        }
        this.fireDelta(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeltaUpdatingSelectedFrame(IThread thread, int flags, DebugEvent event) {
        ModelDelta delta = this.buildRootDelta();
        ModelDelta node = this.addPathToThread(delta, thread);
        IStackFrame prev = null;
        ThreadEventHandler threadEventHandler = this;
        synchronized (threadEventHandler) {
            prev = this.fLastTopFrame.get(thread);
        }
        IStackFrame frame = null;
        try {
            Object frameToSelect = event.getData();
            frame = frameToSelect == null || !(frameToSelect instanceof IStackFrame) ? thread.getTopStackFrame() : (IStackFrame)frameToSelect;
        }
        catch (DebugException frameToSelect) {
            // empty catch block
        }
        int threadIndex = this.indexOf(thread);
        int childCount = this.childCount(thread);
        if (this.isEqual(frame, prev)) {
            if (frame == null) {
                if (thread.isSuspended()) {
                    try {
                        frame = thread.getTopStackFrame();
                    }
                    catch (DebugException debugException) {
                        // empty catch block
                    }
                    if (frame == null) {
                        int threadNodeFlags = flags | 0x800 | 0x200000;
                        node = node.addNode(thread, threadIndex, threadNodeFlags, childCount);
                    } else {
                        node = node.addNode(thread, threadIndex, flags, childCount);
                    }
                }
            } else {
                node = node.addNode(thread, threadIndex, flags, childCount);
            }
        } else {
            if (event.getDetail() == 8) {
                if (prev == null) {
                    flags |= 0x100000;
                } else if (frame == null) {
                    return;
                }
            }
            node = node.addNode(thread, threadIndex, flags | 0x400, childCount);
        }
        if (frame != null) {
            node.addNode(frame, this.indexOf(frame), 0x200800, this.childCount(frame));
        }
        ThreadEventHandler threadEventHandler2 = this;
        synchronized (threadEventHandler2) {
            if (!this.isDisposed()) {
                this.fLastTopFrame.put(thread, frame);
            }
        }
        this.fireDelta(delta);
    }

    protected int indexOf(IThread thread) {
        try {
            return this.indexOf(thread.getDebugTarget().getThreads(), thread);
        }
        catch (DebugException debugException) {
            return -1;
        }
    }

    protected int indexOf(IStackFrame frame) {
        try {
            return this.indexOf(frame.getThread().getStackFrames(), frame);
        }
        catch (DebugException e) {
            return -1;
        }
    }

    protected int childCount(IThread thread) {
        try {
            return thread.getStackFrames().length;
        }
        catch (DebugException debugException) {
            return -1;
        }
    }

    protected int childCount(IStackFrame frame) {
        return 0;
    }

    private void fireDeltaUpdatingThread(IThread thread, int flags) {
        ModelDelta delta = this.buildRootDelta();
        ModelDelta node = this.addPathToThread(delta, thread);
        node = node.addNode(thread, flags);
        this.fireDelta(delta);
    }

    @Override
    protected boolean handlesEvent(DebugEvent event) {
        return event.getSource() instanceof IThread;
    }

    protected synchronized IThread queueSuspendedThread(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        if (!this.isDisposed()) {
            this.fThreadQueue.add(thread);
        }
        return thread;
    }

    protected synchronized IThread removeSuspendedThread(DebugEvent event) {
        IThread thread = (IThread)event.getSource();
        this.fThreadQueue.remove(thread);
        return thread;
    }

    protected synchronized IThread queueSuspendedThread(IThread thread) {
        if (!this.isDisposed()) {
            this.fThreadQueue.add(thread);
        }
        return thread;
    }

    protected synchronized void removeQueuedThread(IThread thread) {
        this.fThreadQueue.remove(thread);
    }

    protected synchronized IThread getNextSuspendedThread() {
        if (!this.fThreadQueue.isEmpty()) {
            return this.fThreadQueue.iterator().next();
        }
        return null;
    }
}

