/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.utils.StringUtils;

public class DTDElementDecl
extends DTDDeclNode {
    private static final Predicate<Character> isValidChar = c -> Character.isJavaIdentifierPart(c.charValue()) || c.charValue() == '-';
    public DTDDeclParameter category;
    public DTDDeclParameter content;

    public DTDElementDecl(int start, int end) {
        super(start, end);
        this.setDeclType(start + 2, start + 9);
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    public String getCategory() {
        return this.category != null ? this.category.getParameter() : null;
    }

    public void setCategory(int start, int end) {
        this.category = this.addNewParameter(start, end);
    }

    public String getContent() {
        return this.content != null ? this.content.getParameter() : null;
    }

    public void setContent(int start, int end) {
        this.content = this.addNewParameter(start, end);
    }

    @Override
    public short getNodeType() {
        return 101;
    }

    public int getEndElementTag() {
        return this.getStart() + "<!ELEMENT".length();
    }

    public DTDDeclParameter getParameterAt(int offset) {
        if (this.isInNameParameter(offset)) {
            return null;
        }
        String text = this.getOwnerDocument().getText();
        int paramStart = StringUtils.findStartWord(text, offset, isValidChar);
        int paramEnd = StringUtils.findEndWord(text, offset, isValidChar);
        if (paramStart == -1 || paramEnd == -1) {
            return null;
        }
        return new DTDDeclParameter(this, paramStart, paramEnd);
    }

    @Override
    public DTDDeclParameter getReferencedElementNameAt(int offset) {
        return this.getParameterAt(offset);
    }

    public void collectParameters(DTDDeclParameter target, BiConsumer<DTDDeclParameter, DTDDeclParameter> collector) {
        DTDDeclParameter name = this.getNameParameter();
        if (name == null) {
            return;
        }
        int start = name.getEnd();
        int end = this.getEnd();
        String text = this.getOwnerDocument().getText();
        int wordStart = -1;
        int wordEnd = -1;
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (isValidChar.test(Character.valueOf(c))) {
                if (wordStart == -1) {
                    wordStart = i;
                }
            } else if (wordStart != -1) {
                wordEnd = i;
            }
            if (wordStart == -1 || wordEnd == -1) continue;
            boolean check = DTDElementDecl.isMatchName(target.getParameter(), text, wordStart, wordEnd);
            if (check) {
                collector.accept(new DTDDeclParameter(this, wordStart, wordEnd), target);
            }
            wordStart = -1;
            wordEnd = -1;
        }
    }

    private static boolean isMatchName(String searchWord, String text, int wordStart, int wordEnd) {
        int length = wordEnd - wordStart;
        if (searchWord.length() != length) {
            return false;
        }
        for (int j = 0; j < length; ++j) {
            if (searchWord.charAt(j) == text.charAt(wordStart + j)) continue;
            return false;
        }
        return true;
    }
}

