/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.resolver.Blame;
import org.apache.felix.resolver.Candidates;
import org.apache.felix.resolver.EnhancedExecutor;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.Packages;
import org.apache.felix.resolver.PermutationType;
import org.apache.felix.resolver.ResolutionError;
import org.apache.felix.resolver.ResolveSession;
import org.apache.felix.resolver.UseConstraintError;
import org.apache.felix.resolver.UsedBlames;
import org.apache.felix.resolver.Util;
import org.apache.felix.resolver.WireCandidate;
import org.apache.felix.resolver.WrappedCapability;
import org.apache.felix.resolver.WrappedRequirement;
import org.apache.felix.resolver.util.ArrayMap;
import org.apache.felix.resolver.util.OpenHashMap;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;

public class PackageSpaces {
    static ResolutionError checkConsistency(ResolveSession session, Candidates allCandidates, Map<Resource, ResolutionError> currentFaultyResources, Logger logger) {
        Map<Resource, Resource> allhosts = allCandidates.getRootHosts();
        Map<Resource, Packages> resourcePkgMap = PackageSpaces.calculatePackageSpaces(session, allCandidates, allhosts.values(), logger);
        ResolutionError error = null;
        OpenHashMap<Resource, Object> resultCache = new OpenHashMap<Resource, Object>(resourcePkgMap.size());
        for (Map.Entry<Resource, Resource> entry : allhosts.entrySet()) {
            ResolutionError rethrow = PackageSpaces.checkPackageSpaceConsistency(session, entry.getValue(), allCandidates, session.isDynamic(), resourcePkgMap, resultCache, logger);
            if (session.isCancelled()) {
                return null;
            }
            if (rethrow == null) continue;
            Resource faultyResource = entry.getKey();
            for (Requirement faultyReq : rethrow.getUnresolvedRequirements()) {
                if (!(faultyReq instanceof WrappedRequirement)) continue;
                faultyResource = ((WrappedRequirement)faultyReq).getDeclaredRequirement().getResource();
                break;
            }
            currentFaultyResources.put(faultyResource, rethrow);
            error = rethrow;
        }
        return error;
    }

    private static Map<Resource, Packages> calculatePackageSpaces(final ResolveSession session, final Candidates allCandidates, Collection<Resource> hosts, final Logger logger) {
        Packages packages;
        Resource resource;
        EnhancedExecutor executor = new EnhancedExecutor(session.getExecutor());
        final ConcurrentHashMap allWireCandidates = new ConcurrentHashMap();
        ConcurrentHashMap tasks = new ConcurrentHashMap(allCandidates.getNbResources());
        for (Resource resource2 : hosts) {
            class Computer
            implements Runnable {
                final Resource resource;
                private final /* synthetic */ ResolveSession val$session;
                private final /* synthetic */ Candidates val$allCandidates;
                private final /* synthetic */ Map val$allWireCandidates;
                private final /* synthetic */ ConcurrentMap val$tasks;
                private final /* synthetic */ EnhancedExecutor val$executor;

                public Computer(Resource resource, ResolveSession resolveSession, Candidates candidates, Map map, ConcurrentMap concurrentMap, EnhancedExecutor enhancedExecutor) {
                    this.val$session = resolveSession;
                    this.val$allCandidates = candidates;
                    this.val$allWireCandidates = map;
                    this.val$tasks = concurrentMap;
                    this.val$executor = enhancedExecutor;
                    this.resource = resource;
                }

                @Override
                public void run() {
                    List wireCandidates = PackageSpaces.getWireCandidates(this.val$session, this.val$allCandidates, this.resource);
                    this.val$allWireCandidates.put(this.resource, wireCandidates);
                    for (WireCandidate w : wireCandidates) {
                        Computer c;
                        Resource u = w.capability.getResource();
                        if (this.val$tasks.containsKey(u) || this.val$tasks.putIfAbsent(u, c = new Computer(u, this.val$session, this.val$allCandidates, this.val$allWireCandidates, this.val$tasks, this.val$executor)) != null) continue;
                        this.val$executor.execute(c);
                    }
                }
            }
            executor.execute(new Computer(resource2, session, allCandidates, allWireCandidates, tasks, executor));
        }
        executor.await();
        final OpenHashMap<Resource, Packages> allPackages = new OpenHashMap<Resource, Packages>(allCandidates.getNbResources());
        for (final Resource resource3 : allWireCandidates.keySet()) {
            final Packages packages2 = new Packages(resource3);
            allPackages.put(resource3, packages2);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    PackageSpaces.calculateExportedPackages(session, allCandidates, resource3, packages2.m_exportedPkgs, packages2.m_substitePkgs);
                }
            });
        }
        executor.await();
        for (final Resource resource4 : allWireCandidates.keySet()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    PackageSpaces.getPackages(session, allCandidates, allWireCandidates, allPackages, resource4, (Packages)allPackages.get(resource4));
                }
            });
        }
        executor.await();
        for (Map.Entry entry : allPackages.fast()) {
            resource = (Resource)entry.getKey();
            packages = (Packages)entry.getValue();
            if (packages.m_requiredPkgs.isEmpty()) continue;
            PackageSpaces.getPackageSourcesInternal(session, allPackages, resource, packages);
        }
        for (Map.Entry entry : allPackages.fast()) {
            resource = (Resource)entry.getKey();
            packages = (Packages)entry.getValue();
            if (!packages.m_sources.isEmpty()) continue;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    PackageSpaces.getPackageSourcesInternal(session, allPackages, resource, packages);
                }
            });
        }
        executor.await();
        for (final Resource resource5 : allWireCandidates.keySet()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    PackageSpaces.computeUses(session, allWireCandidates, allPackages, resource5, logger);
                }
            });
        }
        executor.await();
        return allPackages;
    }

    private static ResolutionError checkPackageSpaceConsistency(ResolveSession session, Resource resource, Candidates allCandidates, boolean dynamic, Map<Resource, Packages> resourcePkgMap, Map<Resource, Object> resultCache, Logger logger) {
        OpenHashMap<String, List<Blame>> allImportRequirePkgs;
        ArrayMap<Set<Capability>, UsedBlames> pkgBlames;
        if (!dynamic && session.getContext().getWirings().containsKey(resource)) {
            return null;
        }
        Object cache = resultCache.get(resource);
        if (cache != null) {
            return cache instanceof ResolutionError ? (ResolutionError)cache : null;
        }
        Packages pkgs = resourcePkgMap.get(resource);
        ResolutionError rethrow = null;
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.fast()) {
            String pkgName = entry.getKey();
            List<Blame> blames = entry.getValue();
            if (blames.size() <= 1) continue;
            Object sourceBlame = null;
            for (Blame blame : blames) {
                if (sourceBlame == null) {
                    sourceBlame = blame;
                    continue;
                }
                if (((Blame)sourceBlame).m_cap.getResource().equals(blame.m_cap.getResource())) continue;
                session.addPermutation(PermutationType.IMPORT, allCandidates.permutate(blame.m_reqs.get(0)));
                session.addPermutation(PermutationType.IMPORT, allCandidates.permutate(((Blame)sourceBlame).m_reqs.get(0)));
                rethrow = new UseConstraintError(session.getContext(), allCandidates, resource, pkgName, (Blame)sourceBlame, blame);
                if (logger.isDebugEnabled()) {
                    logger.debug("Candidate permutation failed due to a conflict with a fragment import; will try another if possible. (" + rethrow.getMessage() + ")");
                }
                return rethrow;
            }
        }
        AtomicReference<Candidates> permRef1 = new AtomicReference<Candidates>();
        AtomicReference<Candidates> permRef2 = new AtomicReference<Candidates>();
        Set mutated = null;
        for (Map.Entry<String, Blame> entry : pkgs.m_exportedPkgs.fast()) {
            String pkgName = entry.getKey();
            Blame exportBlame = entry.getValue();
            pkgBlames = pkgs.m_usedPkgs.get(pkgName);
            if (pkgBlames == null) continue;
            for (UsedBlames usedBlames : pkgBlames.values()) {
                if (PackageSpaces.isCompatible(exportBlame, usedBlames.m_caps, resourcePkgMap)) continue;
                mutated = mutated != null ? mutated : new HashSet();
                rethrow = PackageSpaces.permuteUsedBlames(session, rethrow, allCandidates, resource, pkgName, null, usedBlames, permRef1, permRef2, mutated);
            }
            if (rethrow == null) continue;
            if (!mutated.isEmpty()) {
                session.addPermutation(PermutationType.USES, (Candidates)permRef1.get());
                session.addPermutation(PermutationType.USES, (Candidates)permRef2.get());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Candidate permutation failed due to a conflict between an export and import; will try another if possible. (" + rethrow.getMessage() + ")");
            }
            return rethrow;
        }
        if (pkgs.m_requiredPkgs.isEmpty()) {
            allImportRequirePkgs = pkgs.m_importedPkgs;
        } else {
            allImportRequirePkgs = new OpenHashMap(pkgs.m_requiredPkgs.size() + pkgs.m_importedPkgs.size());
            allImportRequirePkgs.putAll(pkgs.m_requiredPkgs);
            allImportRequirePkgs.putAll(pkgs.m_importedPkgs);
        }
        for (Map.Entry<String, List<Blame>> entry : allImportRequirePkgs.fast()) {
            String pkgName = entry.getKey();
            pkgBlames = pkgs.m_usedPkgs.get(pkgName);
            if (pkgBlames == null) continue;
            List<Blame> requirementBlames = entry.getValue();
            for (UsedBlames usedBlames : pkgBlames.values()) {
                if (!PackageSpaces.isCompatible(requirementBlames, usedBlames.m_caps, resourcePkgMap)) {
                    mutated = mutated != null ? mutated : new HashSet();
                    Blame requirementBlame = requirementBlames.get(0);
                    rethrow = PackageSpaces.permuteUsedBlames(session, rethrow, allCandidates, resource, pkgName, requirementBlame, usedBlames, permRef1, permRef2, mutated);
                }
                if (rethrow == null) continue;
                if (!mutated.isEmpty()) {
                    session.addPermutation(PermutationType.USES, permRef1.get());
                    session.addPermutation(PermutationType.USES, permRef2.get());
                }
                for (Blame requirementBlame : requirementBlames) {
                    Requirement req = requirementBlame.m_reqs.get(0);
                    if (mutated.contains(req)) continue;
                    session.permutateIfNeeded(PermutationType.IMPORT, req, allCandidates);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Candidate permutation failed due to a conflict between imports; will try another if possible. (" + rethrow.getMessage() + ")");
                }
                return rethrow;
            }
        }
        resultCache.put(resource, Boolean.TRUE);
        long permCount = session.getPermutationCount();
        for (Requirement req : resource.getRequirements(null)) {
            Capability cap = allCandidates.getFirstCandidate(req);
            if (cap == null || resource.equals(cap.getResource())) continue;
            rethrow = PackageSpaces.checkPackageSpaceConsistency(session, cap.getResource(), allCandidates, false, resourcePkgMap, resultCache, logger);
            if (session.isCancelled()) {
                return null;
            }
            if (rethrow == null) continue;
            if (permCount == session.getPermutationCount()) {
                session.addPermutation(PermutationType.IMPORT, allCandidates.permutate(req));
            }
            return rethrow;
        }
        return null;
    }

    private static List<WireCandidate> getWireCandidates(ResolveSession session, Candidates allCandidates, Resource resource) {
        ArrayList<WireCandidate> wireCandidates = new ArrayList<WireCandidate>(256);
        Wiring wiring = session.getContext().getWirings().get(resource);
        if (wiring != null) {
            for (Wire wire : wiring.getRequiredResourceWires(null)) {
                Capability c;
                Requirement r = wire.getRequirement();
                if (!r.getResource().equals(wire.getRequirer()) || Util.isDynamic(r)) {
                    r = new WrappedRequirement(wire.getRequirer(), r);
                }
                if (!(c = wire.getCapability()).getResource().equals(wire.getProvider())) {
                    c = new WrappedCapability(wire.getProvider(), c);
                }
                wireCandidates.add(new WireCandidate(r, c));
            }
            Requirement dynamicReq = session.getDynamicRequirement();
            if (dynamicReq != null && resource.equals(session.getDynamicHost())) {
                Capability cap = allCandidates.getFirstCandidate(dynamicReq);
                wireCandidates.add(new WireCandidate(dynamicReq, cap));
            }
        } else {
            for (Requirement req : resource.getRequirements(null)) {
                Capability cap2;
                List<Capability> candCaps;
                if (Util.isDynamic(req) || (candCaps = allCandidates.getCandidates(req)) == null) continue;
                if (Util.isMultiple(req)) {
                    for (Capability cap2 : candCaps) {
                        wireCandidates.add(new WireCandidate(req, cap2));
                    }
                    continue;
                }
                cap2 = candCaps.get(0);
                wireCandidates.add(new WireCandidate(req, cap2));
            }
        }
        return wireCandidates;
    }

    private static ResolutionError permuteUsedBlames(ResolveSession session, ResolutionError rethrow, Candidates allCandidates, Resource resource, String pkgName, Blame requirementBlame, UsedBlames usedBlames, AtomicReference<Candidates> permRef1, AtomicReference<Candidates> permRef2, Set<Requirement> mutated) {
        block0: for (Blame usedBlame : usedBlames.m_blames) {
            Candidates perm1;
            if (session.checkMultiple(usedBlames, usedBlame, allCandidates)) continue;
            if (rethrow == null) {
                rethrow = requirementBlame == null ? new UseConstraintError(session.getContext(), allCandidates, resource, pkgName, usedBlame) : new UseConstraintError(session.getContext(), allCandidates, resource, pkgName, requirementBlame, usedBlame);
            }
            if ((perm1 = permRef1.get()) == null) {
                perm1 = allCandidates.copy();
                permRef1.set(perm1);
            }
            int reqIdx = usedBlame.m_reqs.size() - 1;
            while (reqIdx >= 0) {
                Requirement req = usedBlame.m_reqs.get(reqIdx);
                if (PackageSpaces.permuteUsedBlameRequirement(req, mutated, perm1)) break;
                --reqIdx;
            }
            Candidates perm2 = permRef2.get();
            if (perm2 == null) {
                perm2 = allCandidates.copy();
                permRef2.set(perm2);
            }
            int reqIdx2 = 0;
            while (reqIdx2 < usedBlame.m_reqs.size()) {
                Requirement req = usedBlame.m_reqs.get(reqIdx2);
                if (PackageSpaces.permuteUsedBlameRequirement(req, mutated, perm2)) continue block0;
                ++reqIdx2;
            }
        }
        return rethrow;
    }

    private static boolean permuteUsedBlameRequirement(Requirement req, Set<Requirement> mutated, Candidates permutation) {
        if (Util.isMultiple(req)) {
            return false;
        }
        if (mutated.contains(req)) {
            return true;
        }
        if (permutation.canRemoveCandidate(req)) {
            permutation.removeFirstCandidate(req);
            mutated.add(req);
            return true;
        }
        return false;
    }

    private static boolean isCompatible(Blame currentBlame, Set<Capability> candSources, Map<Resource, Packages> resourcePkgMap) {
        if (candSources.contains(currentBlame.m_cap)) {
            return true;
        }
        Set<Capability> currentSources = PackageSpaces.getPackageSources(currentBlame.m_cap, resourcePkgMap);
        return currentSources.containsAll(candSources) || candSources.containsAll(currentSources);
    }

    private static boolean isCompatible(List<Blame> currentBlames, Set<Capability> candSources, Map<Resource, Packages> resourcePkgMap) {
        int size = currentBlames.size();
        switch (size) {
            case 0: {
                return true;
            }
            case 1: {
                return PackageSpaces.isCompatible(currentBlames.get(0), candSources, resourcePkgMap);
            }
        }
        HashSet<Capability> currentSources = new HashSet<Capability>(currentBlames.size());
        for (Blame currentBlame : currentBlames) {
            Set<Capability> blameSources = PackageSpaces.getPackageSources(currentBlame.m_cap, resourcePkgMap);
            currentSources.addAll(blameSources);
        }
        return currentSources.containsAll(candSources) || candSources.containsAll(currentSources);
    }

    public static Set<Capability> getPackageSources(Capability cap, Map<Resource, Packages> resourcePkgMap) {
        Resource resource = cap.getResource();
        if (resource == null) {
            return new HashSet<Capability>();
        }
        OpenHashMap<Capability, Set<Capability>> sources = resourcePkgMap.get((Object)resource).m_sources;
        if (sources == null) {
            return new HashSet<Capability>();
        }
        Set<Capability> packageSources = sources.get(cap);
        if (packageSources == null) {
            return new HashSet<Capability>();
        }
        return packageSources;
    }

    /*
     * WARNING - void declaration
     */
    private static void getPackageSourcesInternal(ResolveSession session, Map<Resource, Packages> resourcePkgMap, Resource resource, Packages packages) {
        String pkgName;
        Wiring wiring = session.getContext().getWirings().get(resource);
        List<Capability> caps = wiring != null ? wiring.getResourceCapabilities(null) : resource.getCapabilities(null);
        OpenHashMap<String, Set<Capability>> pkgs = new OpenHashMap<String, Set<Capability>>(caps.size()){

            @Override
            public Set<Capability> compute(String pkgName) {
                return new HashSet<Capability>();
            }
        };
        OpenHashMap<Capability, Set<Capability>> sources = packages.m_sources;
        for (Capability capability : caps) {
            if (capability.getNamespace().equals("osgi.wiring.package")) {
                void var8_9;
                pkgName = (String)capability.getAttributes().get("osgi.wiring.package");
                Set pkgCaps = (Set)pkgs.getOrCompute(pkgName);
                if (!resource.equals(capability.getResource())) {
                    WrappedCapability wrappedCapability = new WrappedCapability(resource, capability);
                }
                sources.put((Capability)var8_9, pkgCaps);
                pkgCaps.add(var8_9);
                continue;
            }
            String uses = capability.getDirectives().get("uses");
            if (uses != null && uses.length() > 0) {
                sources.put(capability, Collections.singleton(capability));
                continue;
            }
            sources.put(capability, Collections.emptySet());
        }
        for (Map.Entry entry : pkgs.fast()) {
            pkgName = (String)entry.getKey();
            List<Blame> required = packages.m_requiredPkgs.get(pkgName);
            if (required == null) continue;
            Set srcs = (Set)entry.getValue();
            for (Blame blame : required) {
                Capability bcap = blame.m_cap;
                if (!srcs.add(bcap)) continue;
                Resource capResource = bcap.getResource();
                Packages capPackages = resourcePkgMap.get(capResource);
                Set<Capability> additional = capPackages.m_sources.get(bcap);
                if (additional == null) {
                    PackageSpaces.getPackageSourcesInternal(session, resourcePkgMap, capResource, capPackages);
                    additional = capPackages.m_sources.get(bcap);
                }
                srcs.addAll(additional);
            }
        }
    }

    private static Packages getPackages(ResolveSession session, Candidates allCandidates, Map<Resource, List<WireCandidate>> allWireCandidates, Map<Resource, Packages> allPackages, Resource resource, Packages resourcePkgs) {
        for (WireCandidate wire : allWireCandidates.get(resource)) {
            String pkgName;
            if (Util.isDynamic(wire.requirement) && (resourcePkgs.m_exportedPkgs.containsKey(pkgName = (String)wire.capability.getAttributes().get("osgi.wiring.package")) || resourcePkgs.m_importedPkgs.containsKey(pkgName) || resourcePkgs.m_requiredPkgs.containsKey(pkgName))) {
                throw new IllegalArgumentException("Resource " + resource + " cannot dynamically import package '" + pkgName + "' since it already has access to it.");
            }
            PackageSpaces.mergeCandidatePackages(session, allPackages, allCandidates, resourcePkgs, wire.requirement, wire.capability, new HashSet<Capability>(), new HashSet<Resource>());
        }
        return resourcePkgs;
    }

    private static void mergeCandidatePackages(ResolveSession session, Map<Resource, Packages> resourcePkgMap, Candidates allCandidates, Packages packages, Requirement currentReq, Capability candCap, Set<Capability> capabilityCycles, Set<Resource> visitedRequiredBundles) {
        block9: {
            Wiring candWiring;
            block8: {
                if (!capabilityCycles.add(candCap)) {
                    return;
                }
                if (!candCap.getNamespace().equals("osgi.wiring.package")) break block8;
                PackageSpaces.mergeCandidatePackage(packages.m_importedPkgs, currentReq, candCap);
                break block9;
            }
            if (!candCap.getNamespace().equals("osgi.wiring.bundle")) break block9;
            if (visitedRequiredBundles.add(candCap.getResource())) {
                for (Blame blame : resourcePkgMap.get((Object)candCap.getResource()).m_exportedPkgs.values()) {
                    PackageSpaces.mergeCandidatePackage(packages.m_requiredPkgs, currentReq, blame.m_cap);
                }
                for (Blame blame : resourcePkgMap.get((Object)candCap.getResource()).m_substitePkgs.values()) {
                    PackageSpaces.mergeCandidatePackage(packages.m_requiredPkgs, currentReq, blame.m_cap);
                }
            }
            if ((candWiring = session.getContext().getWirings().get(candCap.getResource())) != null) {
                for (Wire w : candWiring.getRequiredResourceWires(null)) {
                    if (!w.getRequirement().getNamespace().equals("osgi.wiring.bundle") || !Util.isReexport(w.getRequirement())) continue;
                    PackageSpaces.mergeCandidatePackages(session, resourcePkgMap, allCandidates, packages, currentReq, w.getCapability(), capabilityCycles, visitedRequiredBundles);
                }
            } else {
                for (Requirement req : candCap.getResource().getRequirements(null)) {
                    Capability cap;
                    if (!req.getNamespace().equals("osgi.wiring.bundle") || !Util.isReexport(req) || (cap = allCandidates.getFirstCandidate(req)) == null) continue;
                    PackageSpaces.mergeCandidatePackages(session, resourcePkgMap, allCandidates, packages, currentReq, cap, capabilityCycles, visitedRequiredBundles);
                }
            }
        }
    }

    private static void mergeCandidatePackage(OpenHashMap<String, List<Blame>> packages, Requirement currentReq, Capability candCap) {
        if (candCap.getNamespace().equals("osgi.wiring.package")) {
            String pkgName = (String)candCap.getAttributes().get("osgi.wiring.package");
            List<Requirement> blameReqs = Collections.singletonList(currentReq);
            List<Blame> blames = packages.getOrCompute(pkgName);
            blames.add(new Blame(candCap, blameReqs));
        }
    }

    private static void mergeUses(ResolveSession session, Resource current, Packages currentPkgs, Capability mergeCap, List<Requirement> blameReqs, Capability matchingCap, Map<Resource, Packages> resourcePkgMap, Set<Capability> cycleMap, Logger logger) {
        if (current.equals(mergeCap.getResource())) {
            return;
        }
        if (!cycleMap.add(mergeCap)) {
            return;
        }
        for (Capability candSourceCap : PackageSpaces.getPackageSources(mergeCap, resourcePkgMap)) {
            String s = candSourceCap.getDirectives().get("uses");
            if (s == null || s.length() <= 0) continue;
            List<String> uses = (List<String>)session.getUsesCache().get(s);
            if (uses == null) {
                uses = PackageSpaces.parseUses(s);
                session.getUsesCache().put(s, uses);
            }
            Packages candSourcePkgs = resourcePkgMap.get(candSourceCap.getResource());
            for (String usedPkgName : uses) {
                List<Blame> candSourceBlames;
                Blame candExportedBlame = candSourcePkgs.m_exportedPkgs.get(usedPkgName);
                if (candExportedBlame != null) {
                    candSourceBlames = Collections.singletonList(candExportedBlame);
                } else {
                    candSourceBlames = candSourcePkgs.m_requiredPkgs.get(usedPkgName);
                    if (candSourceBlames == null) {
                        candSourceBlames = candSourcePkgs.m_importedPkgs.get(usedPkgName);
                    }
                }
                if (candSourceBlames == null) continue;
                ArrayMap<Set<Capability>, UsedBlames> usedPkgBlames = currentPkgs.m_usedPkgs.getOrCompute(usedPkgName);
                ArrayList<Blame> newBlames = new ArrayList<Blame>();
                for (Blame blame : candSourceBlames) {
                    List<Requirement> newBlameReqs;
                    if (blame.m_reqs != null) {
                        newBlameReqs = new ArrayList<Requirement>(blameReqs.size() + 1);
                        newBlameReqs.addAll(blameReqs);
                        newBlameReqs.add(blame.m_reqs.get(blame.m_reqs.size() - 1));
                    } else {
                        newBlameReqs = blameReqs;
                    }
                    newBlames.add(new Blame(blame.m_cap, newBlameReqs));
                }
                PackageSpaces.addUsedBlames(usedPkgBlames, newBlames, matchingCap, resourcePkgMap, logger);
                for (Blame newBlame : newBlames) {
                    PackageSpaces.mergeUses(session, current, currentPkgs, newBlame.m_cap, newBlame.m_reqs, matchingCap, resourcePkgMap, cycleMap, logger);
                }
            }
        }
    }

    private static void computeUses(ResolveSession session, Map<Resource, List<WireCandidate>> allWireCandidates, Map<Resource, Packages> resourcePkgMap, Resource resource, Logger logger) {
        boolean isDynamicImporting;
        List<WireCandidate> wireCandidates = allWireCandidates.get(resource);
        Packages resourcePkgs = resourcePkgMap.get(resource);
        Wiring wiring = session.getContext().getWirings().get(resource);
        HashSet<Capability> usesCycleMap = new HashSet<Capability>();
        int size = wireCandidates.size();
        boolean bl = isDynamicImporting = size > 0 && Util.isDynamic(wireCandidates.get((int)(size - 1)).requirement);
        if (wiring == null || isDynamicImporting) {
            List<Requirement> blameReqs;
            for (WireCandidate wireCandidate : wireCandidates) {
                Requirement req = wireCandidate.requirement;
                Capability cap = wireCandidate.capability;
                if (req.getNamespace().equals("osgi.wiring.bundle") || req.getNamespace().equals("osgi.wiring.package")) continue;
                blameReqs = Collections.singletonList(req);
                PackageSpaces.mergeUses(session, resource, resourcePkgs, cap, blameReqs, cap, resourcePkgMap, usesCycleMap, logger);
            }
            for (List list : resourcePkgs.m_importedPkgs.values()) {
                for (Blame blame : list) {
                    blameReqs = Collections.singletonList(blame.m_reqs.get(0));
                    PackageSpaces.mergeUses(session, resource, resourcePkgs, blame.m_cap, blameReqs, null, resourcePkgMap, usesCycleMap, logger);
                }
            }
            for (List list : resourcePkgs.m_requiredPkgs.values()) {
                for (Blame blame : list) {
                    blameReqs = Collections.singletonList(blame.m_reqs.get(0));
                    PackageSpaces.mergeUses(session, resource, resourcePkgs, blame.m_cap, blameReqs, null, resourcePkgMap, usesCycleMap, logger);
                }
            }
        }
    }

    private static List<String> parseUses(String s) {
        int nb = 1;
        int l = s.length();
        int i = 0;
        while (i < l) {
            if (s.charAt(i) == ',') {
                ++nb;
            }
            ++i;
        }
        ArrayList<String> uses = new ArrayList<String>(nb);
        int start = 0;
        while (true) {
            if (start < l) {
                char c = s.charAt(start);
                if (c == ' ' || c == ',') {
                    ++start;
                    continue;
                }
            }
            int end = start + 1;
            while (end < l) {
                char c = s.charAt(end);
                if (c == ' ' || c == ',') break;
                ++end;
            }
            if (start >= l) break;
            uses.add(s.substring(start, end));
            start = end + 1;
        }
        return uses;
    }

    private static void addUsedBlames(ArrayMap<Set<Capability>, UsedBlames> usedBlames, Collection<Blame> blames, Capability matchingCap, Map<Resource, Packages> resourcePkgMap, Logger logger) {
        Set<Object> usedCaps;
        if (blames.size() == 1) {
            usedCaps = PackageSpaces.getPackageSources(blames.iterator().next().m_cap, resourcePkgMap);
        } else {
            usedCaps = new HashSet();
            for (Blame blame : blames) {
                usedCaps.addAll(PackageSpaces.getPackageSources(blame.m_cap, resourcePkgMap));
            }
        }
        if (usedCaps.isEmpty()) {
            logger.log(3, "Package sources are empty for used capability: " + blames);
            return;
        }
        UsedBlames addToBlame = usedBlames.getOrCompute(usedCaps);
        for (Blame blame : blames) {
            addToBlame.addBlame(blame, matchingCap);
        }
    }

    private static OpenHashMap<String, Blame> calculateExportedPackages(ResolveSession session, Candidates allCandidates, Resource resource, OpenHashMap<String, Blame> exports, OpenHashMap<String, Blame> substitutes) {
        block6: {
            block5: {
                Wiring wiring = session.getContext().getWirings().get(resource);
                List<Capability> caps = wiring != null ? wiring.getResourceCapabilities(null) : resource.getCapabilities(null);
                for (Capability cap : caps) {
                    if (!cap.getNamespace().equals("osgi.wiring.package")) continue;
                    if (!cap.getResource().equals(resource)) {
                        cap = new WrappedCapability(resource, cap);
                    }
                    exports.put((String)cap.getAttributes().get("osgi.wiring.package"), new Blame(cap, null));
                }
                if (wiring == null) break block5;
                for (Wire wire : session.getContext().getSubstitutionWires(wiring)) {
                    Capability cap = wire.getCapability();
                    if (!cap.getResource().equals(wire.getProvider())) {
                        cap = new WrappedCapability(wire.getProvider(), cap);
                    }
                    substitutes.put((String)cap.getAttributes().get("osgi.wiring.package"), new Blame(cap, null));
                }
                break block6;
            }
            if (exports.isEmpty()) break block6;
            for (Requirement req : resource.getRequirements(null)) {
                String pkgName;
                Blame blame;
                Capability cand;
                if (!req.getNamespace().equals("osgi.wiring.package") || (cand = allCandidates.getFirstCandidate(req)) == null || (blame = exports.remove(pkgName = (String)cand.getAttributes().get("osgi.wiring.package"))) == null) continue;
                substitutes.put(pkgName, new Blame(cand, null));
            }
        }
        return exports;
    }
}

