/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.preferences.PHPTemplateStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class UntitledPHPDocumentWizard
extends Wizard
implements INewWizard {
    private IWorkbenchWindow fWindow;
    private static final String UNTITLED_EDITOR_ID = "org.eclipse.php.untitledPHPEditor";
    private static final String UNTITLED_PHP_DOC_PREFIX = "PHPDocument";

    public UntitledPHPDocumentWizard() {
    }

    public UntitledPHPDocumentWizard(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void dispose() {
        this.fWindow = null;
    }

    public boolean performFinish() {
        block5: {
            Template template;
            StructuredTextEditor textEditor;
            block7: {
                String templateName;
                block6: {
                    IPath stateLocation = PHPUiPlugin.getDefault().getStateLocation();
                    IPath path = stateLocation.append("/_" + new Object().hashCode());
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
                    NonExistingPHPFileEditorInput input = new NonExistingPHPFileEditorInput(fileStore, UNTITLED_PHP_DOC_PREFIX);
                    File realFile = input.getPath((Object)input).toFile();
                    realFile.deleteOnExit();
                    IWorkbenchPage page = this.fWindow.getActivePage();
                    IEditorPart editor = page.openEditor((IEditorInput)input, UNTITLED_EDITOR_ID);
                    textEditor = null;
                    if (!(editor instanceof StructuredTextEditor)) break block5;
                    textEditor = (StructuredTextEditor)editor;
                    templateName = PHPUiPlugin.getDefault().getPreferenceStore().getString("newFileTemplateName");
                    if (templateName != null && templateName.length() != 0) break block6;
                    return true;
                }
                TemplateStore templateStore = PHPUiPlugin.getDefault().getCodeTemplateStore();
                template = templateStore.findTemplate(templateName);
                if (template != null) break block7;
                return true;
            }
            try {
                PHPTemplateStore.CompiledTemplate compiledTemplate = PHPTemplateStore.compileTemplate(PHPUiPlugin.getDefault().getCodeTemplateContextRegistry(), template);
                IDocumentProvider documentProvider = textEditor.getDocumentProvider();
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                document.set(compiledTemplate.string);
                documentProvider.saveDocument(null, (Object)textEditor.getEditorInput(), document, true);
                textEditor.selectAndReveal(compiledTemplate.offset, 0);
                document.replace(0, 0, "");
            }
            catch (CoreException e) {
                Logger.logException(e);
                return false;
            }
            catch (BadLocationException e) {
                Logger.logException(e);
                return true;
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWindow = workbench.getActiveWorkbenchWindow();
    }
}

