import type { Disposable, DocumentSelector, LanguageServiceContext, LanguageServicePlugin, ProviderResult } from '@volar/language-service';
import type * as html from 'vscode-html-languageservice';
import type { TextDocument } from 'vscode-languageserver-textdocument';
import * as pug from './lib/languageService';
export interface Provide {
    'pug/pugDocument': (document: TextDocument) => pug.PugDocument | undefined;
    'pug/languageService': () => pug.LanguageService;
}
export declare function create({ documentSelector, configurationSections, useDefaultDataProvider, getCustomData, onDidChangeCustomData, }?: {
    documentSelector?: DocumentSelector;
    configurationSections?: {
        autoCreateQuotes: string;
    };
    useDefaultDataProvider?: boolean;
    getCustomData?(context: LanguageServiceContext): ProviderResult<html.IHTMLDataProvider[]>;
    onDidChangeCustomData?(listener: () => void, context: LanguageServiceContext): Disposable;
}): LanguageServicePlugin;
//# sourceMappingURL=index.d.ts.map